package net.leanix.webhooks.api;

import java.util.LinkedList;
import java.util.List;
import java.util.TimerTask;
import java.util.concurrent.LinkedBlockingDeque;
import net.leanix.dropkit.apiclient.ApiException;
import net.leanix.webhooks.api.models.Event;
import net.leanix.webhooks.api.models.EventBatch;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SendEventTimerTask extends TimerTask {

    private final EventSubmitter eventSubmitter;
    private LinkedBlockingDeque<Event> queue;
    private final static Logger LOG = LoggerFactory.getLogger(SendEventTimerTask.class);
    private EventBatch currentBatch;
    private int maxBatchSize;

    public SendEventTimerTask(EventSubmitter eventSubmitter, LinkedBlockingDeque<Event> queue, int maxBatchSize) {
        this.eventSubmitter = eventSubmitter;
        this.queue = queue;
        this.maxBatchSize = maxBatchSize;
    }

    @Override
    public void run() {
        if (currentBatch == null) {
            currentBatch = new EventBatch();
            List<Event> events = new LinkedList<>();
            queue.drainTo(events, maxBatchSize);
            currentBatch.setEvents(events);
        }

        if (!currentBatch.getEvents().isEmpty()) {
            int size = currentBatch.getEvents().size();
            LOG.info("sending {} events to webhooks. {} still in queue.", size, queue.size());
            try {
                eventSubmitter.submitEventBatch(currentBatch);
            } catch (ApiException e) {
                LOG.error("failed to send {} events to webhooks. Next sending of events will include the failed events", size);
                return;
            }
        }
        currentBatch = null;
    }
}

