package net.leanix.webhooks.api.models;

import com.fasterxml.jackson.annotation.JsonRawValue;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.util.Objects;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import net.leanix.dropkit.apiclient.RawJsonDeserializer;


public class Event   {
  
  private Date createdAt = null;
  private String type = null;
  private String sourceName = null;
  private String sourceId = null;
  private String sourceUrl = null;
  private String workspaceId = null;
  private String userId = null;
  private List<String> tags = new ArrayList<String>();
  private String payload = null;

  
  /**
   * The date at which the event was originally created.
   **/
  public Event createdAt(Date createdAt) {
    this.createdAt = createdAt;
    return this;
  }
  
  @ApiModelProperty(example = "null", value = "The date at which the event was originally created.")
  @JsonProperty("createdAt")
  public Date getCreatedAt() {
    return createdAt;
  }
  public void setCreatedAt(Date createdAt) {
    this.createdAt = createdAt;
  }

  
  /**
   **/
  public Event type(String type) {
    this.type = type;
    return this;
  }
  
  @ApiModelProperty(example = "null", value = "")
  @JsonProperty("type")
  public String getType() {
    return type;
  }
  public void setType(String type) {
    this.type = type;
  }

  
  /**
   * The name of the source system, e.g. EAM or MTM.
   **/
  public Event sourceName(String sourceName) {
    this.sourceName = sourceName;
    return this;
  }
  
  @ApiModelProperty(example = "null", value = "The name of the source system, e.g. EAM or MTM.")
  @JsonProperty("sourceName")
  public String getSourceName() {
    return sourceName;
  }
  public void setSourceName(String sourceName) {
    this.sourceName = sourceName;
  }

  
  /**
   * The id in the source system.
   **/
  public Event sourceId(String sourceId) {
    this.sourceId = sourceId;
    return this;
  }
  
  @ApiModelProperty(example = "null", value = "The id in the source system.")
  @JsonProperty("sourceId")
  public String getSourceId() {
    return sourceId;
  }
  public void setSourceId(String sourceId) {
    this.sourceId = sourceId;
  }

  
  /**
   * The url of the source system, e.g. https://app.leanix.net.
   **/
  public Event sourceUrl(String sourceUrl) {
    this.sourceUrl = sourceUrl;
    return this;
  }
  
  @ApiModelProperty(example = "null", value = "The url of the source system, e.g. https://app.leanix.net.")
  @JsonProperty("sourceUrl")
  public String getSourceUrl() {
    return sourceUrl;
  }
  public void setSourceUrl(String sourceUrl) {
    this.sourceUrl = sourceUrl;
  }

  
  /**
   * An optional UUID string if the event is related to a workspace.
   **/
  public Event workspaceId(String workspaceId) {
    this.workspaceId = workspaceId;
    return this;
  }
  
  @ApiModelProperty(example = "null", value = "An optional UUID string if the event is related to a workspace.")
  @JsonProperty("workspaceId")
  public String getWorkspaceId() {
    return workspaceId;
  }
  public void setWorkspaceId(String workspaceId) {
    this.workspaceId = workspaceId;
  }

  
  /**
   * An optional UUID string if the event is related to a user.
   **/
  public Event userId(String userId) {
    this.userId = userId;
    return this;
  }
  
  @ApiModelProperty(example = "null", value = "An optional UUID string if the event is related to a user.")
  @JsonProperty("userId")
  public String getUserId() {
    return userId;
  }
  public void setUserId(String userId) {
    this.userId = userId;
  }

  
  /**
   * a list of tags describing the nature of this event, used to find subscriptions for this event
   **/
  public Event tags(List<String> tags) {
    this.tags = tags;
    return this;
  }
  
  @ApiModelProperty(example = "null", value = "a list of tags describing the nature of this event, used to find subscriptions for this event")
  @JsonProperty("tags")
  public List<String> getTags() {
    return tags;
  }
  public void setTags(List<String> tags) {
    this.tags = tags;
  }

  
  /**
   **/
  @JsonDeserialize(using = RawJsonDeserializer.class)
  public Event payload(String payload) {
    this.payload = payload;
    return this;
  }

  @JsonRawValue
  @ApiModelProperty(example = "null", value = "")
  @JsonProperty("payload")
  public String getPayload() {
    return payload;
  }
  public void setPayload(String payload) {
    this.payload = payload;
  }

  

  @Override
  public boolean equals(java.lang.Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    Event event = (Event) o;
    return Objects.equals(this.createdAt, event.createdAt) &&
        Objects.equals(this.type, event.type) &&
        Objects.equals(this.sourceName, event.sourceName) &&
        Objects.equals(this.sourceId, event.sourceId) &&
        Objects.equals(this.sourceUrl, event.sourceUrl) &&
        Objects.equals(this.workspaceId, event.workspaceId) &&
        Objects.equals(this.userId, event.userId) &&
        Objects.equals(this.tags, event.tags) &&
        Objects.equals(this.payload, event.payload);
  }

  @Override
  public int hashCode() {
    return Objects.hash(createdAt, type, sourceName, sourceId, sourceUrl, workspaceId, userId, tags, payload);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class Event {\n");
    
    sb.append("    createdAt: ").append(toIndentedString(createdAt)).append("\n");
    sb.append("    type: ").append(toIndentedString(type)).append("\n");
    sb.append("    sourceName: ").append(toIndentedString(sourceName)).append("\n");
    sb.append("    sourceId: ").append(toIndentedString(sourceId)).append("\n");
    sb.append("    sourceUrl: ").append(toIndentedString(sourceUrl)).append("\n");
    sb.append("    workspaceId: ").append(toIndentedString(workspaceId)).append("\n");
    sb.append("    userId: ").append(toIndentedString(userId)).append("\n");
    sb.append("    tags: ").append(toIndentedString(tags)).append("\n");
    sb.append("    payload: ").append(toIndentedString(payload)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(java.lang.Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }
}

