package net.leanix.webhooks.api.models;

import java.util.Objects;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.Date;






public class Watcher   {
  
  private String id = null;
  private String workspaceId = null;
  private String type = null;
  private Date lastRun = null;
  private Date lastUpdate = null;
  private String config = null;
  private String targetUrl = null;
  private String targetMethod = null;
  private String payload = null;
  private String name = null;

  
  /**
   **/
  public Watcher id(String id) {
    this.id = id;
    return this;
  }
  
  @ApiModelProperty(example = "null", value = "")
  @JsonProperty("id")
  public String getId() {
    return id;
  }
  public void setId(String id) {
    this.id = id;
  }

  
  /**
   **/
  public Watcher workspaceId(String workspaceId) {
    this.workspaceId = workspaceId;
    return this;
  }
  
  @ApiModelProperty(example = "null", value = "")
  @JsonProperty("workspaceId")
  public String getWorkspaceId() {
    return workspaceId;
  }
  public void setWorkspaceId(String workspaceId) {
    this.workspaceId = workspaceId;
  }

  
  /**
   **/
  public Watcher type(String type) {
    this.type = type;
    return this;
  }
  
  @ApiModelProperty(example = "null", value = "")
  @JsonProperty("type")
  public String getType() {
    return type;
  }
  public void setType(String type) {
    this.type = type;
  }

  
  /**
   **/
  public Watcher lastRun(Date lastRun) {
    this.lastRun = lastRun;
    return this;
  }
  
  @ApiModelProperty(example = "null", value = "")
  @JsonProperty("lastRun")
  public Date getLastRun() {
    return lastRun;
  }
  public void setLastRun(Date lastRun) {
    this.lastRun = lastRun;
  }

  
  /**
   **/
  public Watcher lastUpdate(Date lastUpdate) {
    this.lastUpdate = lastUpdate;
    return this;
  }
  
  @ApiModelProperty(example = "null", value = "")
  @JsonProperty("lastUpdate")
  public Date getLastUpdate() {
    return lastUpdate;
  }
  public void setLastUpdate(Date lastUpdate) {
    this.lastUpdate = lastUpdate;
  }

  
  /**
   **/
  public Watcher config(String config) {
    this.config = config;
    return this;
  }
  
  @ApiModelProperty(example = "null", value = "")
  @JsonProperty("config")
  public String getConfig() {
    return config;
  }
  public void setConfig(String config) {
    this.config = config;
  }

  
  /**
   **/
  public Watcher targetUrl(String targetUrl) {
    this.targetUrl = targetUrl;
    return this;
  }
  
  @ApiModelProperty(example = "null", value = "")
  @JsonProperty("targetUrl")
  public String getTargetUrl() {
    return targetUrl;
  }
  public void setTargetUrl(String targetUrl) {
    this.targetUrl = targetUrl;
  }

  
  /**
   **/
  public Watcher targetMethod(String targetMethod) {
    this.targetMethod = targetMethod;
    return this;
  }
  
  @ApiModelProperty(example = "null", value = "")
  @JsonProperty("targetMethod")
  public String getTargetMethod() {
    return targetMethod;
  }
  public void setTargetMethod(String targetMethod) {
    this.targetMethod = targetMethod;
  }

  
  /**
   **/
  public Watcher payload(String payload) {
    this.payload = payload;
    return this;
  }
  
  @ApiModelProperty(example = "null", value = "")
  @JsonProperty("payload")
  public String getPayload() {
    return payload;
  }
  public void setPayload(String payload) {
    this.payload = payload;
  }

  
  /**
   **/
  public Watcher name(String name) {
    this.name = name;
    return this;
  }
  
  @ApiModelProperty(example = "null", value = "")
  @JsonProperty("name")
  public String getName() {
    return name;
  }
  public void setName(String name) {
    this.name = name;
  }

  

  @Override
  public boolean equals(java.lang.Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    Watcher watcher = (Watcher) o;
    return Objects.equals(this.id, watcher.id) &&
        Objects.equals(this.workspaceId, watcher.workspaceId) &&
        Objects.equals(this.type, watcher.type) &&
        Objects.equals(this.lastRun, watcher.lastRun) &&
        Objects.equals(this.lastUpdate, watcher.lastUpdate) &&
        Objects.equals(this.config, watcher.config) &&
        Objects.equals(this.targetUrl, watcher.targetUrl) &&
        Objects.equals(this.targetMethod, watcher.targetMethod) &&
        Objects.equals(this.payload, watcher.payload) &&
        Objects.equals(this.name, watcher.name);
  }

  @Override
  public int hashCode() {
    return Objects.hash(id, workspaceId, type, lastRun, lastUpdate, config, targetUrl, targetMethod, payload, name);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class Watcher {\n");
    
    sb.append("    id: ").append(toIndentedString(id)).append("\n");
    sb.append("    workspaceId: ").append(toIndentedString(workspaceId)).append("\n");
    sb.append("    type: ").append(toIndentedString(type)).append("\n");
    sb.append("    lastRun: ").append(toIndentedString(lastRun)).append("\n");
    sb.append("    lastUpdate: ").append(toIndentedString(lastUpdate)).append("\n");
    sb.append("    config: ").append(toIndentedString(config)).append("\n");
    sb.append("    targetUrl: ").append(toIndentedString(targetUrl)).append("\n");
    sb.append("    targetMethod: ").append(toIndentedString(targetMethod)).append("\n");
    sb.append("    payload: ").append(toIndentedString(payload)).append("\n");
    sb.append("    name: ").append(toIndentedString(name)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(java.lang.Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }
}

