/*
 * Decompiled with CFR 0.152.
 */
package net.leanix.dropkit.apiclient;

import java.net.URI;
import net.leanix.dropkit.apiclient.ApiClient;

public class ApiClientBuilder {
    private String basePath;
    private URI oauth2TokenUri;
    private String clientId;
    private String clientSecret;
    private String personalAccessToken;
    private boolean debugging = false;

    public ApiClient build() {
        if (this.basePath == null) {
            throw new RuntimeException("Missing to specify the base path of ApiClient!");
        }
        ApiClient apiClient = new ApiClient();
        apiClient.setDebugging(this.debugging);
        if (this.personalAccessToken != null && !this.personalAccessToken.isEmpty()) {
            apiClient.setPersonalAccessToken(this.personalAccessToken, this.oauth2TokenUri);
        } else if (this.clientId != null && this.clientSecret != null) {
            apiClient.setClientCredentials(this.clientId, this.clientSecret, this.oauth2TokenUri);
        }
        apiClient.setBasePath(this.basePath);
        return apiClient;
    }

    public ApiClientBuilder withBasePath(String basePath) {
        this.basePath = basePath;
        return this;
    }

    public ApiClientBuilder withTokenProviderHost(String host) {
        this.withOAuth2TokenUrl(URI.create(String.format("https://%s/services/mtm/v1/oauth2/token", host)));
        return this;
    }

    public ApiClientBuilder withClientCredentials(String clientId, String clientSecret) {
        this.clientId = clientId;
        this.clientSecret = clientSecret;
        return this;
    }

    public ApiClientBuilder withPersonalAccessToken(String personalAccessToken) {
        this.personalAccessToken = personalAccessToken;
        return this;
    }

    public ApiClientBuilder withOAuth2TokenUrl(URI uri) {
        this.oauth2TokenUri = uri;
        return this;
    }

    public ApiClientBuilder withDebugging(boolean debugging) {
        this.debugging = debugging;
        return this;
    }
}

