/*
 * Decompiled with CFR 0.152.
 */
package net.leanix.webhooks.api;

import java.util.ArrayList;
import java.util.HashMap;
import javax.ws.rs.core.GenericType;
import net.leanix.dropkit.apiclient.ApiClient;
import net.leanix.dropkit.apiclient.ApiException;
import net.leanix.dropkit.apiclient.Configuration;
import net.leanix.dropkit.apiclient.Pair;
import net.leanix.webhooks.api.models.DeliveryListResponse;
import net.leanix.webhooks.api.models.EventListResponse;
import net.leanix.webhooks.api.models.Subscription;
import net.leanix.webhooks.api.models.SubscriptionListResponse;
import net.leanix.webhooks.api.models.SubscriptionResponse;

public class SubscriptionsApi {
    private ApiClient apiClient;

    public SubscriptionsApi() {
        this(Configuration.getDefaultApiClient());
    }

    public SubscriptionsApi(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return this.apiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public SubscriptionResponse createSubscription(Subscription body) throws ApiException {
        Subscription localVarPostBody = body;
        if (body == null) {
            throw new ApiException(400, "Missing the required parameter 'body' when calling createSubscription");
        }
        String localVarPath = "/subscriptions".replaceAll("\\{format\\}", "json");
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"token"};
        GenericType<SubscriptionResponse> localVarReturnType = new GenericType<SubscriptionResponse>(){};
        return this.apiClient.invokeAPI(localVarPath, "POST", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public SubscriptionResponse deleteSubscription(String id) throws ApiException {
        Object localVarPostBody = null;
        if (id == null) {
            throw new ApiException(400, "Missing the required parameter 'id' when calling deleteSubscription");
        }
        String localVarPath = "/subscriptions/{id}".replaceAll("\\{format\\}", "json").replaceAll("\\{id\\}", this.apiClient.escapeString(id.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"token"};
        GenericType<SubscriptionResponse> localVarReturnType = new GenericType<SubscriptionResponse>(){};
        return this.apiClient.invokeAPI(localVarPath, "DELETE", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public SubscriptionResponse getSubscription(String id) throws ApiException {
        Object localVarPostBody = null;
        if (id == null) {
            throw new ApiException(400, "Missing the required parameter 'id' when calling getSubscription");
        }
        String localVarPath = "/subscriptions/{id}".replaceAll("\\{format\\}", "json").replaceAll("\\{id\\}", this.apiClient.escapeString(id.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"token"};
        GenericType<SubscriptionResponse> localVarReturnType = new GenericType<SubscriptionResponse>(){};
        return this.apiClient.invokeAPI(localVarPath, "GET", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public DeliveryListResponse getSubscriptionDeliveries(String id, Integer page, Integer size, String sort) throws ApiException {
        Object localVarPostBody = null;
        if (id == null) {
            throw new ApiException(400, "Missing the required parameter 'id' when calling getSubscriptionDeliveries");
        }
        String localVarPath = "/subscriptions/{id}/deliveries".replaceAll("\\{format\\}", "json").replaceAll("\\{id\\}", this.apiClient.escapeString(id.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "page", page));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "size", size));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "sort", sort));
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"token"};
        GenericType<DeliveryListResponse> localVarReturnType = new GenericType<DeliveryListResponse>(){};
        return this.apiClient.invokeAPI(localVarPath, "GET", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public EventListResponse getSubscriptionEvents(String id, Boolean withPayload, Integer page, Integer size, String sort) throws ApiException {
        Object localVarPostBody = null;
        if (id == null) {
            throw new ApiException(400, "Missing the required parameter 'id' when calling getSubscriptionEvents");
        }
        String localVarPath = "/subscriptions/{id}/events".replaceAll("\\{format\\}", "json").replaceAll("\\{id\\}", this.apiClient.escapeString(id.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "withPayload", withPayload));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "page", page));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "size", size));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "sort", sort));
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"token"};
        GenericType<EventListResponse> localVarReturnType = new GenericType<EventListResponse>(){};
        return this.apiClient.invokeAPI(localVarPath, "GET", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public SubscriptionListResponse getSubscriptions(String workspaceId, String identifier) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/subscriptions".replaceAll("\\{format\\}", "json");
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "workspaceId", workspaceId));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "identifier", identifier));
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"token"};
        GenericType<SubscriptionListResponse> localVarReturnType = new GenericType<SubscriptionListResponse>(){};
        return this.apiClient.invokeAPI(localVarPath, "GET", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public SubscriptionResponse updateSubscription(String id, Subscription body) throws ApiException {
        Subscription localVarPostBody = body;
        if (id == null) {
            throw new ApiException(400, "Missing the required parameter 'id' when calling updateSubscription");
        }
        if (body == null) {
            throw new ApiException(400, "Missing the required parameter 'body' when calling updateSubscription");
        }
        String localVarPath = "/subscriptions/{id}".replaceAll("\\{format\\}", "json").replaceAll("\\{id\\}", this.apiClient.escapeString(id.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"token"};
        GenericType<SubscriptionResponse> localVarReturnType = new GenericType<SubscriptionResponse>(){};
        return this.apiClient.invokeAPI(localVarPath, "PUT", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }
}

