/*
 * Decompiled with CFR 0.152.
 */
package net.leanix.webhooks.api.models;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonRawValue;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import net.leanix.dropkit.apiclient.RawJsonDeserializer;

public class Event {
    private Date createdAt = null;
    private String type = null;
    private String sourceName = null;
    private String sourceId = null;
    private String sourceUrl = null;
    private String workspaceId = null;
    private String userId = null;
    private List<String> tags = new ArrayList<String>();
    private String payload = null;

    public Event createdAt(Date createdAt) {
        this.createdAt = createdAt;
        return this;
    }

    @ApiModelProperty(example="null", value="The date at which the event was originally created.")
    @JsonProperty(value="createdAt")
    public Date getCreatedAt() {
        return this.createdAt;
    }

    public void setCreatedAt(Date createdAt) {
        this.createdAt = createdAt;
    }

    public Event type(String type) {
        this.type = type;
        return this;
    }

    @ApiModelProperty(example="null", value="")
    @JsonProperty(value="type")
    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public Event sourceName(String sourceName) {
        this.sourceName = sourceName;
        return this;
    }

    @ApiModelProperty(example="null", value="The name of the source system, e.g. EAM or MTM.")
    @JsonProperty(value="sourceName")
    public String getSourceName() {
        return this.sourceName;
    }

    public void setSourceName(String sourceName) {
        this.sourceName = sourceName;
    }

    public Event sourceId(String sourceId) {
        this.sourceId = sourceId;
        return this;
    }

    @ApiModelProperty(example="null", value="The id in the source system.")
    @JsonProperty(value="sourceId")
    public String getSourceId() {
        return this.sourceId;
    }

    public void setSourceId(String sourceId) {
        this.sourceId = sourceId;
    }

    public Event sourceUrl(String sourceUrl) {
        this.sourceUrl = sourceUrl;
        return this;
    }

    @ApiModelProperty(example="null", value="The url of the source system, e.g. https://app.leanix.net.")
    @JsonProperty(value="sourceUrl")
    public String getSourceUrl() {
        return this.sourceUrl;
    }

    public void setSourceUrl(String sourceUrl) {
        this.sourceUrl = sourceUrl;
    }

    public Event workspaceId(String workspaceId) {
        this.workspaceId = workspaceId;
        return this;
    }

    @ApiModelProperty(example="null", value="An optional UUID string if the event is related to a workspace.")
    @JsonProperty(value="workspaceId")
    public String getWorkspaceId() {
        return this.workspaceId;
    }

    public void setWorkspaceId(String workspaceId) {
        this.workspaceId = workspaceId;
    }

    public Event userId(String userId) {
        this.userId = userId;
        return this;
    }

    @ApiModelProperty(example="null", value="An optional UUID string if the event is related to a user.")
    @JsonProperty(value="userId")
    public String getUserId() {
        return this.userId;
    }

    public void setUserId(String userId) {
        this.userId = userId;
    }

    public Event tags(List<String> tags) {
        this.tags = tags;
        return this;
    }

    @ApiModelProperty(example="null", value="a list of tags describing the nature of this event, used to find subscriptions for this event")
    @JsonProperty(value="tags")
    public List<String> getTags() {
        return this.tags;
    }

    public void setTags(List<String> tags) {
        this.tags = tags;
    }

    @JsonDeserialize(using=RawJsonDeserializer.class)
    public Event payload(String payload) {
        this.payload = payload;
        return this;
    }

    @JsonRawValue
    @ApiModelProperty(example="null", value="")
    @JsonProperty(value="payload")
    public String getPayload() {
        return this.payload;
    }

    public void setPayload(String payload) {
        this.payload = payload;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Event event = (Event)o;
        return Objects.equals(this.createdAt, event.createdAt) && Objects.equals(this.type, event.type) && Objects.equals(this.sourceName, event.sourceName) && Objects.equals(this.sourceId, event.sourceId) && Objects.equals(this.sourceUrl, event.sourceUrl) && Objects.equals(this.workspaceId, event.workspaceId) && Objects.equals(this.userId, event.userId) && Objects.equals(this.tags, event.tags) && Objects.equals(this.payload, event.payload);
    }

    public int hashCode() {
        return Objects.hash(this.createdAt, this.type, this.sourceName, this.sourceId, this.sourceUrl, this.workspaceId, this.userId, this.tags, this.payload);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class Event {\n");
        sb.append("    createdAt: ").append(this.toIndentedString(this.createdAt)).append("\n");
        sb.append("    type: ").append(this.toIndentedString(this.type)).append("\n");
        sb.append("    sourceName: ").append(this.toIndentedString(this.sourceName)).append("\n");
        sb.append("    sourceId: ").append(this.toIndentedString(this.sourceId)).append("\n");
        sb.append("    sourceUrl: ").append(this.toIndentedString(this.sourceUrl)).append("\n");
        sb.append("    workspaceId: ").append(this.toIndentedString(this.workspaceId)).append("\n");
        sb.append("    userId: ").append(this.toIndentedString(this.userId)).append("\n");
        sb.append("    tags: ").append(this.toIndentedString(this.tags)).append("\n");
        sb.append("    payload: ").append(this.toIndentedString(this.payload)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

