package net.leanix.webhooks.api.models;

import java.util.Objects;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.Date;
import java.util.UUID;






public class Delivery   {
  
  private UUID id = null;
  private Date createdAt = null;
  private String requestHeaders = null;
  private String payload = null;
  private String targetUrl = null;
  private String targetMethod = null;
  private String basicAuth = null;
  private Boolean success = false;
  private Integer httpStatus = null;
  private String responseBody = null;
  private String responseHeaders = null;
  private Boolean active = false;

  
  /**
   **/
  public Delivery id(UUID id) {
    this.id = id;
    return this;
  }
  
  @ApiModelProperty(example = "null", value = "")
  @JsonProperty("id")
  public UUID getId() {
    return id;
  }
  public void setId(UUID id) {
    this.id = id;
  }

  
  /**
   **/
  public Delivery createdAt(Date createdAt) {
    this.createdAt = createdAt;
    return this;
  }
  
  @ApiModelProperty(example = "null", value = "")
  @JsonProperty("createdAt")
  public Date getCreatedAt() {
    return createdAt;
  }
  public void setCreatedAt(Date createdAt) {
    this.createdAt = createdAt;
  }

  
  /**
   **/
  public Delivery requestHeaders(String requestHeaders) {
    this.requestHeaders = requestHeaders;
    return this;
  }
  
  @ApiModelProperty(example = "null", value = "")
  @JsonProperty("requestHeaders")
  public String getRequestHeaders() {
    return requestHeaders;
  }
  public void setRequestHeaders(String requestHeaders) {
    this.requestHeaders = requestHeaders;
  }

  
  /**
   **/
  public Delivery payload(String payload) {
    this.payload = payload;
    return this;
  }
  
  @ApiModelProperty(example = "null", value = "")
  @JsonProperty("payload")
  public String getPayload() {
    return payload;
  }
  public void setPayload(String payload) {
    this.payload = payload;
  }

  
  /**
   **/
  public Delivery targetUrl(String targetUrl) {
    this.targetUrl = targetUrl;
    return this;
  }
  
  @ApiModelProperty(example = "null", value = "")
  @JsonProperty("targetUrl")
  public String getTargetUrl() {
    return targetUrl;
  }
  public void setTargetUrl(String targetUrl) {
    this.targetUrl = targetUrl;
  }

  
  /**
   **/
  public Delivery targetMethod(String targetMethod) {
    this.targetMethod = targetMethod;
    return this;
  }
  
  @ApiModelProperty(example = "null", value = "")
  @JsonProperty("targetMethod")
  public String getTargetMethod() {
    return targetMethod;
  }
  public void setTargetMethod(String targetMethod) {
    this.targetMethod = targetMethod;
  }

  
  /**
   **/
  public Delivery basicAuth(String basicAuth) {
    this.basicAuth = basicAuth;
    return this;
  }
  
  @ApiModelProperty(example = "null", value = "")
  @JsonProperty("basicAuth")
  public String getBasicAuth() {
    return basicAuth;
  }
  public void setBasicAuth(String basicAuth) {
    this.basicAuth = basicAuth;
  }

  
  /**
   **/
  public Delivery success(Boolean success) {
    this.success = success;
    return this;
  }
  
  @ApiModelProperty(example = "null", value = "")
  @JsonProperty("success")
  public Boolean getSuccess() {
    return success;
  }
  public void setSuccess(Boolean success) {
    this.success = success;
  }

  
  /**
   **/
  public Delivery httpStatus(Integer httpStatus) {
    this.httpStatus = httpStatus;
    return this;
  }
  
  @ApiModelProperty(example = "null", required = true, value = "")
  @JsonProperty("httpStatus")
  public Integer getHttpStatus() {
    return httpStatus;
  }
  public void setHttpStatus(Integer httpStatus) {
    this.httpStatus = httpStatus;
  }

  
  /**
   **/
  public Delivery responseBody(String responseBody) {
    this.responseBody = responseBody;
    return this;
  }
  
  @ApiModelProperty(example = "null", value = "")
  @JsonProperty("responseBody")
  public String getResponseBody() {
    return responseBody;
  }
  public void setResponseBody(String responseBody) {
    this.responseBody = responseBody;
  }

  
  /**
   **/
  public Delivery responseHeaders(String responseHeaders) {
    this.responseHeaders = responseHeaders;
    return this;
  }
  
  @ApiModelProperty(example = "null", value = "")
  @JsonProperty("responseHeaders")
  public String getResponseHeaders() {
    return responseHeaders;
  }
  public void setResponseHeaders(String responseHeaders) {
    this.responseHeaders = responseHeaders;
  }

  
  /**
   **/
  public Delivery active(Boolean active) {
    this.active = active;
    return this;
  }
  
  @ApiModelProperty(example = "null", value = "")
  @JsonProperty("active")
  public Boolean getActive() {
    return active;
  }
  public void setActive(Boolean active) {
    this.active = active;
  }

  

  @Override
  public boolean equals(java.lang.Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    Delivery delivery = (Delivery) o;
    return Objects.equals(this.id, delivery.id) &&
        Objects.equals(this.createdAt, delivery.createdAt) &&
        Objects.equals(this.requestHeaders, delivery.requestHeaders) &&
        Objects.equals(this.payload, delivery.payload) &&
        Objects.equals(this.targetUrl, delivery.targetUrl) &&
        Objects.equals(this.targetMethod, delivery.targetMethod) &&
        Objects.equals(this.basicAuth, delivery.basicAuth) &&
        Objects.equals(this.success, delivery.success) &&
        Objects.equals(this.httpStatus, delivery.httpStatus) &&
        Objects.equals(this.responseBody, delivery.responseBody) &&
        Objects.equals(this.responseHeaders, delivery.responseHeaders) &&
        Objects.equals(this.active, delivery.active);
  }

  @Override
  public int hashCode() {
    return Objects.hash(id, createdAt, requestHeaders, payload, targetUrl, targetMethod, basicAuth, success, httpStatus, responseBody, responseHeaders, active);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class Delivery {\n");
    
    sb.append("    id: ").append(toIndentedString(id)).append("\n");
    sb.append("    createdAt: ").append(toIndentedString(createdAt)).append("\n");
    sb.append("    requestHeaders: ").append(toIndentedString(requestHeaders)).append("\n");
    sb.append("    payload: ").append(toIndentedString(payload)).append("\n");
    sb.append("    targetUrl: ").append(toIndentedString(targetUrl)).append("\n");
    sb.append("    targetMethod: ").append(toIndentedString(targetMethod)).append("\n");
    sb.append("    basicAuth: ").append(toIndentedString(basicAuth)).append("\n");
    sb.append("    success: ").append(toIndentedString(success)).append("\n");
    sb.append("    httpStatus: ").append(toIndentedString(httpStatus)).append("\n");
    sb.append("    responseBody: ").append(toIndentedString(responseBody)).append("\n");
    sb.append("    responseHeaders: ").append(toIndentedString(responseHeaders)).append("\n");
    sb.append("    active: ").append(toIndentedString(active)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(java.lang.Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }
}

