/*
 * Decompiled with CFR 0.152.
 */
package net.leanix.webhooks.api;

import java.util.LinkedList;
import java.util.TimerTask;
import java.util.concurrent.LinkedBlockingDeque;
import net.leanix.dropkit.apiclient.ApiException;
import net.leanix.webhooks.api.EventSubmitter;
import net.leanix.webhooks.api.models.Event;
import net.leanix.webhooks.api.models.EventBatch;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SendEventTimerTask
extends TimerTask {
    private final EventSubmitter eventSubmitter;
    private LinkedBlockingDeque<Event> queue;
    private static final Logger LOG = LoggerFactory.getLogger(SendEventTimerTask.class);
    private EventBatch currentBatch;
    private int maxBatchSize;

    public SendEventTimerTask(EventSubmitter eventSubmitter, LinkedBlockingDeque<Event> queue, int maxBatchSize) {
        this.eventSubmitter = eventSubmitter;
        this.queue = queue;
        this.maxBatchSize = maxBatchSize;
    }

    @Override
    public void run() {
        if (this.currentBatch == null) {
            this.currentBatch = new EventBatch();
            LinkedList<Event> events = new LinkedList<Event>();
            this.queue.drainTo(events, this.maxBatchSize);
            this.currentBatch.setEvents(events);
        }
        if (!this.currentBatch.getEvents().isEmpty()) {
            int size = this.currentBatch.getEvents().size();
            LOG.info("sending {} events to webhooks. {} still in queue.", (Object)size, (Object)this.queue.size());
            try {
                this.eventSubmitter.submitEventBatch(this.currentBatch);
            }
            catch (ApiException e) {
                LOG.error("failed to send {} events to webhooks. Next sending of events will include the failed events", (Object)size);
                return;
            }
        }
        this.currentBatch = null;
    }
}

