package net.leanix.webhooks.api;

import java.util.Timer;
import java.util.concurrent.LinkedBlockingDeque;
import net.leanix.webhooks.api.models.Event;

public class EventCollector {

    private LinkedBlockingDeque<Event> queue = new LinkedBlockingDeque<>();

    /**
     * Collects webhook events to send them to webhooks with one request at the beginning of every period.
     *
     * @param eventSubmitter Instance that handles the api requests
     * @param interval Number of milliseconds between api requests
     */
    public EventCollector(EventSubmitter eventSubmitter, long interval, int maxBatchSize) {
        Timer timer = new Timer(true);
        SendEventTimerTask eventTimer = new SendEventTimerTask(eventSubmitter, queue, maxBatchSize);
        timer.schedule(eventTimer, 0, interval);
    }

    public boolean submitEvent(Event event) {
        return queue.offer(event);
    }
}

