package net.leanix.webhooks.api;

import net.leanix.dropkit.apiclient.ApiException;
import net.leanix.dropkit.apiclient.ApiClient;
import net.leanix.dropkit.apiclient.Configuration;
import net.leanix.dropkit.apiclient.Pair;

import javax.ws.rs.core.GenericType;

import net.leanix.webhooks.api.models.BasicResponse;
import net.leanix.webhooks.api.models.Cursor;
import net.leanix.webhooks.api.models.DeliveryListResponse;
import net.leanix.webhooks.api.models.PullResultResponse;
import net.leanix.webhooks.api.models.Subscription;
import net.leanix.webhooks.api.models.SubscriptionListResponse;
import net.leanix.webhooks.api.models.SubscriptionResponse;
import java.util.UUID;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;


public class SubscriptionsApi {
  private ApiClient apiClient;

  public SubscriptionsApi() {
    this(Configuration.getDefaultApiClient());
  }

  public SubscriptionsApi(ApiClient apiClient) {
    this.apiClient = apiClient;
  }

  public ApiClient getApiClient() {
    return apiClient;
  }

  public void setApiClient(ApiClient apiClient) {
    this.apiClient = apiClient;
  }

  /**
   * createSubscription
   * Endpoint to create a subscription.
   * @param subscription the subscription to create (required)
   * @return SubscriptionResponse
   * @throws ApiException if fails to make API call
   */
  public SubscriptionResponse createSubscription(Subscription subscription) throws ApiException {
    Object localVarPostBody = subscription;
    
    // verify the required parameter 'subscription' is set
    if (subscription == null) {
      throw new ApiException(400, "Missing the required parameter 'subscription' when calling createSubscription");
    }
    
    // create path and map variables
    String localVarPath = "/subscriptions";

    // query params
    List<Pair> localVarQueryParams = new ArrayList<Pair>();
    Map<String, String> localVarHeaderParams = new HashMap<String, String>();
    Map<String, Object> localVarFormParams = new HashMap<String, Object>();


    
    
    final String[] localVarAccepts = {
      "application/json"
    };
    final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);

    final String[] localVarContentTypes = {
      "application/json"
    };
    final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

    String[] localVarAuthNames = new String[] { "token" };

    GenericType<SubscriptionResponse> localVarReturnType = new GenericType<SubscriptionResponse>() {};
    return apiClient.invokeAPI(localVarPath, "POST", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
      }
  /**
   * deleteSubscription
   * Endpoint to delete a subscription.
   * @param id  (required)
   * @return SubscriptionResponse
   * @throws ApiException if fails to make API call
   */
  public SubscriptionResponse deleteSubscription(UUID id) throws ApiException {
    Object localVarPostBody = null;
    
    // verify the required parameter 'id' is set
    if (id == null) {
      throw new ApiException(400, "Missing the required parameter 'id' when calling deleteSubscription");
    }
    
    // create path and map variables
    String localVarPath = "/subscriptions/{id}"
      .replaceAll("\\{" + "id" + "\\}", apiClient.escapeString(id.toString()));

    // query params
    List<Pair> localVarQueryParams = new ArrayList<Pair>();
    Map<String, String> localVarHeaderParams = new HashMap<String, String>();
    Map<String, Object> localVarFormParams = new HashMap<String, Object>();


    
    
    final String[] localVarAccepts = {
      "application/json"
    };
    final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);

    final String[] localVarContentTypes = {
      "application/json"
    };
    final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

    String[] localVarAuthNames = new String[] { "token" };

    GenericType<SubscriptionResponse> localVarReturnType = new GenericType<SubscriptionResponse>() {};
    return apiClient.invokeAPI(localVarPath, "DELETE", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
      }
  /**
   * getSubscription
   * returns a subscription with a given id
   * @param id the id of the subscription (required)
   * @return SubscriptionResponse
   * @throws ApiException if fails to make API call
   */
  public SubscriptionResponse getSubscription(UUID id) throws ApiException {
    Object localVarPostBody = null;
    
    // verify the required parameter 'id' is set
    if (id == null) {
      throw new ApiException(400, "Missing the required parameter 'id' when calling getSubscription");
    }
    
    // create path and map variables
    String localVarPath = "/subscriptions/{id}"
      .replaceAll("\\{" + "id" + "\\}", apiClient.escapeString(id.toString()));

    // query params
    List<Pair> localVarQueryParams = new ArrayList<Pair>();
    Map<String, String> localVarHeaderParams = new HashMap<String, String>();
    Map<String, Object> localVarFormParams = new HashMap<String, Object>();


    
    
    final String[] localVarAccepts = {
      "application/json"
    };
    final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);

    final String[] localVarContentTypes = {
      "application/json"
    };
    final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

    String[] localVarAuthNames = new String[] { "token" };

    GenericType<SubscriptionResponse> localVarReturnType = new GenericType<SubscriptionResponse>() {};
    return apiClient.invokeAPI(localVarPath, "GET", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
      }
  /**
   * getSubscriptionDeliveries
   * Endpoint to list the deliveries
   * @param id  (required)
   * @param page The page number to access (1 indexed, defaults to 1) (optional, default to 1)
   * @param size The page size requested (defaults to 30, max 100) (optional, default to 30)
   * @param sort Comma-separated list of sorting (default createdAt-DESC) (optional, default to createdAt-desc)
   * @return DeliveryListResponse
   * @throws ApiException if fails to make API call
   */
  public DeliveryListResponse getSubscriptionDeliveries(UUID id, Integer page, Integer size, String sort) throws ApiException {
    Object localVarPostBody = null;
    
    // verify the required parameter 'id' is set
    if (id == null) {
      throw new ApiException(400, "Missing the required parameter 'id' when calling getSubscriptionDeliveries");
    }
    
    // create path and map variables
    String localVarPath = "/subscriptions/{id}/deliveries"
      .replaceAll("\\{" + "id" + "\\}", apiClient.escapeString(id.toString()));

    // query params
    List<Pair> localVarQueryParams = new ArrayList<Pair>();
    Map<String, String> localVarHeaderParams = new HashMap<String, String>();
    Map<String, Object> localVarFormParams = new HashMap<String, Object>();

    localVarQueryParams.addAll(apiClient.parameterToPairs("", "page", page));
    localVarQueryParams.addAll(apiClient.parameterToPairs("", "size", size));
    localVarQueryParams.addAll(apiClient.parameterToPairs("", "sort", sort));

    
    
    final String[] localVarAccepts = {
      "application/json"
    };
    final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);

    final String[] localVarContentTypes = {
      "application/json"
    };
    final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

    String[] localVarAuthNames = new String[] { "token" };

    GenericType<DeliveryListResponse> localVarReturnType = new GenericType<DeliveryListResponse>() {};
    return apiClient.invokeAPI(localVarPath, "GET", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
      }
  /**
   * getSubscriptionEvents
   * Gets the next batch of events for a PULL subscription, waiting for some time if no events happen.
   * @param id Id of the subscription to pull events from. Subscription must be of type PULL. (required)
   * @param autoCommit Should events be marked as retrieved automatically (waives at-least-once delivery guarantee). (optional, default to false)
   * @param timeout The timeout waiting for an event to happen, in seconds (optional, default to 10)
   * @return PullResultResponse
   * @throws ApiException if fails to make API call
   */
  public PullResultResponse getSubscriptionEvents(UUID id, Boolean autoCommit, Integer timeout) throws ApiException {
    Object localVarPostBody = null;
    
    // verify the required parameter 'id' is set
    if (id == null) {
      throw new ApiException(400, "Missing the required parameter 'id' when calling getSubscriptionEvents");
    }
    
    // create path and map variables
    String localVarPath = "/subscriptions/{id}/events"
      .replaceAll("\\{" + "id" + "\\}", apiClient.escapeString(id.toString()));

    // query params
    List<Pair> localVarQueryParams = new ArrayList<Pair>();
    Map<String, String> localVarHeaderParams = new HashMap<String, String>();
    Map<String, Object> localVarFormParams = new HashMap<String, Object>();

    localVarQueryParams.addAll(apiClient.parameterToPairs("", "autoCommit", autoCommit));
    localVarQueryParams.addAll(apiClient.parameterToPairs("", "timeout", timeout));

    
    
    final String[] localVarAccepts = {
      "application/json"
    };
    final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);

    final String[] localVarContentTypes = {
      "application/json"
    };
    final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

    String[] localVarAuthNames = new String[] { "token" };

    GenericType<PullResultResponse> localVarReturnType = new GenericType<PullResultResponse>() {};
    return apiClient.invokeAPI(localVarPath, "GET", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
      }
  /**
   * getSubscriptions
   * Endpoint to list the subscriptions.
   * @param workspaceId an optional workspace id (optional)
   * @param identifier an optional subscription identifier (optional)
   * @return SubscriptionListResponse
   * @throws ApiException if fails to make API call
   */
  public SubscriptionListResponse getSubscriptions(UUID workspaceId, String identifier) throws ApiException {
    Object localVarPostBody = null;
    
    // create path and map variables
    String localVarPath = "/subscriptions";

    // query params
    List<Pair> localVarQueryParams = new ArrayList<Pair>();
    Map<String, String> localVarHeaderParams = new HashMap<String, String>();
    Map<String, Object> localVarFormParams = new HashMap<String, Object>();

    localVarQueryParams.addAll(apiClient.parameterToPairs("", "workspaceId", workspaceId));
    localVarQueryParams.addAll(apiClient.parameterToPairs("", "identifier", identifier));

    
    
    final String[] localVarAccepts = {
      "application/json"
    };
    final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);

    final String[] localVarContentTypes = {
      "application/json"
    };
    final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

    String[] localVarAuthNames = new String[] { "token" };

    GenericType<SubscriptionListResponse> localVarReturnType = new GenericType<SubscriptionListResponse>() {};
    return apiClient.invokeAPI(localVarPath, "GET", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
      }
  /**
   * updateSubscription
   * Endpoint to update a subscription.
   * @param id  (required)
   * @param subscription the updated subscription (required)
   * @return SubscriptionResponse
   * @throws ApiException if fails to make API call
   */
  public SubscriptionResponse updateSubscription(UUID id, Subscription subscription) throws ApiException {
    Object localVarPostBody = subscription;
    
    // verify the required parameter 'id' is set
    if (id == null) {
      throw new ApiException(400, "Missing the required parameter 'id' when calling updateSubscription");
    }
    
    // verify the required parameter 'subscription' is set
    if (subscription == null) {
      throw new ApiException(400, "Missing the required parameter 'subscription' when calling updateSubscription");
    }
    
    // create path and map variables
    String localVarPath = "/subscriptions/{id}"
      .replaceAll("\\{" + "id" + "\\}", apiClient.escapeString(id.toString()));

    // query params
    List<Pair> localVarQueryParams = new ArrayList<Pair>();
    Map<String, String> localVarHeaderParams = new HashMap<String, String>();
    Map<String, Object> localVarFormParams = new HashMap<String, Object>();


    
    
    final String[] localVarAccepts = {
      "application/json"
    };
    final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);

    final String[] localVarContentTypes = {
      "application/json"
    };
    final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

    String[] localVarAuthNames = new String[] { "token" };

    GenericType<SubscriptionResponse> localVarReturnType = new GenericType<SubscriptionResponse>() {};
    return apiClient.invokeAPI(localVarPath, "PUT", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
      }
  /**
   * updateSubscriptionCursor
   * Marks events up to the given offset as consumed for the given subscription.
   * @param id Id of the subscription to pull events from. Subscription must be of type PULL. (required)
   * @param cursor the cursor where to start the next getSubscriptionEvents pull (required)
   * @return BasicResponse
   * @throws ApiException if fails to make API call
   */
  public BasicResponse updateSubscriptionCursor(UUID id, Cursor cursor) throws ApiException {
    Object localVarPostBody = cursor;
    
    // verify the required parameter 'id' is set
    if (id == null) {
      throw new ApiException(400, "Missing the required parameter 'id' when calling updateSubscriptionCursor");
    }
    
    // verify the required parameter 'cursor' is set
    if (cursor == null) {
      throw new ApiException(400, "Missing the required parameter 'cursor' when calling updateSubscriptionCursor");
    }
    
    // create path and map variables
    String localVarPath = "/subscriptions/{id}/cursor"
      .replaceAll("\\{" + "id" + "\\}", apiClient.escapeString(id.toString()));

    // query params
    List<Pair> localVarQueryParams = new ArrayList<Pair>();
    Map<String, String> localVarHeaderParams = new HashMap<String, String>();
    Map<String, Object> localVarFormParams = new HashMap<String, Object>();


    
    
    final String[] localVarAccepts = {
      "application/json"
    };
    final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);

    final String[] localVarContentTypes = {
      "application/json"
    };
    final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

    String[] localVarAuthNames = new String[] { "token" };

    GenericType<BasicResponse> localVarReturnType = new GenericType<BasicResponse>() {};
    return apiClient.invokeAPI(localVarPath, "PUT", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
      }
}
