/*
 * LeanIX Webhooks REST API
 * Sends notifications on trigger events to subscribed observers
 *
 * OpenAPI spec version: 0.10.34-SNAPSHOT
 * 
 *
 * NOTE: This class is auto generated by the swagger code generator program.
 * https://github.com/swagger-api/swagger-codegen.git
 * Do not edit the class manually.
 */


package net.leanix.webhooks.api.models;

import java.util.Objects;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.time.OffsetDateTime;
import java.util.UUID;

/**
 * Delivery
 */

public class Delivery {
  @JsonProperty("id")
  private UUID id = null;

  @JsonProperty("createdAt")
  private OffsetDateTime createdAt = null;

  @JsonProperty("requestHeaders")
  private String requestHeaders = null;

  @JsonProperty("payload")
  private String payload = null;

  @JsonProperty("targetUrl")
  private String targetUrl = null;

  @JsonProperty("targetMethod")
  private String targetMethod = null;

  @JsonProperty("basicAuth")
  private String basicAuth = null;

  @JsonProperty("success")
  private Boolean success = false;

  @JsonProperty("httpStatus")
  private Integer httpStatus = null;

  @JsonProperty("responseBody")
  private String responseBody = null;

  @JsonProperty("responseHeaders")
  private String responseHeaders = null;

  @JsonProperty("active")
  private Boolean active = false;

  @JsonProperty("duration")
  private Long duration = null;

  @JsonProperty("eventProcessingTime")
  private Long eventProcessingTime = null;

  @JsonProperty("eventId")
  private UUID eventId = null;

  public Delivery id(UUID id) {
    this.id = id;
    return this;
  }

   /**
   * Get id
   * @return id
  **/
  @ApiModelProperty(value = "")
  public UUID getId() {
    return id;
  }

  public void setId(UUID id) {
    this.id = id;
  }

  public Delivery createdAt(OffsetDateTime createdAt) {
    this.createdAt = createdAt;
    return this;
  }

   /**
   * The date at which the delivery was originally created.
   * @return createdAt
  **/
  @ApiModelProperty(example = "2017-08-28T08:25:33.654Z", value = "The date at which the delivery was originally created.")
  public OffsetDateTime getCreatedAt() {
    return createdAt;
  }

  public void setCreatedAt(OffsetDateTime createdAt) {
    this.createdAt = createdAt;
  }

  public Delivery requestHeaders(String requestHeaders) {
    this.requestHeaders = requestHeaders;
    return this;
  }

   /**
   * Get requestHeaders
   * @return requestHeaders
  **/
  @ApiModelProperty(value = "")
  public String getRequestHeaders() {
    return requestHeaders;
  }

  public void setRequestHeaders(String requestHeaders) {
    this.requestHeaders = requestHeaders;
  }

  public Delivery payload(String payload) {
    this.payload = payload;
    return this;
  }

   /**
   * Get payload
   * @return payload
  **/
  @ApiModelProperty(value = "")
  public String getPayload() {
    return payload;
  }

  public void setPayload(String payload) {
    this.payload = payload;
  }

  public Delivery targetUrl(String targetUrl) {
    this.targetUrl = targetUrl;
    return this;
  }

   /**
   * Get targetUrl
   * @return targetUrl
  **/
  @ApiModelProperty(value = "")
  public String getTargetUrl() {
    return targetUrl;
  }

  public void setTargetUrl(String targetUrl) {
    this.targetUrl = targetUrl;
  }

  public Delivery targetMethod(String targetMethod) {
    this.targetMethod = targetMethod;
    return this;
  }

   /**
   * Get targetMethod
   * @return targetMethod
  **/
  @ApiModelProperty(value = "")
  public String getTargetMethod() {
    return targetMethod;
  }

  public void setTargetMethod(String targetMethod) {
    this.targetMethod = targetMethod;
  }

  public Delivery basicAuth(String basicAuth) {
    this.basicAuth = basicAuth;
    return this;
  }

   /**
   * Get basicAuth
   * @return basicAuth
  **/
  @ApiModelProperty(value = "")
  public String getBasicAuth() {
    return basicAuth;
  }

  public void setBasicAuth(String basicAuth) {
    this.basicAuth = basicAuth;
  }

  public Delivery success(Boolean success) {
    this.success = success;
    return this;
  }

   /**
   * Get success
   * @return success
  **/
  @ApiModelProperty(value = "")
  public Boolean getSuccess() {
    return success;
  }

  public void setSuccess(Boolean success) {
    this.success = success;
  }

  public Delivery httpStatus(Integer httpStatus) {
    this.httpStatus = httpStatus;
    return this;
  }

   /**
   * Get httpStatus
   * @return httpStatus
  **/
  @ApiModelProperty(required = true, value = "")
  public Integer getHttpStatus() {
    return httpStatus;
  }

  public void setHttpStatus(Integer httpStatus) {
    this.httpStatus = httpStatus;
  }

  public Delivery responseBody(String responseBody) {
    this.responseBody = responseBody;
    return this;
  }

   /**
   * Get responseBody
   * @return responseBody
  **/
  @ApiModelProperty(value = "")
  public String getResponseBody() {
    return responseBody;
  }

  public void setResponseBody(String responseBody) {
    this.responseBody = responseBody;
  }

  public Delivery responseHeaders(String responseHeaders) {
    this.responseHeaders = responseHeaders;
    return this;
  }

   /**
   * Get responseHeaders
   * @return responseHeaders
  **/
  @ApiModelProperty(value = "")
  public String getResponseHeaders() {
    return responseHeaders;
  }

  public void setResponseHeaders(String responseHeaders) {
    this.responseHeaders = responseHeaders;
  }

  public Delivery active(Boolean active) {
    this.active = active;
    return this;
  }

   /**
   * Get active
   * @return active
  **/
  @ApiModelProperty(value = "")
  public Boolean getActive() {
    return active;
  }

  public void setActive(Boolean active) {
    this.active = active;
  }

  public Delivery duration(Long duration) {
    this.duration = duration;
    return this;
  }

   /**
   * Duration in milliseconds.
   * @return duration
  **/
  @ApiModelProperty(value = "Duration in milliseconds.")
  public Long getDuration() {
    return duration;
  }

  public void setDuration(Long duration) {
    this.duration = duration;
  }

  public Delivery eventProcessingTime(Long eventProcessingTime) {
    this.eventProcessingTime = eventProcessingTime;
    return this;
  }

   /**
   * Time it took to process the event in milliseconds.
   * @return eventProcessingTime
  **/
  @ApiModelProperty(value = "Time it took to process the event in milliseconds.")
  public Long getEventProcessingTime() {
    return eventProcessingTime;
  }

  public void setEventProcessingTime(Long eventProcessingTime) {
    this.eventProcessingTime = eventProcessingTime;
  }

  public Delivery eventId(UUID eventId) {
    this.eventId = eventId;
    return this;
  }

   /**
   * Get eventId
   * @return eventId
  **/
  @ApiModelProperty(value = "")
  public UUID getEventId() {
    return eventId;
  }

  public void setEventId(UUID eventId) {
    this.eventId = eventId;
  }


  @Override
  public boolean equals(java.lang.Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    Delivery delivery = (Delivery) o;
    return Objects.equals(this.id, delivery.id) &&
        Objects.equals(this.createdAt, delivery.createdAt) &&
        Objects.equals(this.requestHeaders, delivery.requestHeaders) &&
        Objects.equals(this.payload, delivery.payload) &&
        Objects.equals(this.targetUrl, delivery.targetUrl) &&
        Objects.equals(this.targetMethod, delivery.targetMethod) &&
        Objects.equals(this.basicAuth, delivery.basicAuth) &&
        Objects.equals(this.success, delivery.success) &&
        Objects.equals(this.httpStatus, delivery.httpStatus) &&
        Objects.equals(this.responseBody, delivery.responseBody) &&
        Objects.equals(this.responseHeaders, delivery.responseHeaders) &&
        Objects.equals(this.active, delivery.active) &&
        Objects.equals(this.duration, delivery.duration) &&
        Objects.equals(this.eventProcessingTime, delivery.eventProcessingTime) &&
        Objects.equals(this.eventId, delivery.eventId);
  }

  @Override
  public int hashCode() {
    return Objects.hash(id, createdAt, requestHeaders, payload, targetUrl, targetMethod, basicAuth, success, httpStatus, responseBody, responseHeaders, active, duration, eventProcessingTime, eventId);
  }


  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class Delivery {\n");
    
    sb.append("    id: ").append(toIndentedString(id)).append("\n");
    sb.append("    createdAt: ").append(toIndentedString(createdAt)).append("\n");
    sb.append("    requestHeaders: ").append(toIndentedString(requestHeaders)).append("\n");
    sb.append("    payload: ").append(toIndentedString(payload)).append("\n");
    sb.append("    targetUrl: ").append(toIndentedString(targetUrl)).append("\n");
    sb.append("    targetMethod: ").append(toIndentedString(targetMethod)).append("\n");
    sb.append("    basicAuth: ").append(toIndentedString(basicAuth)).append("\n");
    sb.append("    success: ").append(toIndentedString(success)).append("\n");
    sb.append("    httpStatus: ").append(toIndentedString(httpStatus)).append("\n");
    sb.append("    responseBody: ").append(toIndentedString(responseBody)).append("\n");
    sb.append("    responseHeaders: ").append(toIndentedString(responseHeaders)).append("\n");
    sb.append("    active: ").append(toIndentedString(active)).append("\n");
    sb.append("    duration: ").append(toIndentedString(duration)).append("\n");
    sb.append("    eventProcessingTime: ").append(toIndentedString(eventProcessingTime)).append("\n");
    sb.append("    eventId: ").append(toIndentedString(eventId)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(java.lang.Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }
  
}

