/*
 * Decompiled with CFR 0.152.
 */
package net.lecousin.reactive.data.relational.mysql;

import java.time.OffsetTime;
import java.time.ZonedDateTime;
import net.lecousin.reactive.data.relational.annotations.ColumnDefinition;
import net.lecousin.reactive.data.relational.dialect.SchemaGenerationDialect;
import net.lecousin.reactive.data.relational.mapping.LcReactiveDataAccessStrategy;
import org.springframework.data.relational.core.mapping.RelationalPersistentProperty;

public class MySqlSchemaGenerationDialect
extends SchemaGenerationDialect {
    public MySqlSchemaGenerationDialect(LcReactiveDataAccessStrategy dataAccess) {
        super(dataAccess);
    }

    public Object convertToDataBase(Object value) {
        if (value instanceof OffsetTime || value instanceof ZonedDateTime) {
            return value.toString();
        }
        return super.convertToDataBase(value);
    }

    public Object convertFromDataBase(Object value, Class<?> targetType) {
        if (OffsetTime.class.equals(targetType)) {
            return OffsetTime.parse((CharSequence)value);
        }
        if (ZonedDateTime.class.equals(targetType)) {
            return ZonedDateTime.parse((CharSequence)value);
        }
        return super.convertFromDataBase(value, targetType);
    }

    protected void columnDefinitionDataTypeString(RelationalPersistentProperty property, StringBuilder sql) {
        ColumnDefinition def = (ColumnDefinition)property.findAnnotation(ColumnDefinition.class);
        if (def != null) {
            if (def.min() > 0L && def.max() == def.min() && def.max() <= 255L) {
                sql.append("CHAR(").append(def.max()).append(')');
                return;
            }
            if (def.max() > 255L) {
                sql.append("LONGTEXT");
            }
            if (def.max() > 0L) {
                sql.append("VARCHAR(").append(def.max()).append(')');
                return;
            }
        }
        sql.append("VARCHAR(255)");
    }

    protected void columnDefinitionDataTypeTimeWithTimeZone(RelationalPersistentProperty property, StringBuilder sql) {
        sql.append("VARCHAR(24)");
    }

    protected void columnDefinitionDataTypeDateTimeWithTimeZone(RelationalPersistentProperty property, StringBuilder sql) {
        sql.append("VARCHAR(100)");
    }
}

