/*
 * Decompiled with CFR 0.152.
 */
package net.lecousin.reactive.data.relational.postgres;

import net.lecousin.reactive.data.relational.annotations.ColumnDefinition;
import net.lecousin.reactive.data.relational.schema.Column;
import net.lecousin.reactive.data.relational.schema.dialect.RelationalDatabaseSchemaDialect;
import org.springframework.data.r2dbc.dialect.PostgresDialect;
import org.springframework.data.r2dbc.dialect.R2dbcDialect;

public class PostgresSchemaDialect
extends RelationalDatabaseSchemaDialect {
    public boolean isCompatible(R2dbcDialect r2dbcDialect) {
        return r2dbcDialect.getClass().equals(PostgresDialect.class);
    }

    protected void addAutoIncrement(Column col, StringBuilder sql) {
    }

    protected String getColumnTypeByte(Column col, Class<?> type, ColumnDefinition def) {
        return this.getColumnTypeShort(col, type, def);
    }

    protected String getColumnTypeShort(Column col, Class<?> type, ColumnDefinition def) {
        if (col.isAutoIncrement()) {
            return "SMALLSERIAL";
        }
        return "SMALLINT";
    }

    protected String getColumnTypeInteger(Column col, Class<?> type, ColumnDefinition def) {
        if (col.isAutoIncrement()) {
            return "SERIAL";
        }
        return "INTEGER";
    }

    protected String getColumnTypeLong(Column col, Class<?> type, ColumnDefinition def) {
        if (col.isAutoIncrement()) {
            return "BIGSERIAL";
        }
        return "BIGINT";
    }

    protected String getColumnTypeFloat(Column col, Class<?> type, ColumnDefinition def) {
        return "REAL";
    }

    protected String getColumnTypeDouble(Column col, Class<?> type, ColumnDefinition def) {
        return "DOUBLE PRECISION";
    }

    protected String getColumnTypeDateTime(Column col, Class<?> type, ColumnDefinition def) {
        return "TIMESTAMP";
    }

    protected String getColumnTypeDateTimeWithTimeZone(Column col, Class<?> type, ColumnDefinition def) {
        return "TIMESTAMP WITH TIME ZONE";
    }

    protected String getColumnTypeString(Column col, Class<?> type, ColumnDefinition def) {
        if (def != null) {
            if (def.max() > Integer.MAX_VALUE) {
                return "CLOB(" + def.max() + ")";
            }
            if (def.min() > 0L && def.max() == def.min()) {
                return "CHAR(" + def.max() + ")";
            }
            if (def.max() > 0L) {
                return "VARCHAR(" + def.max() + ")";
            }
        }
        return "VARCHAR";
    }

    protected void addDefaultRandomUuid(Column col, StringBuilder sql) {
        sql.append(" DEFAULT UUID_GENERATE_V4()");
    }
}

