/*
 * Decompiled with CFR 0.152.
 */
package org.leo.aws.ddb.repositories;

import com.google.common.collect.ImmutableMap;
import java.lang.reflect.Field;
import java.math.BigInteger;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.leo.aws.ddb.annotations.DbAttribute;
import org.leo.aws.ddb.annotations.DdbRepository;
import org.leo.aws.ddb.annotations.ProjectionType;
import org.leo.aws.ddb.data.Page;
import org.leo.aws.ddb.data.PrimaryKey;
import org.leo.aws.ddb.data.UpdateItem;
import org.leo.aws.ddb.exceptions.DbException;
import org.leo.aws.ddb.exceptions.OptimisticLockFailureException;
import org.leo.aws.ddb.repositories.AttributeMapper;
import org.leo.aws.ddb.repositories.DataMapper;
import org.leo.aws.ddb.repositories.DataMapperUtils;
import org.leo.aws.ddb.repositories.DynamoDbRepository;
import org.leo.aws.ddb.repositories.GSI;
import org.leo.aws.ddb.repositories.MapperUtils;
import org.leo.aws.ddb.utils.Action2;
import org.leo.aws.ddb.utils.DbUtils;
import org.leo.aws.ddb.utils.Expr;
import org.leo.aws.ddb.utils.Func0;
import org.leo.aws.ddb.utils.Func1;
import org.leo.aws.ddb.utils.Tuple;
import org.leo.aws.ddb.utils.Tuple3;
import org.leo.aws.ddb.utils.Tuples;
import org.leo.aws.ddb.utils.Utils;
import org.leo.aws.ddb.utils.exceptions.Issue;
import org.reactivestreams.Publisher;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.lang.Nullable;
import org.springframework.util.CollectionUtils;
import org.springframework.util.ReflectionUtils;
import org.springframework.util.StringUtils;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;
import software.amazon.awssdk.services.dynamodb.model.AttributeValue;
import software.amazon.awssdk.services.dynamodb.model.AttributeValueUpdate;
import software.amazon.awssdk.services.dynamodb.model.BatchGetItemRequest;
import software.amazon.awssdk.services.dynamodb.model.BatchWriteItemRequest;
import software.amazon.awssdk.services.dynamodb.model.ConditionalCheckFailedException;
import software.amazon.awssdk.services.dynamodb.model.DeleteItemRequest;
import software.amazon.awssdk.services.dynamodb.model.DeleteRequest;
import software.amazon.awssdk.services.dynamodb.model.ExpectedAttributeValue;
import software.amazon.awssdk.services.dynamodb.model.GetItemRequest;
import software.amazon.awssdk.services.dynamodb.model.KeysAndAttributes;
import software.amazon.awssdk.services.dynamodb.model.PutItemRequest;
import software.amazon.awssdk.services.dynamodb.model.PutRequest;
import software.amazon.awssdk.services.dynamodb.model.QueryRequest;
import software.amazon.awssdk.services.dynamodb.model.QueryResponse;
import software.amazon.awssdk.services.dynamodb.model.ReturnConsumedCapacity;
import software.amazon.awssdk.services.dynamodb.model.ReturnItemCollectionMetrics;
import software.amazon.awssdk.services.dynamodb.model.ReturnValue;
import software.amazon.awssdk.services.dynamodb.model.ScanRequest;
import software.amazon.awssdk.services.dynamodb.model.ScanResponse;
import software.amazon.awssdk.services.dynamodb.model.UpdateItemRequest;
import software.amazon.awssdk.services.dynamodb.model.UpdateItemResponse;
import software.amazon.awssdk.services.dynamodb.model.WriteRequest;
import software.amazon.awssdk.services.dynamodb.paginators.QueryPublisher;
import software.amazon.awssdk.services.dynamodb.paginators.ScanPublisher;

enum BaseRepositoryUtils {
    INSTANCE;

    private final ConcurrentHashMap<String, Class<?>> repoParameterTypeMap = new ConcurrentHashMap();
    private static final Logger LOGGER;

    static {
        LOGGER = LoggerFactory.getLogger(BaseRepositoryUtils.class);
    }

    static BaseRepositoryUtils getInstance() {
        return INSTANCE;
    }

    UpdateItemResponse handleUpdateItemException(PrimaryKey primaryKey, String tableName, Throwable e) {
        LOGGER.debug(MessageFormat.format("Record with the following primary key [{0}] exists in table [{1}]", primaryKey, tableName), e);
        if (e instanceof CompletionException && e.getCause() instanceof ConditionalCheckFailedException) {
            throw new OptimisticLockFailureException(e.getCause());
        }
        if (e instanceof RuntimeException) {
            throw (RuntimeException)e;
        }
        throw new DbException(String.valueOf(Issue.UNKNOWN_ERROR.name()) + " - handleUpdateItemException", e);
    }

    <ENTITY_TYPE> Integer setVersion(ENTITY_TYPE item, Tuple<Field, DbAttribute> versionedAttribute, UpdateItemRequest.Builder updateItemRequestBuilder) {
        Integer version;
        if (versionedAttribute != null) {
            Number versionNum = (Number)ReflectionUtils.getField((Field)((Field)versionedAttribute._1()), item);
            version = versionNum != null ? versionNum.intValue() + 1 : 0;
            Class<?> versionFieldType = ((Field)versionedAttribute._1()).getType();
            if (versionNum == null) {
                updateItemRequestBuilder.expected((Map)ImmutableMap.of((Object)((DbAttribute)versionedAttribute._2()).value(), (Object)((ExpectedAttributeValue)ExpectedAttributeValue.builder().exists(Boolean.valueOf(false)).build())));
            } else {
                updateItemRequestBuilder.expected((Map)ImmutableMap.of((Object)((DbAttribute)versionedAttribute._2()).value(), (Object)((ExpectedAttributeValue)ExpectedAttributeValue.builder().value((AttributeValue)AttributeValue.builder().n(String.valueOf(versionNum.intValue())).build()).build())));
            }
            if (versionFieldType == Integer.class) {
                ReflectionUtils.setField((Field)((Field)versionedAttribute._1()), item, (Object)version);
            } else {
                ReflectionUtils.setField((Field)((Field)versionedAttribute._1()), item, (Object)version);
            }
        } else {
            version = null;
        }
        return version;
    }

    <ENTITY_TYPE> Flux<ENTITY_TYPE> batchWriteRequest(Func1<DataMapper<ENTITY_TYPE>, Stream<WriteRequest>> dbRequestFunc, Func0<List<ENTITY_TYPE>> returnItemFunc, DataMapper<ENTITY_TYPE> dataMapper) {
        return Flux.defer(() -> Mono.fromFuture(this.processBatchWriteRequest(returnItemFunc, (Map<String, List<WriteRequest>>)ImmutableMap.of((Object)dataMapper.tableName(), ((Stream)dbRequestFunc.call((Object)dataMapper)).collect(Collectors.toList())))).flatMapMany(Flux::fromIterable));
    }

    <ENTITY_TYPE> Mono<ENTITY_TYPE> updateItem(PrimaryKey primaryKey, Map<String, Object> updatedValues, Class<ENTITY_TYPE> parameterType, DataMapper<ENTITY_TYPE> dataMapper, ENTITY_TYPE item) {
        return Mono.defer(() -> {
            Tuple<Field, DbAttribute> versionedAttribute = dataMapper.getVersionedAttribute();
            UpdateItemRequest.Builder updateItemRequestBuilder = UpdateItemRequest.builder();
            Map<String, Tuple3> mappedFields = MapperUtils.getInstance().getMappedValues(parameterType.getName()).collect(Collectors.toMap(Tuple3::_1, b -> b));
            Stream<Tuple> mappedValues = updatedValues.entrySet().stream().filter(entry -> !((String)entry.getKey()).equals(primaryKey.getHashKeyName())).filter(entry -> !((String)entry.getKey()).equals(primaryKey.getRangeKeyName())).peek(a -> {
                if (mappedFields.get(a.getKey()) != null) {
                    DbUtils.checkForNullFields((DbAttribute)((Tuple3)mappedFields.get(a.getKey()))._3(), a.getValue(), (String)((Tuple3)mappedFields.get(a.getKey()))._1());
                }
            }).map(a -> {
                if (mappedFields.get(a.getKey()) != null) {
                    return Tuples.of((Object)((String)a.getKey()), (Object)((AttributeValueUpdate)((AttributeValueUpdate.Builder)DbUtils.modelToAttributeUpdateValue((Field)((Tuple3)mappedFields.get(a.getKey()))._2(), a.getValue()).call((Object)AttributeValueUpdate.builder())).build()));
                }
                return Tuples.of((Object)((String)a.getKey()), (Object)((AttributeValueUpdate)AttributeValueUpdate.builder().value((AttributeValue)AttributeValue.builder().s(String.valueOf(a.getValue())).build()).build()));
            });
            ImmutableMap mappedUpdateValuesTmp = mappedValues.collect(Collectors.toMap(Tuple::_1, Tuple::_2));
            Integer version = this.setVersion(item, versionedAttribute, updateItemRequestBuilder);
            ImmutableMap mappedUpdateValues = versionedAttribute != null ? ImmutableMap.builder().putAll(mappedUpdateValuesTmp).put((Object)((DbAttribute)versionedAttribute._2()).value(), (Object)((AttributeValueUpdate)AttributeValueUpdate.builder().value((AttributeValue)AttributeValue.builder().n(String.valueOf(version)).build()).build())).build() : mappedUpdateValuesTmp;
            return Mono.fromFuture((CompletableFuture)DataMapperUtils.getDynamoDbAsyncClient().updateItem((UpdateItemRequest)updateItemRequestBuilder.tableName(dataMapper.tableName()).key(dataMapper.getPrimaryKey(primaryKey)).attributeUpdates(mappedUpdateValues).returnValues(ReturnValue.ALL_NEW).build()).thenApplyAsync(updateItemResponse -> dataMapper.mapFromAttributeValueToEntity(updateItemResponse.attributes())));
        });
    }

    <ENTITY_TYPE> Flux<ENTITY_TYPE> findByGlobalSecondaryIndex(String indexName, Object hashKeyValueObj, Object rangeKeyValue, Function<ENTITY_TYPE, PrimaryKey> primaryKeyFunc, Supplier<Class<ENTITY_TYPE>> dataClassFunc, Function<List<PrimaryKey>, Flux<ENTITY_TYPE>> findByPrimaryKeyFunc, Expr filterExpression) {
        return Flux.defer(() -> {
            if (hashKeyValueObj instanceof String) {
                Class dataClass = (Class)dataClassFunc.get();
                if (rangeKeyValue != null && !(rangeKeyValue instanceof String)) {
                    throw new DbException("Currently only String types are supported for sortKey Values");
                }
                String hashKeyValue = (String)hashKeyValueObj;
                Tuple<ProjectionType, QueryPublisher> queryResponseTuple = this.getDataFromIndex(indexName, hashKeyValue, rangeKeyValue, dataClass, filterExpression);
                Flux returnedDataFromDb = Flux.from((Publisher)((Publisher)queryResponseTuple._2())).flatMapIterable(QueryResponse::items).map(a -> DataMapperUtils.getDataMapper(dataClass).mapFromAttributeValueToEntity((Map<String, AttributeValue>)a));
                Flux returnData = queryResponseTuple._1() == ProjectionType.ALL ? returnedDataFromDb : returnedDataFromDb.map(primaryKeyFunc).collectList().flatMapMany(primaryKeys -> !CollectionUtils.isEmpty((Collection)primaryKeys) ? (Publisher)findByPrimaryKeyFunc.apply((List<PrimaryKey>)primaryKeys) : Flux.empty());
                return returnData;
            }
            throw new DbException("Currently only String types are supported for hashKey Values");
        });
    }

    <ENTITY_TYPE> Flux<ENTITY_TYPE> findAll(int pageSize, Supplier<Class<ENTITY_TYPE>> dataClassFunc) {
        return this.findAll(null, pageSize, dataClassFunc);
    }

    <ENTITY_TYPE> Flux<ENTITY_TYPE> findAll(Expr expr, int pageSize, Supplier<Class<ENTITY_TYPE>> dataClassFunc) {
        DataMapper<ENTITY_TYPE> dataMapper = DataMapperUtils.getDataMapper(dataClassFunc.get());
        ScanRequest.Builder scanRequestBuilder = ScanRequest.builder().tableName(dataMapper.tableName()).limit(Integer.valueOf(pageSize));
        if (Objects.nonNull(expr)) {
            Map<String, String> attNameMap = expr.attributeNameMap();
            Map<String, AttributeValue> attValueMap = expr.attributeValueMap();
            scanRequestBuilder.filterExpression(expr.expression());
            if (!CollectionUtils.isEmpty(attNameMap)) {
                scanRequestBuilder.expressionAttributeNames(attNameMap);
            }
            if (!CollectionUtils.isEmpty(attValueMap)) {
                scanRequestBuilder.expressionAttributeValues(attValueMap);
            }
        }
        ScanPublisher scanPublisher = DataMapperUtils.getDynamoDbAsyncClient().scanPaginator((ScanRequest)scanRequestBuilder.build());
        return Flux.from((Publisher)scanPublisher).flatMapIterable(ScanResponse::items).map(dataMapper::mapFromAttributeValueToEntity);
    }

    <ENTITY_TYPE> Mono<ENTITY_TYPE> findByPrimaryKey(PrimaryKey primaryKey, Supplier<Class<ENTITY_TYPE>> dataClassFunc) {
        return Mono.defer(() -> {
            DataMapper dataMapper = DataMapperUtils.getDataMapper((Class)dataClassFunc.get());
            GetItemRequest getItemRequest = (GetItemRequest)GetItemRequest.builder().key(dataMapper.getPrimaryKey(primaryKey)).tableName(dataMapper.tableName()).build();
            return Mono.fromCompletionStage((CompletionStage)DataMapperUtils.getDynamoDbAsyncClient().getItem(getItemRequest)).flatMap(resp -> resp.item().isEmpty() ? Mono.empty() : Mono.just(dataMapper.mapFromAttributeValueToEntity(resp.item())));
        });
    }

    <ENTITY_TYPE> Flux<ENTITY_TYPE> findByPrimaryKeys(List<PrimaryKey> primaryKeys, Supplier<Class<ENTITY_TYPE>> dataClassFunc) {
        return Flux.defer(() -> {
            DataMapper dataMapper = DataMapperUtils.getDataMapper((Class)dataClassFunc.get());
            ArrayList primaryKeysForQuery = new ArrayList(new HashSet(primaryKeys));
            KeysAndAttributes attributes = (KeysAndAttributes)KeysAndAttributes.builder().keys((Collection)primaryKeysForQuery.stream().map(dataMapper::getPrimaryKey).collect(Collectors.toList())).build();
            HashMap<String, KeysAndAttributes> andAttributesMap = new HashMap<String, KeysAndAttributes>();
            andAttributesMap.put(dataMapper.tableName(), attributes);
            BatchGetItemRequest request = (BatchGetItemRequest)BatchGetItemRequest.builder().requestItems(andAttributesMap).build();
            return Flux.from((Publisher)DataMapperUtils.getDynamoDbAsyncClient().batchGetItemPaginator(request)).flatMapIterable(resp -> (Iterable)resp.responses().get(dataMapper.tableName())).map(dataMapper::mapFromAttributeValueToEntity);
        });
    }

    <ENTITY_TYPE> CompletableFuture<ENTITY_TYPE> saveItem(ENTITY_TYPE item, boolean upsert, Action2<ENTITY_TYPE, Map<String, AttributeValue>> ttlAction, DataMapper<ENTITY_TYPE> dataMapper) {
        PrimaryKey primaryKey = dataMapper.createPKFromItem(item);
        String tableName = dataMapper.tableName();
        Tuple<Field, DbAttribute> versionedAttribute = dataMapper.getVersionedAttribute();
        String rangeKeyName = primaryKey.getRangeKeyName();
        PutItemRequest.Builder builder = PutItemRequest.builder().tableName(dataMapper.tableName());
        if (!upsert) {
            if (versionedAttribute != null) {
                ReflectionUtils.setField((Field)((Field)versionedAttribute._1()), item, (Object)BigInteger.ZERO.intValue());
            }
            if (!StringUtils.isEmpty((Object)rangeKeyName)) {
                builder.expected((Map)ImmutableMap.of((Object)primaryKey.getHashKeyName(), (Object)((ExpectedAttributeValue)ExpectedAttributeValue.builder().exists(Boolean.valueOf(false)).build()), (Object)primaryKey.getRangeKeyName(), (Object)((ExpectedAttributeValue)ExpectedAttributeValue.builder().exists(Boolean.valueOf(false)).build())));
            } else {
                builder.expected((Map)ImmutableMap.of((Object)primaryKey.getHashKeyName(), (Object)((ExpectedAttributeValue)ExpectedAttributeValue.builder().exists(Boolean.valueOf(false)).build())));
            }
        } else if (versionedAttribute != null) {
            int version;
            Number versionNum = (Number)ReflectionUtils.getField((Field)((Field)versionedAttribute._1()), item);
            if (versionNum == null) {
                version = BigInteger.ZERO.intValue();
                builder.expected((Map)ImmutableMap.of((Object)((DbAttribute)versionedAttribute._2()).value(), (Object)((ExpectedAttributeValue)ExpectedAttributeValue.builder().exists(Boolean.valueOf(false)).build())));
            } else {
                version = versionNum.intValue() + 1;
                builder.expected((Map)ImmutableMap.of((Object)((DbAttribute)versionedAttribute._2()).value(), (Object)((ExpectedAttributeValue)ExpectedAttributeValue.builder().attributeValueList(new AttributeValue[]{(AttributeValue)AttributeValue.builder().n(String.valueOf(versionNum)).build()}).build())));
            }
            ReflectionUtils.setField((Field)((Field)versionedAttribute._1()), item, (Object)version);
        }
        Map<String, AttributeValue> attributeValues = dataMapper.mapFromEntityToAttributeValue(item);
        ttlAction.call(item, attributeValues);
        builder.item(attributeValues);
        PutItemRequest putItemRequest = (PutItemRequest)builder.build();
        return ((CompletableFuture)DataMapperUtils.getDynamoDbAsyncClient().putItem(putItemRequest).thenApplyAsync(putItemResponse -> item)).exceptionally(e -> this.handleCreateItemException(primaryKey, tableName, (Throwable)e));
    }

    <ENTITY_TYPE> ENTITY_TYPE handleCreateItemException(PrimaryKey primaryKey, String tableName, Throwable e) {
        LOGGER.error(MessageFormat.format("Record with the following primary key [{0}] exists in table [{1}]", primaryKey, tableName), e);
        if (e instanceof CompletionException && e.getCause() instanceof ConditionalCheckFailedException) {
            throw new DbException(Issue.RECORD_ALREADY_EXISTS.name(), e);
        }
        if (e instanceof RuntimeException) {
            throw (RuntimeException)e;
        }
        throw new DbException(String.valueOf(Issue.UNKNOWN_ERROR.name()) + " - handleCreateItemException", e);
    }

    <ENTITY_TYPE> Mono<ENTITY_TYPE> updateItem(ENTITY_TYPE item, Function<ENTITY_TYPE, PrimaryKey> primaryKeyFunc, Supplier<Class<ENTITY_TYPE>> dataClassFunc) {
        return Mono.defer(() -> {
            PrimaryKey primaryKey = (PrimaryKey)primaryKeyFunc.apply(item);
            Class dataClass = (Class)dataClassFunc.get();
            DataMapper dataMapper = DataMapperUtils.getDataMapper(dataClass);
            Tuple<Field, DbAttribute> versionedAttribute = dataMapper.getVersionedAttribute();
            UpdateItemRequest.Builder updateItemRequestBuilder = UpdateItemRequest.builder();
            this.setVersion(item, versionedAttribute, updateItemRequestBuilder);
            Stream<Tuple> mappedValues = MapperUtils.getInstance().getMappedValues(item, dataClass).peek(a -> DbUtils.checkForNullFields((DbAttribute)a._4(), a._2(), (String)a._1())).filter(a -> a._1() != null).map(a -> Tuples.of((Object)((String)a._1()), (Object)((AttributeValueUpdate)((AttributeValueUpdate.Builder)DbUtils.modelToAttributeUpdateValue((Field)a._3(), a._2()).call((Object)AttributeValueUpdate.builder())).build())));
            return Mono.fromFuture((CompletableFuture)((CompletableFuture)DataMapperUtils.getDynamoDbAsyncClient().updateItem((UpdateItemRequest)updateItemRequestBuilder.tableName(dataMapper.tableName()).key(dataMapper.getPrimaryKey(primaryKey)).attributeUpdates(mappedValues.collect(Collectors.toMap(Tuple::_1, Tuple::_2))).returnValues(ReturnValue.ALL_NEW).build()).exceptionally(e -> this.handleUpdateItemException(primaryKey, dataMapper.tableName(), (Throwable)e))).thenApplyAsync(updateItemResponse -> dataMapper.mapFromAttributeValueToEntity(updateItemResponse.attributes()))).onErrorResume(throwable -> throwable instanceof CompletionException, throwable -> Mono.error((Throwable)throwable.getCause()));
        });
    }

    <ENTITY_TYPE> Mono<ENTITY_TYPE> updateItem(PrimaryKey primaryKey, Map<String, Object> updatedValues, Function<PrimaryKey, Mono<ENTITY_TYPE>> findByPrimaryFunc, Supplier<Class<ENTITY_TYPE>> dataClassFunc) {
        Mono<ENTITY_TYPE> itemMono = findByPrimaryFunc.apply(primaryKey);
        Class parameterType = dataClassFunc.get();
        DataMapper dataMapper = DataMapperUtils.getDataMapper(parameterType);
        return itemMono.flatMap(item -> this.updateItem(primaryKey, updatedValues, parameterType, dataMapper, item));
    }

    <ENTITY_TYPE> Flux<ENTITY_TYPE> updateItem(List<UpdateItem> updateItems, Supplier<Class<ENTITY_TYPE>> paramTypeFunc, Function<List<PrimaryKey>, Flux<ENTITY_TYPE>> findByPrimaryKeysFunc) {
        Class parameterType = paramTypeFunc.get();
        DataMapper dataMapper = DataMapperUtils.getDataMapper(parameterType);
        Flux<ENTITY_TYPE> items = findByPrimaryKeysFunc.apply(updateItems.stream().map(UpdateItem::getPrimaryKey).collect(Collectors.toList()));
        Map<PrimaryKey, UpdateItem> updateItemMap = updateItems.stream().collect(Collectors.toMap(UpdateItem::getPrimaryKey, b -> b));
        Flux test = items.map(item -> this.updateItem(dataMapper.createPKFromItem(item), ((UpdateItem)updateItemMap.get(dataMapper.createPKFromItem(item))).getUpdatedValues(), parameterType, dataMapper, item));
        return Flux.concat((Publisher)test);
    }

    <ENTITY_TYPE> Flux<ENTITY_TYPE> batchWrite(List<ENTITY_TYPE> putItems, List<ENTITY_TYPE> deleteItems, Supplier<Class<ENTITY_TYPE>> paramTypeFunc) {
        return Flux.defer(() -> {
            Func1 putFunc = dataMapper -> putItems.stream().map(item -> (WriteRequest)WriteRequest.builder().putRequest((PutRequest)PutRequest.builder().item(dataMapper.mapFromEntityToAttributeValue(item)).build()).build());
            Func1 deleteFunc = dataMapper -> (deleteItems != null ? deleteItems : Collections.emptyList()).stream().map(item -> (WriteRequest)WriteRequest.builder().deleteRequest((DeleteRequest)DeleteRequest.builder().key(dataMapper.getPrimaryKey(dataMapper.createPKFromItem(item))).build()).build());
            Func1 dbRequestFunc = dataMapper -> Stream.concat((Stream)putFunc.call(dataMapper), (Stream)deleteFunc.call(dataMapper));
            DataMapper dataMapper2 = DataMapperUtils.getDataMapper((Class)paramTypeFunc.get());
            return Mono.fromFuture(this.processBatchWriteRequest(() -> putItems, (Map<String, List<WriteRequest>>)ImmutableMap.of((Object)dataMapper2.tableName(), ((Stream)dbRequestFunc.call(dataMapper2)).collect(Collectors.toList())))).flatMapMany(Flux::fromIterable);
        });
    }

    <ENTITY_TYPE> CompletableFuture<List<ENTITY_TYPE>> processBatchWriteRequest(Func0<List<ENTITY_TYPE>> returnItemFunc, Map<String, List<WriteRequest>> requestItems) {
        BatchWriteItemRequest batchWriteItemRequest = (BatchWriteItemRequest)BatchWriteItemRequest.builder().returnConsumedCapacity(ReturnConsumedCapacity.TOTAL).returnItemCollectionMetrics(ReturnItemCollectionMetrics.SIZE).requestItems(requestItems).build();
        CompletableFuture response = DataMapperUtils.getDynamoDbAsyncClient().batchWriteItem(batchWriteItemRequest);
        return response.thenApplyAsync(res -> {
            boolean hasUnProcessed = res.hasUnprocessedItems();
            return hasUnProcessed && !CollectionUtils.isEmpty((Map)res.unprocessedItems()) ? (List)Utils.getFromFromFuture(this.processBatchWriteRequest(returnItemFunc, res.unprocessedItems())) : (List)returnItemFunc.call();
        });
    }

    <ENTITY_TYPE> Mono<ENTITY_TYPE> deleteItem(ENTITY_TYPE item, Supplier<Class<ENTITY_TYPE>> paramTypeFunc) {
        return Mono.defer(() -> {
            DataMapper<Object> dataMapper = DataMapperUtils.getDataMapper((Class)paramTypeFunc.get());
            PrimaryKey primaryKey = dataMapper.createPKFromItem(item);
            DeleteItemRequest deleteRequest = (DeleteItemRequest)DeleteItemRequest.builder().tableName(dataMapper.tableName()).key(dataMapper.getPrimaryKey(primaryKey)).build();
            return Mono.fromFuture((CompletableFuture)DataMapperUtils.getDynamoDbAsyncClient().deleteItem(deleteRequest).thenApplyAsync(deleteItemResponse -> item));
        });
    }

    <ENTITY_TYPE> Tuple<ProjectionType, QueryPublisher> getDataFromIndex(String indexName, String hashKeyValue, Object rangeKeyValue, Class<ENTITY_TYPE> dataClass, Expr filterExpressions) {
        AttributeMapper<?> attributeMapper = MapperUtils.getInstance().getAttributeMappingMap().get(dataClass.getName());
        GSI secondaryIndex = attributeMapper.getGlobalSecondaryIndexMap().get(indexName);
        if (secondaryIndex == null) {
            throw new DbException(MessageFormat.format("Index [{0}] not defined in the data model", indexName));
        }
        if (rangeKeyValue != null && secondaryIndex.getRangeKeyTuple() == null) {
            throw new DbException(MessageFormat.format("Sort Key not defined for index[{0}] in the data model", indexName));
        }
        String keyConditionExpression = "#d = :partition_key" + (rangeKeyValue != null ? " and " + (String)secondaryIndex.getRangeKeyTuple()._1() + " = :sort_key_val" : "");
        QueryRequest.Builder builder = QueryRequest.builder();
        HashMap<String, String> nameMap = new HashMap<String, String>(Map.of("#d", (String)secondaryIndex.getHashKeyTuple()._1()));
        HashMap<String, AttributeValue> attributeValueMap = new HashMap<String, AttributeValue>();
        if (rangeKeyValue != null) {
            attributeValueMap.put(":sort_key_val", (AttributeValue)AttributeValue.builder().s(String.valueOf(rangeKeyValue)).build());
        }
        attributeValueMap.put(":partition_key", (AttributeValue)AttributeValue.builder().s(hashKeyValue).build());
        builder.tableName(attributeMapper.getTableName());
        builder.indexName(secondaryIndex.getName());
        this.setFilterExpression(filterExpressions, builder, nameMap, attributeValueMap);
        builder.keyConditionExpression(keyConditionExpression);
        builder.expressionAttributeNames(nameMap);
        builder.expressionAttributeValues(attributeValueMap);
        QueryRequest request = (QueryRequest)builder.build();
        QueryPublisher queryPublisher = DataMapperUtils.getDynamoDbAsyncClient().queryPaginator(request);
        return Tuples.of((Object)secondaryIndex.getProjectionType(), (Object)queryPublisher);
    }

    void setFilterExpression(Expr expr, QueryRequest.Builder builder, Map<String, String> nameMap, Map<String, AttributeValue> attributeValueMap) {
        if (expr != null) {
            Map<String, String> attNameMap = expr.attributeNameMap();
            Map<String, AttributeValue> attValueMap = expr.attributeValueMap();
            builder.filterExpression(expr.expression());
            if (!CollectionUtils.isEmpty(attNameMap)) {
                nameMap.putAll(attNameMap);
            }
            if (!CollectionUtils.isEmpty(attValueMap)) {
                attributeValueMap.putAll(attValueMap);
            }
        }
    }

    <ENTITY_TYPE> Class<ENTITY_TYPE> getRepoParameterType(DynamoDbRepository<ENTITY_TYPE> baseRepository) {
        return this.repoParameterTypeMap.computeIfAbsent(baseRepository.getClass().getName(), s -> {
            DdbRepository annotation = baseRepository.getClass().getAnnotation(DdbRepository.class);
            if (annotation != null) {
                return annotation.entityClass();
            }
            throw new DbException("Annotation not defined in Repository implementation.");
        });
    }

    <ENTITY_TYPE> Flux<ENTITY_TYPE> findByHashKeyAndRangeKeyStartsWithPagination(String hashKey, Object hashKeyValueObj, String rangeKey, String rangeKeyValue, Page page, @Nullable String indexName, Class<ENTITY_TYPE> dataClass, @Nullable Expr expr) {
        if (hashKeyValueObj instanceof String || hashKeyValueObj instanceof Number) {
            HashMap<String, String> nameMap = new HashMap<String, String>();
            HashMap<String, AttributeValue> attributeValueMap = new HashMap<String, AttributeValue>();
            QueryRequest.Builder builder = QueryRequest.builder();
            DataMapper<ENTITY_TYPE> dataMapper = DataMapperUtils.getDataMapper(dataClass);
            String keyConditionExpression = !StringUtils.isEmpty((Object)rangeKey) && !StringUtils.isEmpty((Object)rangeKeyValue) ? MessageFormat.format("{0} = :{1} and begins_with({2}, :sortKeyVal)", "#a", hashKey, rangeKey) : "#a = :" + hashKey;
            nameMap.put("#a", hashKey);
            if (hashKeyValueObj instanceof String) {
                attributeValueMap.put(MessageFormat.format(":{0}", hashKey), (AttributeValue)AttributeValue.builder().s((String)hashKeyValueObj).build());
            } else {
                attributeValueMap.put(MessageFormat.format(":{0}", hashKey), (AttributeValue)AttributeValue.builder().n(Utils.getUnformattedNumber((Number)((Number)hashKeyValueObj))).build());
            }
            if (!StringUtils.isEmpty((Object)rangeKey) && !StringUtils.isEmpty((Object)rangeKeyValue)) {
                attributeValueMap.put(":sortKeyVal", (AttributeValue)AttributeValue.builder().s(rangeKeyValue).build());
            }
            if (!StringUtils.isEmpty((Object)indexName)) {
                builder.indexName(indexName);
            }
            this.setFilterExpression(expr, builder, nameMap, attributeValueMap);
            if (page != null) {
                builder.limit(Integer.valueOf(page.getPageSize()));
                if (page.getLastEndKey() != null) {
                    String lastEndKeyVal = (String)page.getLastEndKey().getRangeKeyValue();
                    if (StringUtils.isEmpty((Object)rangeKeyValue) || lastEndKeyVal.startsWith(rangeKeyValue)) {
                        builder.exclusiveStartKey(dataMapper.getPrimaryKey(page.getLastEndKey()));
                    } else {
                        return Flux.error((Throwable)new DbException("INVALID_RANGE_KEY_VALUE"));
                    }
                }
            }
            QueryRequest request = (QueryRequest)builder.tableName(dataMapper.tableName()).keyConditionExpression(keyConditionExpression).expressionAttributeNames(nameMap).expressionAttributeValues(attributeValueMap).build();
            QueryPublisher queryResponse = DataMapperUtils.getDynamoDbAsyncClient().queryPaginator(request);
            return Flux.from((Publisher)queryResponse).flatMapIterable(QueryResponse::items).map(dataMapper::mapFromAttributeValueToEntity);
        }
        throw new DbException("Currently only String/Number types are supported for hashKey Values");
    }
}

