/*
 * Decompiled with CFR 0.152.
 */
package org.leo.aws.ddb.repositories;

import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;
import java.util.stream.Collectors;
import org.leo.aws.ddb.repositories.DataMapper;
import org.leo.aws.ddb.utils.ApplicationContextUtils;
import org.leo.aws.ddb.utils.Tuple;
import org.leo.aws.ddb.utils.Tuples;
import org.springframework.beans.factory.BeanInitializationException;
import org.springframework.context.ApplicationContext;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.env.Environment;

@Configuration
public class DataMapperConfig {
    private final ApplicationContext applicationContext;
    private final Environment environment;

    public DataMapperConfig(ApplicationContext applicationContext, Environment environment) {
        this.applicationContext = applicationContext;
        this.environment = environment;
    }

    @Bean
    public Map<Class, DataMapper> dataMapperMap() {
        try {
            Map beans = this.applicationContext.getBeansOfType(DataMapper.class);
            Method method = ApplicationContextUtils.class.getDeclaredMethod("init", ApplicationContext.class, Environment.class);
            method.setAccessible(true);
            method.invoke(null, this.applicationContext, this.environment);
            return new HashMap<Class, DataMapper>(beans.values().stream().map(bean -> Tuples.of((Object)this.getParameterType((DataMapper<?>)bean), (Object)bean)).collect(Collectors.toMap(Tuple::_1, Tuple::_2)));
        }
        catch (Exception ex) {
            throw new BeanInitializationException("Exception while create dataMapperMap", (Throwable)ex);
        }
    }

    private Class getParameterType(DataMapper<?> dataMapper) {
        return dataMapper.getParameterType();
    }
}

