/*
 * Decompiled with CFR 0.152.
 */
package org.leo.aws.ddb.utils;

import com.google.common.collect.ImmutableMap;
import java.lang.reflect.Proxy;
import java.text.MessageFormat;
import java.util.Map;
import org.leo.aws.ddb.utils.Comparator;
import org.leo.aws.ddb.utils.Expr;
import org.leo.aws.ddb.utils.FilterExpr;
import org.leo.aws.ddb.utils.Group;
import org.leo.aws.ddb.utils.Name;
import org.leo.aws.ddb.utils.Operator;
import org.leo.aws.ddb.utils.Value;
import org.leo.aws.ddb.utils.exceptions.UtilsException;
import software.amazon.awssdk.services.dynamodb.model.AttributeValue;

class FilterExprImpl
implements FilterExpr {
    private NameImpl rootName;
    private GroupImpl rootGroup;

    FilterExprImpl() {
    }

    public static FilterExpr getInstance() {
        return new FilterExprImpl();
    }

    @Override
    public Name name(String name, String alias) {
        this.rootName = new NameImpl(name, alias, this);
        return this.rootName;
    }

    @Override
    public Group group(Expr expr) {
        this.rootGroup = new GroupImpl(this, expr);
        return this.rootGroup;
    }

    @Override
    public Name name(String name) {
        return this.name(name, name);
    }

    private static abstract class AbstractComparator
    implements Comparator {
        private ValueImpl value;
        private final FilterExprImpl filterExpression;

        protected AbstractComparator(FilterExprImpl filterExpression) {
            this.filterExpression = filterExpression;
        }

        @Override
        public Value value(String name, AttributeValue value) {
            this.value = new ValueImpl(name, value, this.filterExpression);
            return this.value;
        }

        public String toString() {
            return "AbstractComparator{value=" + this.value + '}';
        }
    }

    private static abstract class AbstractOperator
    implements Operator {
        private NameImpl nextName;
        private final FilterExprImpl filterExpr;
        private GroupImpl group;

        protected AbstractOperator(String nextName, String alias, FilterExprImpl filterExpression) {
            this.nextName = new NameImpl(nextName, alias, filterExpression);
            this.filterExpr = filterExpression;
        }

        protected AbstractOperator(FilterExprImpl filterExpression) {
            this.filterExpr = filterExpression;
        }

        @Override
        public String expression() {
            if (this.nextName == null && this.group == null) {
                throw new UtilsException("Invalid expression.");
            }
            return String.valueOf(this.getExpression()) + (this.nextName != null ? this.nextName.expression() : this.group.expression());
        }

        protected abstract String getExpression();

        public String toString() {
            return "AbstractOperator{nextName=" + this.nextName + '}';
        }

        @Override
        public Name name(String name, String alias) {
            this.nextName = new NameImpl(name, alias, this.filterExpr);
            return this.nextName;
        }

        @Override
        public Group group(Expr expr) {
            this.group = new GroupImpl(this.filterExpr, expr);
            return this.group;
        }

        public Map<String, String> attributeNameMap() {
            return this.nextName != null ? this.nextName.attributeNameMap() : this.group.attributeNameMap();
        }

        public Map<String, AttributeValue> attributeValueMap() {
            return this.nextName != null ? this.nextName.attributeValueMap() : this.group.attributeValueMap();
        }
    }

    private static final class And
    extends AbstractOperator {
        private And(String name, String alias, FilterExprImpl filterExpression) {
            super(name, alias, filterExpression);
        }

        public And(FilterExprImpl filterExpression) {
            super(filterExpression);
        }

        @Override
        protected String getExpression() {
            return " and ";
        }
    }

    private static final class Equals
    extends AbstractComparator {
        private Equals(FilterExprImpl filterExpression) {
            super(filterExpression);
        }

        @Override
        public String expression() {
            return " = ";
        }

        @Override
        public String toString() {
            return "Equals{} " + super.toString();
        }
    }

    private static final class ExprImpl
    implements Expr {
        private final NameImpl rootNode;
        private final GroupImpl rootGroup;

        private ExprImpl(FilterExprImpl filterExpr) {
            this.rootNode = filterExpr.rootName;
            this.rootGroup = filterExpr.rootGroup;
        }

        @Override
        public String expression() {
            if (this.rootNode != null) {
                return this.rootNode.expression();
            }
            if (this.rootGroup != null) {
                return this.rootGroup.expression();
            }
            throw new UtilsException("Invalid Expression");
        }

        @Override
        public Map<String, String> attributeNameMap() {
            if (this.rootNode != null) {
                return this.rootNode.attributeNameMap();
            }
            if (this.rootGroup != null) {
                return this.rootGroup.attributeNameMap();
            }
            throw new UtilsException("Invalid Expression");
        }

        @Override
        public Map<String, AttributeValue> attributeValueMap() {
            if (this.rootNode != null) {
                return this.rootNode.attributeValueMap();
            }
            if (this.rootGroup != null) {
                return this.rootGroup.attributeValueMap();
            }
            throw new UtilsException("Invalid Expression");
        }
    }

    private static final class GreaterThan
    extends AbstractComparator {
        private GreaterThan(FilterExprImpl filterExpression) {
            super(filterExpression);
        }

        @Override
        public String expression() {
            return " > ";
        }

        @Override
        public String toString() {
            return "GreaterThan{} " + super.toString();
        }
    }

    private static final class GreaterThanOrEquals
    extends AbstractComparator {
        private GreaterThanOrEquals(FilterExprImpl filterExpression) {
            super(filterExpression);
        }

        @Override
        public String expression() {
            return " >= ";
        }

        @Override
        public String toString() {
            return "GreaterThanOrEquals{} " + super.toString();
        }
    }

    private static final class GroupImpl
    implements Group {
        private AbstractOperator operator;
        private final FilterExprImpl filterExpr;
        private final Expr expr;

        private GroupImpl(FilterExprImpl filterExpr, Expr expr) {
            this.filterExpr = filterExpr;
            this.expr = expr;
        }

        @Override
        public Operator and() {
            this.operator = new And(this.filterExpr);
            return this.operator;
        }

        @Override
        public Operator or() {
            this.operator = new Or(this.filterExpr);
            return this.operator;
        }

        @Override
        public String expression() {
            return this.operator != null ? MessageFormat.format("({0}) {1}", this.expr.expression(), this.operator.expression()) : MessageFormat.format("({0})", this.expr.expression());
        }

        public Map<String, String> attributeNameMap() {
            ImmutableMap.Builder builder = ImmutableMap.builder().putAll(this.expr.attributeNameMap());
            if (this.operator != null) {
                builder.putAll(this.operator.attributeNameMap());
            }
            return builder.build();
        }

        public Map<String, AttributeValue> attributeValueMap() {
            ImmutableMap.Builder builder = ImmutableMap.builder().putAll(this.expr.attributeValueMap());
            if (this.operator != null) {
                builder.putAll(this.operator.attributeValueMap());
            }
            return builder.build();
        }

        @Override
        public Expr buildFilterExpression() {
            if (this.operator != null) {
                throw new UtilsException("Invalid expression.");
            }
            ExprImpl expr = new ExprImpl(this.filterExpr);
            return (Expr)Proxy.newProxyInstance(this.getClass().getClassLoader(), new Class[]{Expr.class}, (proxy, method, args) -> method.invoke((Object)expr, args));
        }
    }

    private static class LessThan
    extends AbstractComparator {
        public LessThan(FilterExprImpl filterExpression) {
            super(filterExpression);
        }

        @Override
        public String expression() {
            return " < ";
        }

        @Override
        public String toString() {
            return "LessThan{} " + super.toString();
        }
    }

    private static final class LessThanOrEquals
    extends AbstractComparator {
        private LessThanOrEquals(FilterExprImpl filterExpression) {
            super(filterExpression);
        }

        @Override
        public String expression() {
            return " <= ";
        }

        @Override
        public String toString() {
            return "LessThanOrEquals{} " + super.toString();
        }
    }

    private static class NameImpl
    implements Name {
        private final String name;
        private final String alias;
        private final FilterExprImpl filterExpression;
        private AbstractComparator comparator;

        public NameImpl(String name, String alias, FilterExprImpl filterExpression) {
            this.name = name;
            this.alias = alias;
            this.filterExpression = filterExpression;
        }

        @Override
        public Comparator gt() {
            this.comparator = new GreaterThan(this.filterExpression);
            return this.comparator;
        }

        @Override
        public Comparator lt() {
            this.comparator = new LessThan(this.filterExpression);
            return this.comparator;
        }

        @Override
        public Comparator gte() {
            this.comparator = new GreaterThanOrEquals(this.filterExpression);
            return this.comparator;
        }

        @Override
        public Comparator lte() {
            this.comparator = new LessThanOrEquals(this.filterExpression);
            return this.comparator;
        }

        @Override
        public Comparator eq() {
            this.comparator = new Equals(this.filterExpression);
            return this.comparator;
        }

        @Override
        public Comparator notExists() {
            this.comparator = new NotExists(this.filterExpression);
            return this.comparator;
        }

        String expression() {
            if (!(this.comparator instanceof NotExists)) {
                ValueImpl value = this.comparator.value;
                if (value == null) {
                    throw new UtilsException("Invalid Expression");
                }
                AbstractOperator operator = value.operator;
                return MessageFormat.format("#{0}{1}:{2}{3}", this.alias, this.comparator.expression(), value.name, operator == null ? "" : operator.expression());
            }
            return MessageFormat.format(this.comparator.expression(), this.name);
        }

        Map<String, String> attributeNameMap() {
            if (!(this.comparator instanceof NotExists)) {
                ValueImpl value = this.comparator.value;
                ImmutableMap.Builder builder = ImmutableMap.builder();
                AbstractOperator operator = value.operator;
                builder.put((Object)("#" + this.alias), (Object)this.name);
                if (operator != null) {
                    builder.putAll(operator.attributeNameMap());
                }
                return builder.build();
            }
            return ImmutableMap.of();
        }

        Map<String, AttributeValue> attributeValueMap() {
            if (!(this.comparator instanceof NotExists)) {
                ImmutableMap.Builder builder = ImmutableMap.builder();
                ValueImpl value = this.comparator.value;
                AbstractOperator operator = value.operator;
                builder.put((Object)(":" + value.name), (Object)value.value);
                if (operator != null) {
                    builder.putAll(operator.attributeValueMap());
                }
                return builder.build();
            }
            return ImmutableMap.of();
        }

        public String toString() {
            return "Name{name='" + this.name + '\'' + ", alias='" + this.alias + '\'' + ", comparator=" + this.comparator + '}';
        }
    }

    private static final class NotExists
    extends AbstractComparator {
        public NotExists(FilterExprImpl filterExpression) {
            super(filterExpression);
        }

        @Override
        public Value value(String name, AttributeValue value) {
            throw new UnsupportedOperationException("This is not supported for a \"Not exists\" check");
        }

        @Override
        public String expression() {
            return "attribute_not_exists({0})";
        }
    }

    private static final class Or
    extends AbstractOperator {
        private Or(String name, String alias, FilterExprImpl filterExpression) {
            super(name, alias, filterExpression);
        }

        public Or(FilterExprImpl filterExpression) {
            super(filterExpression);
        }

        @Override
        public String toString() {
            return "Or{} " + super.toString();
        }

        @Override
        protected String getExpression() {
            return " or ";
        }
    }

    public static final class ValueImpl
    implements Value {
        private final AttributeValue value;
        private AbstractOperator operator;
        private final FilterExprImpl filterExpression;
        private final String name;

        private ValueImpl(String name, AttributeValue value, FilterExprImpl filterExpression) {
            this.name = name;
            this.value = value;
            this.filterExpression = filterExpression;
        }

        @Override
        public Name and(String name, String alias) {
            this.operator = new And(name, alias, this.filterExpression);
            return this.operator.nextName;
        }

        @Override
        public Operator and() {
            this.operator = new And(this.filterExpression);
            return this.operator;
        }

        @Override
        public Name and(String name) {
            return this.and(name, name);
        }

        @Override
        public Name or(String name, String alias) {
            this.operator = new Or(name, alias, this.filterExpression);
            return this.operator.nextName;
        }

        @Override
        public Operator or() {
            this.operator = new Or(this.filterExpression);
            return this.operator;
        }

        @Override
        public Name or(String name) {
            return this.or(name, name);
        }

        @Override
        public Expr buildFilterExpression() {
            return new ExprImpl(this.filterExpression);
        }

        public String toString() {
            return "Value{value=" + this.value + ", comparator=" + this.operator + '}';
        }
    }
}

