/*
 * Decompiled with CFR 0.152.
 */
package org.leo.aws.ddb.repositories;

import java.util.Map;
import java.util.Set;
import javax.annotation.PostConstruct;
import org.leo.aws.ddb.annotations.DDBTable;
import org.leo.aws.ddb.repositories.AbstractDataMapper;
import org.leo.aws.ddb.repositories.DataMapper;
import org.leo.aws.ddb.repositories.MapperUtils;
import org.reflections.Configuration;
import org.reflections.Reflections;
import org.reflections.util.ClasspathHelper;
import org.reflections.util.ConfigurationBuilder;
import org.springframework.core.env.Environment;

public class DataMapperConfigCleanUp {
    private final String dtoBasePackage;
    private final Map<Class, DataMapper> dataMapperMap;
    private final Environment environment;

    public DataMapperConfigCleanUp(String dtoBasePackage, Map<Class, DataMapper> dataMapperMap, Environment environment) {
        this.dtoBasePackage = dtoBasePackage;
        this.dataMapperMap = dataMapperMap;
        this.environment = environment;
    }

    @PostConstruct
    public void mapDataObjectsWithoutMapper() {
        Reflections reflections = new Reflections((Configuration)new ConfigurationBuilder().setUrls(ClasspathHelper.forPackage((String)this.dtoBasePackage, (ClassLoader[])new ClassLoader[]{ClasspathHelper.contextClassLoader(), ClasspathHelper.staticClassLoader()})));
        Set annotated = reflections.getTypesAnnotatedWith(DDBTable.class);
        annotated.forEach(this::setParameterTypeInDataMapperMap);
        this.dataMapperMap.forEach((key, value) -> MapperUtils.INSTANCE.setDbAttributes(value.getParameterType(), this.environment, value));
    }

    private void setParameterTypeInDataMapperMap(final Class<?> type) {
        DataMapper dataMapper = this.dataMapperMap.get(type);
        if (dataMapper == null) {
            this.dataMapperMap.put(type, new AbstractDataMapper(){

                @Override
                public Class getParameterType() {
                    return type;
                }
            });
        }
    }
}

