/*
 * Decompiled with CFR 0.152.
 */
package org.leo.unleash.config;

import io.getunleash.DefaultUnleash;
import io.getunleash.Unleash;
import io.getunleash.strategy.Strategy;
import io.getunleash.util.UnleashConfig;
import java.util.Map;
import java.util.UUID;
import org.leo.unleash.aop.FeatureAdvisor;
import org.leo.unleash.aop.FeatureProxyAdvisor;
import org.leo.unleash.autoconfigure.UnleashProperties;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Import;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

@Configuration
@EnableConfigurationProperties(value={UnleashProperties.class})
@Import(value={FeatureAdvisor.class, FeatureProxyAdvisor.class})
public class UnleashAutoConfiguration {
    @Autowired(required=false)
    private Map<String, ? extends Strategy> strategyMap;

    @Bean
    @ConditionalOnProperty(prefix="io.unleash", value={"appName", "environment", "apiUrl", "apiToken"})
    public Unleash unleash(UnleashProperties unleashProperties) {
        UnleashConfig unleashConfig = UnleashConfig.builder().appName(unleashProperties.getAppName()).environment(unleashProperties.getEnvironment()).unleashAPI(unleashProperties.getApiUrl()).customHttpHeader("Authorization", unleashProperties.getApiToken()).instanceId(!StringUtils.hasText((String)unleashProperties.getInstanceId()) ? unleashProperties.getInstanceId() : UUID.randomUUID().toString()).build();
        return !CollectionUtils.isEmpty(this.strategyMap) ? new DefaultUnleash(unleashConfig, this.strategyMap.values().toArray(new Strategy[0])) : new DefaultUnleash(unleashConfig, new Strategy[0]);
    }
}

