/*
 * Decompiled with CFR 0.152.
 */
package org.unleash.features.aop;

import java.lang.annotation.Annotation;
import java.util.Arrays;
import java.util.stream.IntStream;
import org.aopalliance.intercept.MethodInterceptor;
import org.aopalliance.intercept.MethodInvocation;
import org.springframework.stereotype.Component;
import org.unleash.features.annotation.Context;
import org.unleash.features.aop.UnleashContextThreadLocal;

@Component(value="context.advisor")
public class ContextAdvisor
implements MethodInterceptor {
    public Object invoke(MethodInvocation invocation) throws Throwable {
        try {
            Object[] params = invocation.getArguments();
            Annotation[][] annotations = invocation.getMethod().getParameterAnnotations();
            Class[] parameterTypes = invocation.getMethod().getParameterTypes();
            IntStream.range(0, params.length).forEach(index -> Arrays.stream(annotations[index]).forEach(annotation -> this.setUnleashContext(parameterTypes, params, index, (Annotation)annotation)));
            Object object = invocation.proceed();
            return object;
        }
        finally {
            UnleashContextThreadLocal.unset();
        }
    }

    private void setUnleashContext(Class<?>[] parameterTypes, Object[] params, int index, Annotation annotation) {
        if (annotation.annotationType() == Context.class) {
            Object arg = params[index];
            Class<?> parameterType = parameterTypes[index];
            Context contextAnnotation = (Context)annotation;
            if (arg != null) {
                if (parameterType != String.class) {
                    throw new IllegalArgumentException("Only string params can be annotated with Context annotation");
                }
                UnleashContextThreadLocal.addContextProperty(contextAnnotation.name(), (String)arg);
            }
        }
    }
}

