/*
 * Decompiled with CFR 0.152.
 */
package org.unleash.features.aop;

import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.lang.reflect.Parameter;
import java.util.Arrays;
import org.springframework.aop.TargetSource;
import org.springframework.aop.framework.autoproxy.AbstractAutoProxyCreator;
import org.springframework.beans.BeansException;
import org.springframework.stereotype.Component;
import org.unleash.features.annotation.Context;
import org.unleash.features.aop.ContextAdvisor;

@Component(value="contextProxyAdvisor")
public class ContextProxyAdvisor
extends AbstractAutoProxyCreator {
    public ContextProxyAdvisor() {
        this.setInterceptorNames(new String[]{this.getBeanNameOfFeatureAdvisor()});
    }

    private String getBeanNameOfFeatureAdvisor() {
        return ContextAdvisor.class.getAnnotation(Component.class).value();
    }

    protected Object[] getAdvicesAndAdvisorsForBean(Class<?> beanClass, String beanName, TargetSource customTargetSource) throws BeansException {
        Method[] methods;
        boolean isAnnotatedWithContext;
        if (!beanClass.isInterface() && (isAnnotatedWithContext = Arrays.stream(methods = beanClass.getMethods()).anyMatch(this::hasAnnotation))) {
            return PROXY_WITHOUT_ADDITIONAL_INTERCEPTORS;
        }
        return DO_NOT_PROXY;
    }

    private boolean hasAnnotation(Method method) {
        Parameter[] params = method.getParameters();
        Annotation[][] annotationArr = method.getParameterAnnotations();
        boolean present = false;
        int i = 0;
        while (i < params.length) {
            Annotation[] annotations;
            Annotation[] annotationArray = annotations = annotationArr[i];
            int n = annotations.length;
            int n2 = 0;
            while (n2 < n) {
                Annotation annotation = annotationArray[n2];
                if (annotation.annotationType() == Context.class) {
                    present = true;
                    if (params[i].getType() != String.class) {
                        throw new IllegalArgumentException("Only String type can be annotated with Context");
                    }
                }
                ++n2;
            }
            ++i;
        }
        return present;
    }
}

