/*
 * Decompiled with CFR 0.152.
 */
package org.unleash.features.aop;

import io.getunleash.Unleash;
import io.getunleash.UnleashContext;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.Optional;
import org.aopalliance.intercept.MethodInterceptor;
import org.aopalliance.intercept.MethodInvocation;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.aop.framework.Advised;
import org.springframework.aop.support.AopUtils;
import org.springframework.context.ApplicationContext;
import org.springframework.core.annotation.AnnotatedElementUtils;
import org.springframework.stereotype.Component;
import org.springframework.stereotype.Repository;
import org.springframework.stereotype.Service;
import org.springframework.util.StringUtils;
import org.unleash.features.annotation.Toggle;

@Component(value="feature.advisor")
public class FeatureAdvisor
implements MethodInterceptor {
    private static final Logger LOGGER = LoggerFactory.getLogger(FeatureAdvisor.class);
    private final Unleash unleash;
    private final ApplicationContext applicationContext;

    public FeatureAdvisor(Unleash unleash, ApplicationContext applicationContext) {
        this.unleash = unleash;
        this.applicationContext = applicationContext;
    }

    public Object invoke(MethodInvocation mi) throws Throwable {
        Toggle toggle = this.getToggleAnnotation(mi);
        if (toggle != null) {
            String alterBean = toggle.alterBean();
            boolean usingAlterBean = StringUtils.hasText((String)alterBean);
            if (alterBean.equals(this.getExecutedBeanName(mi))) {
                return mi.proceed();
            }
            boolean isFeatureToggled = this.check(toggle, mi);
            if (isFeatureToggled) {
                if (usingAlterBean) {
                    return this.invokeAlterBean(mi, alterBean);
                }
                throw new IllegalArgumentException("alterClass not yet supported");
            }
        }
        return mi.proceed();
    }

    private Object invokeAlterBean(MethodInvocation mi, String alterBeanName) {
        Method method = mi.getMethod();
        try {
            Object alterBean = this.applicationContext.getBean(alterBeanName);
            return method.invoke(alterBean, mi.getArguments());
        }
        catch (Exception e) {
            throw new IllegalArgumentException(String.format("Cannot invoke method %s on bean %s", method.getName(), alterBeanName), e);
        }
    }

    private boolean check(Toggle toggle, MethodInvocation mi) {
        String featureId = toggle.name();
        Object[] arguments = mi.getArguments();
        Optional<UnleashContext> contextOpt = Arrays.stream(arguments).filter(a -> a instanceof UnleashContext).map(a -> (UnleashContext)a).findFirst();
        return contextOpt.map(context -> this.unleash.isEnabled(featureId, context)).orElse(this.unleash.isEnabled(featureId));
    }

    private String getExecutedBeanName(MethodInvocation mi) {
        Class<?> targetClass = this.getExecutedClass(mi);
        Component component = targetClass.getAnnotation(Component.class);
        if (component != null) {
            return component.value();
        }
        Service service = targetClass.getAnnotation(Service.class);
        if (service != null) {
            return service.value();
        }
        Repository repository = targetClass.getAnnotation(Repository.class);
        if (repository != null) {
            return repository.value();
        }
        try {
            String[] stringArray = this.applicationContext.getBeanDefinitionNames();
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                String beanName = stringArray[n2];
                Object bean = this.applicationContext.getBean(beanName);
                if (AopUtils.isJdkDynamicProxy((Object)bean)) {
                    bean = ((Advised)bean).getTargetSource().getTarget();
                }
                if (bean != null && bean.getClass().isAssignableFrom(targetClass)) {
                    return beanName;
                }
                ++n2;
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        throw new IllegalArgumentException("Cannot read behind proxy target");
    }

    private Toggle getToggleAnnotation(MethodInvocation mi) {
        Method method = mi.getMethod();
        if (AnnotatedElementUtils.hasAnnotation((AnnotatedElement)method, Toggle.class)) {
            return (Toggle)AnnotatedElementUtils.findMergedAnnotation((AnnotatedElement)method, Toggle.class);
        }
        Class<?> currentInterface = method.getDeclaringClass();
        if (AnnotatedElementUtils.hasAnnotation(currentInterface, Toggle.class)) {
            return (Toggle)AnnotatedElementUtils.findMergedAnnotation(currentInterface, Toggle.class);
        }
        Class<?> currentImplementation = this.getExecutedClass(mi);
        if (AnnotatedElementUtils.hasAnnotation(currentImplementation, Toggle.class)) {
            return (Toggle)AnnotatedElementUtils.findMergedAnnotation(currentImplementation, Toggle.class);
        }
        return null;
    }

    private Class<?> getExecutedClass(MethodInvocation mi) {
        Object ref = mi.getThis();
        Class executedClass = ref != null ? AopUtils.getTargetClass((Object)ref) : null;
        if (executedClass == null) {
            throw new IllegalArgumentException("Static methods cannot feature feature flipping");
        }
        return executedClass;
    }
}

