/*
 * Decompiled with CFR 0.152.
 */
package net.mamoe.kjbb.compiler.backend.jvm;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import net.mamoe.kjbb.compiler.backend.ir.JvmBlockingBridgeUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.com.intellij.psi.PsiElement;
import org.jetbrains.kotlin.com.intellij.psi.PsiFile;
import org.jetbrains.kotlin.config.JvmTarget;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.ClassKind;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptorWithSource;
import org.jetbrains.kotlin.descriptors.FunctionDescriptor;
import org.jetbrains.kotlin.descriptors.PackageFragmentDescriptor;
import org.jetbrains.kotlin.descriptors.SourceElement;
import org.jetbrains.kotlin.descriptors.SourceFile;
import org.jetbrains.kotlin.descriptors.annotations.AnnotationDescriptor;
import org.jetbrains.kotlin.diagnostics.Diagnostic;
import org.jetbrains.kotlin.load.kotlin.ModuleVisibilityUtilsKt;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.platform.SimplePlatform;
import org.jetbrains.kotlin.platform.TargetPlatform;
import org.jetbrains.kotlin.platform.TargetPlatformVersion;
import org.jetbrains.kotlin.psi.KtAnnotationEntry;
import org.jetbrains.kotlin.psi.KtFile;
import org.jetbrains.kotlin.psi.psiUtil.PsiUtilsKt;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.checkers.DeclarationCheckerContext;
import org.jetbrains.kotlin.resolve.descriptorUtil.DescriptorUtilsKt;
import org.jetbrains.kotlin.resolve.source.KotlinSourceElement;
import org.jetbrains.kotlin.resolve.source.PsiSourceElement;
import org.jetbrains.kotlin.resolve.source.PsiSourceElementKt;
import org.jetbrains.kotlin.resolve.source.PsiSourceFile;
import org.jetbrains.kotlin.util.slicedMap.ReadOnlySlice;

@Metadata(mv={1, 6, 0}, k=2, xi=48, d1={"\u0000X\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u001a\u001a\u0010\u0005\u001a\n\u0012\u0004\u0012\u00020\u0007\u0018\u00010\u0006*\u00020\b2\u0006\u0010\t\u001a\u00020\n\u001a\u001c\u0010\u000b\u001a\u0004\u0018\u00010\u0007*\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\f\u001a\u00020\r\u001a\u000e\u0010\u000e\u001a\u0004\u0018\u00010\u000f*\u00020\u0007H\u0000\u001a\u0014\u0010\u0010\u001a\u00020\u0011*\u00020\u000f2\u0006\u0010\u0012\u001a\u00020\u000fH\u0000\u001a\f\u0010\u0013\u001a\u00020\u0011*\u00020\u0001H\u0000\u001a\f\u0010\u0014\u001a\u00020\u0011*\u00020\u0015H\u0000\u001a\f\u0010\u0016\u001a\u00020\u0011*\u00020\u0002H\u0000\u001a\u000e\u0010\u0017\u001a\u0004\u0018\u00010\u0007*\u00020\u0018H\u0000\u001a\u001c\u0010\u0019\u001a\u0004\u0018\u00010\u0007*\u00020\u00022\u0006\u0010\u001a\u001a\u00020\u00112\u0006\u0010\t\u001a\u00020\n\u001a\u000e\u0010\u001b\u001a\u0004\u0018\u00010\u000f*\u00020\u0018H\u0000\u001a\u0014\u0010\u001c\u001a\u00020\u001d*\u00020\u001e2\u0006\u0010\u001f\u001a\u00020 H\u0000\"\u001a\u0010\u0000\u001a\u0004\u0018\u00010\u0001*\u00020\u00028@X\u0080\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0003\u0010\u0004\u00a8\u0006!"}, d2={"containingClass", "Lorg/jetbrains/kotlin/descriptors/ClassDescriptor;", "Lorg/jetbrains/kotlin/descriptors/FunctionDescriptor;", "getContainingClass", "(Lorg/jetbrains/kotlin/descriptors/FunctionDescriptor;)Lorg/jetbrains/kotlin/descriptors/ClassDescriptor;", "containingFileAnnotations", "", "Lorg/jetbrains/kotlin/descriptors/annotations/AnnotationDescriptor;", "Lorg/jetbrains/kotlin/descriptors/DeclarationDescriptorWithSource;", "bindingContext", "Lorg/jetbrains/kotlin/resolve/BindingContext;", "findFileAnnotation", "fqName", "Lorg/jetbrains/kotlin/name/FqName;", "findPsi", "Lorg/jetbrains/kotlin/com/intellij/psi/PsiElement;", "isChildOf", "", "parent", "isInterface", "isJvm8OrHigher", "Lorg/jetbrains/kotlin/platform/TargetPlatform;", "isUserDeclaredFunction", "jvmBlockingBridgeAnnotation", "Lorg/jetbrains/kotlin/descriptors/DeclarationDescriptor;", "jvmBlockingBridgeAnnotationOnContainingDeclaration", "isIr", "jvmBlockingBridgeAnnotationPsi", "report", "", "Lorg/jetbrains/kotlin/resolve/checkers/DeclarationCheckerContext;", "diagnostic", "Lorg/jetbrains/kotlin/diagnostics/Diagnostic;", "kotlin-jvm-blocking-bridge-compiler"})
public final class AnalyzingKt {
    public static final boolean isJvm8OrHigher(@NotNull TargetPlatform $this$isJvm8OrHigher) {
        boolean bl;
        block4: {
            Intrinsics.checkNotNullParameter($this$isJvm8OrHigher, "<this>");
            Iterable $this$any$iv = $this$isJvm8OrHigher.getComponentPlatforms();
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    SimplePlatform it = (SimplePlatform)element$iv;
                    boolean bl2 = false;
                    TargetPlatformVersion targetPlatformVersion = it.getTargetPlatformVersion();
                    JvmTarget jvmTarget = targetPlatformVersion instanceof JvmTarget ? (JvmTarget)targetPlatformVersion : null;
                    if (jvmTarget == null) {
                        jvmTarget = JvmTarget.DEFAULT;
                    }
                    if (!(jvmTarget.compareTo((Enum)JvmTarget.JVM_1_8) >= 0)) continue;
                    bl = true;
                    break block4;
                }
                bl = false;
            }
        }
        return bl;
    }

    public static final boolean isChildOf(@NotNull PsiElement $this$isChildOf, @NotNull PsiElement parent) {
        boolean bl;
        block1: {
            Intrinsics.checkNotNullParameter($this$isChildOf, "<this>");
            Intrinsics.checkNotNullParameter(parent, "parent");
            Sequence $this$any$iv = PsiUtilsKt.getParents((PsiElement)$this$isChildOf);
            boolean $i$f$any = false;
            Iterator iterator2 = $this$any$iv.iterator();
            while (iterator2.hasNext()) {
                Object element$iv = iterator2.next();
                PsiElement it = (PsiElement)element$iv;
                boolean bl2 = false;
                if (!Intrinsics.areEqual(it, parent)) continue;
                bl = true;
                break block1;
            }
            bl = false;
        }
        return bl;
    }

    public static final boolean isInterface(@NotNull ClassDescriptor $this$isInterface) {
        Intrinsics.checkNotNullParameter($this$isInterface, "<this>");
        return $this$isInterface.getKind() == ClassKind.INTERFACE;
    }

    @Nullable
    public static final AnnotationDescriptor jvmBlockingBridgeAnnotationOnContainingDeclaration(@NotNull FunctionDescriptor $this$jvmBlockingBridgeAnnotationOnContainingDeclaration, boolean isIr, @NotNull BindingContext bindingContext) {
        AnnotationDescriptor annotationDescriptor;
        Intrinsics.checkNotNullParameter($this$jvmBlockingBridgeAnnotationOnContainingDeclaration, "<this>");
        Intrinsics.checkNotNullParameter(bindingContext, "bindingContext");
        DeclarationDescriptor declarationDescriptor = $this$jvmBlockingBridgeAnnotationOnContainingDeclaration.getContainingDeclaration();
        Intrinsics.checkNotNullExpressionValue(declarationDescriptor, "containingDeclaration");
        DeclarationDescriptor containingDeclaration = declarationDescriptor;
        if (containingDeclaration instanceof ClassDescriptor) {
            AnnotationDescriptor ann = containingDeclaration.getAnnotations().findAnnotation(JvmBlockingBridgeUtils.getJVM_BLOCKING_BRIDGE_FQ_NAME());
            if (ann != null) {
                return ann;
            }
            annotationDescriptor = AnalyzingKt.findFileAnnotation((DeclarationDescriptorWithSource)containingDeclaration, bindingContext, JvmBlockingBridgeUtils.getJVM_BLOCKING_BRIDGE_FQ_NAME());
        } else if (containingDeclaration instanceof PackageFragmentDescriptor) {
            if (isIr) {
                return AnalyzingKt.jvmBlockingBridgeAnnotation(containingDeclaration);
            }
            annotationDescriptor = containingDeclaration.getAnnotations().findAnnotation(JvmBlockingBridgeUtils.getJVM_BLOCKING_BRIDGE_FQ_NAME());
        } else {
            return null;
        }
        return annotationDescriptor;
    }

    @Nullable
    public static final AnnotationDescriptor findFileAnnotation(@NotNull DeclarationDescriptorWithSource $this$findFileAnnotation, @NotNull BindingContext bindingContext, @NotNull FqName fqName) {
        AnnotationDescriptor annotationDescriptor;
        Intrinsics.checkNotNullParameter($this$findFileAnnotation, "<this>");
        Intrinsics.checkNotNullParameter(bindingContext, "bindingContext");
        Intrinsics.checkNotNullParameter(fqName, "fqName");
        List<AnnotationDescriptor> list = AnalyzingKt.containingFileAnnotations($this$findFileAnnotation, bindingContext);
        if (list == null) {
            annotationDescriptor = null;
        } else {
            Object v2;
            block3: {
                for (Object t : (Iterable)list) {
                    AnnotationDescriptor it = (AnnotationDescriptor)t;
                    boolean bl = false;
                    if (!Intrinsics.areEqual(it.getFqName(), fqName)) continue;
                    v2 = t;
                    break block3;
                }
                v2 = null;
            }
            annotationDescriptor = v2;
        }
        return annotationDescriptor;
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    public static final List<AnnotationDescriptor> containingFileAnnotations(@NotNull DeclarationDescriptorWithSource $this$containingFileAnnotations, @NotNull BindingContext bindingContext) {
        void $this$mapNotNullTo$iv$iv;
        Intrinsics.checkNotNullParameter($this$containingFileAnnotations, "<this>");
        Intrinsics.checkNotNullParameter(bindingContext, "bindingContext");
        Object object = $this$containingFileAnnotations.getSource();
        KotlinSourceElement kotlinSourceElement = object instanceof KotlinSourceElement ? (KotlinSourceElement)object : null;
        SourceFile sourceFile = kotlinSourceElement == null ? null : kotlinSourceElement.getContainingFile();
        PsiSourceFile psiSourceFile = sourceFile instanceof PsiSourceFile ? (PsiSourceFile)sourceFile : null;
        if (psiSourceFile == null) {
            return null;
        }
        PsiSourceFile sourceFile2 = psiSourceFile;
        PsiFile psiFile = sourceFile2.getPsiFile();
        KtFile ktFile = psiFile instanceof KtFile ? (KtFile)psiFile : null;
        if (ktFile == null) {
            return null;
        }
        KtFile file = ktFile;
        Iterable $this$mapNotNull$iv = file.getAnnotationEntries();
        boolean $i$f$mapNotNull = false;
        object = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator2 = $this$forEach$iv$iv$iv.iterator();
        while (iterator2.hasNext()) {
            AnnotationDescriptor it$iv$iv;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator2.next();
            boolean bl = false;
            KtAnnotationEntry it = (KtAnnotationEntry)element$iv$iv;
            boolean bl2 = false;
            if ((AnnotationDescriptor)bindingContext.get((ReadOnlySlice)BindingContext.ANNOTATION, (Object)it) == null) continue;
            boolean bl3 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    public static final boolean isUserDeclaredFunction(@NotNull FunctionDescriptor $this$isUserDeclaredFunction) {
        Intrinsics.checkNotNullParameter($this$isUserDeclaredFunction, "<this>");
        FunctionDescriptor functionDescriptor = $this$isUserDeclaredFunction.getOriginal();
        Intrinsics.checkNotNullExpressionValue(functionDescriptor, "original");
        return PsiSourceElementKt.getPsi((SourceElement)ModuleVisibilityUtilsKt.getToSourceElement((DeclarationDescriptor)((DeclarationDescriptor)functionDescriptor))) != null;
    }

    @Nullable
    public static final ClassDescriptor getContainingClass(@NotNull FunctionDescriptor $this$containingClass) {
        Object v0;
        block1: {
            Intrinsics.checkNotNullParameter($this$containingClass, "<this>");
            Sequence $this$firstOrNull$iv = DescriptorUtilsKt.getParents((DeclarationDescriptor)((DeclarationDescriptor)$this$containingClass));
            boolean $i$f$firstOrNull = false;
            Iterator iterator2 = $this$firstOrNull$iv.iterator();
            while (iterator2.hasNext()) {
                Object element$iv = iterator2.next();
                DeclarationDescriptor it = (DeclarationDescriptor)element$iv;
                boolean bl = false;
                if (!(it instanceof ClassDescriptor)) continue;
                v0 = element$iv;
                break block1;
            }
            v0 = null;
        }
        return v0;
    }

    public static final void report(@NotNull DeclarationCheckerContext $this$report, @NotNull Diagnostic diagnostic) {
        Intrinsics.checkNotNullParameter($this$report, "<this>");
        Intrinsics.checkNotNullParameter(diagnostic, "diagnostic");
        $this$report.getTrace().report(diagnostic);
    }

    @Nullable
    public static final PsiElement jvmBlockingBridgeAnnotationPsi(@NotNull DeclarationDescriptor $this$jvmBlockingBridgeAnnotationPsi) {
        Intrinsics.checkNotNullParameter($this$jvmBlockingBridgeAnnotationPsi, "<this>");
        AnnotationDescriptor annotationDescriptor = $this$jvmBlockingBridgeAnnotationPsi.getAnnotations().findAnnotation(JvmBlockingBridgeUtils.getJVM_BLOCKING_BRIDGE_FQ_NAME());
        return annotationDescriptor == null ? null : AnalyzingKt.findPsi(annotationDescriptor);
    }

    @Nullable
    public static final AnnotationDescriptor jvmBlockingBridgeAnnotation(@NotNull DeclarationDescriptor $this$jvmBlockingBridgeAnnotation) {
        Intrinsics.checkNotNullParameter($this$jvmBlockingBridgeAnnotation, "<this>");
        return $this$jvmBlockingBridgeAnnotation.getAnnotations().findAnnotation(JvmBlockingBridgeUtils.getJVM_BLOCKING_BRIDGE_FQ_NAME());
    }

    @Nullable
    public static final PsiElement findPsi(@NotNull AnnotationDescriptor $this$findPsi) {
        Intrinsics.checkNotNullParameter($this$findPsi, "<this>");
        SourceElement sourceElement = $this$findPsi.getSource();
        PsiSourceElement psiSourceElement = sourceElement instanceof PsiSourceElement ? (PsiSourceElement)sourceElement : null;
        return psiSourceElement == null ? null : psiSourceElement.getPsi();
    }
}

