/*
 * Decompiled with CFR 0.152.
 */
package net.mamoe.mirai.internal.utils.crypto;

import java.security.KeyFactory;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.PrivateKey;
import java.security.Provider;
import java.security.PublicKey;
import java.security.Security;
import java.security.spec.ECGenParameterSpec;
import java.security.spec.X509EncodedKeySpec;
import javax.crypto.KeyAgreement;
import kotlin.Metadata;
import kotlin.Result;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import net.mamoe.mirai.internal.utils.crypto.ECDH;
import net.mamoe.mirai.internal.utils.crypto.ECDHKeyPair;
import net.mamoe.mirai.internal.utils.crypto.ECDHKeyPairImpl;
import net.mamoe.mirai.utils.MiraiUtils;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0012\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0000\u0018\u0000 \u000e2\u00020\u0001:\u0001\u000eB\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0012\u0010\u0007\u001a\u00020\b2\n\u0010\t\u001a\u00060\nj\u0002`\u000bJ\b\u0010\f\u001a\u00020\rH\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u000f"}, d2={"Lnet/mamoe/mirai/internal/utils/crypto/ECDH;", "", "keyPair", "Lnet/mamoe/mirai/internal/utils/crypto/ECDHKeyPair;", "(Lnet/mamoe/mirai/internal/utils/crypto/ECDHKeyPair;)V", "getKeyPair", "()Lnet/mamoe/mirai/internal/utils/crypto/ECDHKeyPair;", "calculateShareKeyByPeerPublicKey", "", "peerPublicKey", "Ljava/security/PublicKey;", "Lnet/mamoe/mirai/internal/utils/crypto/ECDHPublicKey;", "toString", "", "Companion", "mirai-core"})
public final class ECDH {
    @NotNull
    private final ECDHKeyPair keyPair;
    private static final String curveName = "secp192k1";
    private static final boolean isECDHAvailable;
    @NotNull
    public static final Companion Companion;

    @NotNull
    public final byte[] calculateShareKeyByPeerPublicKey(@NotNull PublicKey peerPublicKey) {
        Intrinsics.checkNotNullParameter((Object)peerPublicKey, (String)"peerPublicKey");
        return Companion.calculateShareKey(this.keyPair.getPrivateKey(), peerPublicKey);
    }

    @NotNull
    public String toString() {
        return "ECDH(keyPair=" + this.keyPair + ')';
    }

    @NotNull
    public final ECDHKeyPair getKeyPair() {
        return this.keyPair;
    }

    public ECDH(@NotNull ECDHKeyPair keyPair) {
        Intrinsics.checkNotNullParameter((Object)keyPair, (String)"keyPair");
        this.keyPair = keyPair;
    }

    static {
        Object object;
        boolean bl;
        Object object2;
        Companion = new Companion(null);
        boolean bl2 = false;
        try {
            object2 = Result.Companion;
            boolean bl3 = false;
            Companion.1.1 $fun$testECDH$1 = Companion.1.1.INSTANCE;
            bl = false;
            try {
                object = Result.Companion;
                boolean bl4 = false;
                Companion.1.1.INSTANCE.invoke();
                Unit unit = Unit.INSTANCE;
                boolean bl5 = false;
                object = Result.constructor-impl((Object)unit);
            }
            catch (Throwable throwable) {
                Result.Companion companion = Result.Companion;
                boolean bl6 = false;
                object = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)throwable));
            }
            if (!Result.isSuccess-impl((Object)object)) {
                if (Security.getProvider("BC") != null) {
                    Security.removeProvider("BC");
                }
                Security.addProvider((Provider)new BouncyCastleProvider());
                $fun$testECDH$1.invoke();
            }
            Unit unit = Unit.INSTANCE;
            boolean bl7 = false;
            object2 = Result.constructor-impl((Object)unit);
        }
        catch (Throwable throwable) {
            Result.Companion companion = Result.Companion;
            bl = false;
            object2 = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)throwable));
        }
        Object object3 = object2;
        boolean bl8 = false;
        boolean bl9 = false;
        Throwable throwable = Result.exceptionOrNull-impl((Object)object3);
        if (throwable != null) {
            Throwable throwable2 = throwable;
            boolean bl10 = false;
            bl = false;
            object = throwable2;
            boolean bl11 = false;
            Object it = object;
            boolean bl12 = false;
            ((Throwable)it).printStackTrace();
        }
        isECDHAvailable = Result.isSuccess-impl((Object)object3);
    }

    @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0012\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001e\u0010\b\u001a\u00020\t2\n\u0010\n\u001a\u00060\u000bj\u0002`\f2\n\u0010\r\u001a\u00060\u000ej\u0002`\u000fJ\u0012\u0010\u0010\u001a\u00060\u000ej\u0002`\u000f2\u0006\u0010\u0011\u001a\u00020\tJ\u0006\u0010\u0012\u001a\u00020\u0013R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0007\u00a8\u0006\u0014"}, d2={"Lnet/mamoe/mirai/internal/utils/crypto/ECDH$Companion;", "", "()V", "curveName", "", "isECDHAvailable", "", "()Z", "calculateShareKey", "", "privateKey", "Ljava/security/PrivateKey;", "Lnet/mamoe/mirai/internal/utils/crypto/ECDHPrivateKey;", "publicKey", "Ljava/security/PublicKey;", "Lnet/mamoe/mirai/internal/utils/crypto/ECDHPublicKey;", "constructPublicKey", "key", "generateKeyPair", "Lnet/mamoe/mirai/internal/utils/crypto/ECDHKeyPair;", "mirai-core"})
    public static final class Companion {
        public final boolean isECDHAvailable() {
            return isECDHAvailable;
        }

        @NotNull
        public final ECDHKeyPair generateKeyPair() {
            if (!this.isECDHAvailable()) {
                return ECDHKeyPair.DefaultStub.INSTANCE;
            }
            KeyPairGenerator keyPairGenerator = KeyPairGenerator.getInstance("ECDH");
            boolean bl = false;
            boolean bl2 = false;
            KeyPairGenerator it = keyPairGenerator;
            boolean bl3 = false;
            it.initialize(new ECGenParameterSpec(ECDH.curveName));
            Unit unit = Unit.INSTANCE;
            KeyPair keyPair = keyPairGenerator.genKeyPair();
            Intrinsics.checkNotNullExpressionValue((Object)keyPair, (String)"KeyPairGenerator.getInst\u2026            .genKeyPair()");
            KeyPair keyPair2 = keyPair;
            return new ECDHKeyPairImpl(keyPair2);
        }

        @NotNull
        public final byte[] calculateShareKey(@NotNull PrivateKey privateKey, @NotNull PublicKey publicKey) {
            Intrinsics.checkNotNullParameter((Object)privateKey, (String)"privateKey");
            Intrinsics.checkNotNullParameter((Object)publicKey, (String)"publicKey");
            KeyAgreement instance = KeyAgreement.getInstance("ECDH", "BC");
            instance.init(privateKey);
            instance.doPhase(publicKey, true);
            byte[] byArray = instance.generateSecret();
            Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"instance.generateSecret()");
            return MiraiUtils.md5$default((byte[])byArray, (int)0, (int)0, (int)3, null);
        }

        @NotNull
        public final PublicKey constructPublicKey(@NotNull byte[] key) {
            Intrinsics.checkNotNullParameter((Object)key, (String)"key");
            PublicKey publicKey = KeyFactory.getInstance("EC", "BC").generatePublic(new X509EncodedKeySpec(key));
            Intrinsics.checkNotNullExpressionValue((Object)publicKey, (String)"KeyFactory.getInstance(\"\u2026(X509EncodedKeySpec(key))");
            return publicKey;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

