/*
 * Decompiled with CFR 0.152.
 */
package net.mamoe.mirai.internal.message;

import java.io.Closeable;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Result;
import kotlin.ResultKt;
import kotlin.UInt;
import kotlin.UShort;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.io.CloseableKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Charsets;
import kotlin.text.StringsKt;
import kotlinx.io.core.ByteReadPacket;
import kotlinx.io.core.ByteReadPacketExtensionsKt;
import kotlinx.io.core.Input;
import kotlinx.io.core.InputKt;
import kotlinx.serialization.DeserializationStrategy;
import kotlinx.serialization.json.Json;
import kotlinx.serialization.json.JsonKt;
import net.mamoe.mirai.Bot;
import net.mamoe.mirai.internal.message.ContextualBugReportExceptionKt;
import net.mamoe.mirai.internal.message.FileMessageImpl;
import net.mamoe.mirai.internal.message.ForwardMessageInternal;
import net.mamoe.mirai.internal.message.LightAppInternal;
import net.mamoe.mirai.internal.message.LongMessageInternal;
import net.mamoe.mirai.internal.message.MarketFaceInternal;
import net.mamoe.mirai.internal.message.MessageSourceInternal;
import net.mamoe.mirai.internal.message.MessageToElemsKt;
import net.mamoe.mirai.internal.message.OfflineSourceImplKt;
import net.mamoe.mirai.internal.message.OnlineFriendImageImpl;
import net.mamoe.mirai.internal.message.OnlineGroupImageImpl;
import net.mamoe.mirai.internal.message.OnlineMessageSourceFromFriendImpl;
import net.mamoe.mirai.internal.message.OnlineMessageSourceFromGroupImpl;
import net.mamoe.mirai.internal.message.OnlineMessageSourceFromStrangerImpl;
import net.mamoe.mirai.internal.message.OnlineMessageSourceFromTempImpl;
import net.mamoe.mirai.internal.message.ReceiveMessageTransformer;
import net.mamoe.mirai.internal.message.UnsupportedMessageImpl;
import net.mamoe.mirai.internal.network.protocol.data.proto.CustomFace;
import net.mamoe.mirai.internal.network.protocol.data.proto.HummerCommelem;
import net.mamoe.mirai.internal.network.protocol.data.proto.ImMsgBody;
import net.mamoe.mirai.internal.network.protocol.data.proto.MsgComm;
import net.mamoe.mirai.internal.network.protocol.data.proto.ObjMsg;
import net.mamoe.mirai.internal.utils.io.serialization.SerializationUtils;
import net.mamoe.mirai.message.data.At;
import net.mamoe.mirai.message.data.AtAll;
import net.mamoe.mirai.message.data.CustomMessage;
import net.mamoe.mirai.message.data.Face;
import net.mamoe.mirai.message.data.FlashImage;
import net.mamoe.mirai.message.data.Image;
import net.mamoe.mirai.message.data.MessageChain;
import net.mamoe.mirai.message.data.MessageChainBuilder;
import net.mamoe.mirai.message.data.MessageSource;
import net.mamoe.mirai.message.data.MessageSourceKind;
import net.mamoe.mirai.message.data.PlainText;
import net.mamoe.mirai.message.data.PokeMessage;
import net.mamoe.mirai.message.data.QuoteReply;
import net.mamoe.mirai.message.data.ServiceMessage;
import net.mamoe.mirai.message.data.ShowImageFlag;
import net.mamoe.mirai.message.data.SimpleServiceMessage;
import net.mamoe.mirai.message.data.SingleMessage;
import net.mamoe.mirai.message.data.VipFace;
import net.mamoe.mirai.message.data.Voice;
import net.mamoe.mirai.utils.MiraiUtils;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u00a0\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b\u00c0\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J,\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000eJ\u0018\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0015H\u0002J\u0018\u0010\u0016\u001a\u00020\u00112\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0014\u001a\u00020\u0015H\u0002J\u0018\u0010\u0019\u001a\u00020\u00112\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u0015H\u0002J\u0018\u0010\u001d\u001a\u00020\u00112\u0006\u0010\u001e\u001a\u00020\u001f2\u0006\u0010\u0014\u001a\u00020\u0015H\u0002J\u0018\u0010 \u001a\u00020\u00112\u0006\u0010!\u001a\u00020\"2\u0006\u0010\u001c\u001a\u00020\u0015H\u0002J0\u0010#\u001a\u00020\u00112\u0006\u0010$\u001a\u00020%2\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010&\u001a\u00020'H\u0002J\u0018\u0010(\u001a\u00020\u00112\u0006\u0010)\u001a\u00020*2\u0006\u0010\u0014\u001a\u00020\u0015H\u0002J\u0018\u0010+\u001a\u00020\u00112\u0006\u0010,\u001a\u00020-2\u0006\u0010\u0014\u001a\u00020\u0015H\u0002J4\u0010.\u001a\u00020\u00112\f\u0010/\u001a\b\u0012\u0004\u0012\u0002000\u000e2\u0006\u0010&\u001a\u00020'2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\u001c\u001a\u00020\u0015J0\u00101\u001a\u00020\u00112\u0006\u00102\u001a\u0002002\u0006\u0010&\u001a\u00020'2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\u001c\u001a\u00020\u0015H\u0002J\n\u00103\u001a\u000204*\u000204J\n\u00105\u001a\u00020\u0011*\u00020\u0015J\n\u00106\u001a\u000207*\u000208R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00069"}, d2={"Lnet/mamoe/mirai/internal/message/ReceiveMessageTransformer;", "", "()V", "jsonForFileDecode", "Lkotlinx/serialization/json/Json;", "createMessageSource", "Lnet/mamoe/mirai/message/data/MessageSource;", "bot", "Lnet/mamoe/mirai/Bot;", "onlineSource", "", "messageSourceKind", "Lnet/mamoe/mirai/message/data/MessageSourceKind;", "messageList", "", "Lnet/mamoe/mirai/internal/network/protocol/data/proto/MsgComm$Msg;", "decodeCommonElem", "", "commonElem", "Lnet/mamoe/mirai/internal/network/protocol/data/proto/ImMsgBody$CommonElem;", "list", "Lnet/mamoe/mirai/message/data/MessageChainBuilder;", "decodeCustomElem", "customElem", "Lnet/mamoe/mirai/internal/network/protocol/data/proto/ImMsgBody$CustomElem;", "decodeCustomFace", "customFace", "Lnet/mamoe/mirai/internal/network/protocol/data/proto/ImMsgBody$CustomFace;", "builder", "decodeLightApp", "lightApp", "Lnet/mamoe/mirai/internal/network/protocol/data/proto/ImMsgBody$LightAppElem;", "decodeRichMessage", "richMsg", "Lnet/mamoe/mirai/internal/network/protocol/data/proto/ImMsgBody$RichMsg;", "decodeSrcMsg", "srcMsg", "Lnet/mamoe/mirai/internal/network/protocol/data/proto/ImMsgBody$SourceMsg;", "groupIdOrZero", "", "decodeText", "text", "Lnet/mamoe/mirai/internal/network/protocol/data/proto/ImMsgBody$Text;", "decodeTransElem", "transElement", "Lnet/mamoe/mirai/internal/network/protocol/data/proto/ImMsgBody$TransElem;", "joinToMessageChain", "elements", "Lnet/mamoe/mirai/internal/network/protocol/data/proto/ImMsgBody$Elem;", "transformElement", "element", "cleanupRubbishMessageElements", "Lnet/mamoe/mirai/message/data/MessageChain;", "compressContinuousPlainText", "toVoice", "Lnet/mamoe/mirai/message/data/Voice;", "Lnet/mamoe/mirai/internal/network/protocol/data/proto/ImMsgBody$Ptt;", "mirai-core"})
public final class ReceiveMessageTransformer {
    @NotNull
    public static final ReceiveMessageTransformer INSTANCE = new ReceiveMessageTransformer();
    @NotNull
    private static final Json jsonForFileDecode = JsonKt.Json$default(null, (Function1)jsonForFileDecode.1.INSTANCE, (int)1, null);

    private ReceiveMessageTransformer() {
    }

    @NotNull
    public final MessageSource createMessageSource(@NotNull Bot bot, boolean onlineSource, @NotNull MessageSourceKind messageSourceKind, @NotNull List<MsgComm.Msg> messageList) {
        MessageSource messageSource;
        Intrinsics.checkNotNullParameter((Object)bot, (String)"bot");
        Intrinsics.checkNotNullParameter((Object)messageSourceKind, (String)"messageSourceKind");
        Intrinsics.checkNotNullParameter(messageList, (String)"messageList");
        boolean bl = onlineSource;
        if (bl) {
            MessageSourceInternal messageSourceInternal;
            MessageSourceKind messageSourceKind2 = messageSourceKind;
            int n = WhenMappings.$EnumSwitchMapping$0[messageSourceKind2.ordinal()];
            switch (n) {
                case 1: {
                    messageSourceInternal = new OnlineMessageSourceFromTempImpl(bot, messageList);
                    break;
                }
                case 2: {
                    messageSourceInternal = new OnlineMessageSourceFromGroupImpl(bot, messageList);
                    break;
                }
                case 3: {
                    messageSourceInternal = new OnlineMessageSourceFromFriendImpl(bot, messageList);
                    break;
                }
                case 4: {
                    messageSourceInternal = new OnlineMessageSourceFromStrangerImpl(bot, messageList);
                    break;
                }
                default: {
                    throw new NoWhenBranchMatchedException();
                }
            }
            messageSource = (MessageSource)messageSourceInternal;
        } else if (!bl) {
            messageSource = (MessageSource)OfflineSourceImplKt.OfflineMessageSourceImplData(bot, messageList, messageSourceKind);
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return messageSource;
    }

    public final void joinToMessageChain(@NotNull List<ImMsgBody.Elem> elements, long groupIdOrZero, @NotNull MessageSourceKind messageSourceKind, @NotNull Bot bot, @NotNull MessageChainBuilder builder) {
        Intrinsics.checkNotNullParameter(elements, (String)"elements");
        Intrinsics.checkNotNullParameter((Object)messageSourceKind, (String)"messageSourceKind");
        Intrinsics.checkNotNullParameter((Object)bot, (String)"bot");
        Intrinsics.checkNotNullParameter((Object)builder, (String)"builder");
        for (ImMsgBody.Elem element : elements) {
            this.transformElement(element, groupIdOrZero, messageSourceKind, bot, builder);
            if (element.richMsg == null) continue;
            this.decodeRichMessage(element.richMsg, builder);
        }
    }

    private final void transformElement(ImMsgBody.Elem element, long groupIdOrZero, MessageSourceKind messageSourceKind, Bot bot, MessageChainBuilder builder) {
        if (element.srcMsg != null) {
            this.decodeSrcMsg(element.srcMsg, builder, bot, messageSourceKind, groupIdOrZero);
        } else if (element.notOnlineImage != null) {
            builder.add((SingleMessage)new OnlineFriendImageImpl(element.notOnlineImage));
        } else if (element.customFace != null) {
            this.decodeCustomFace(element.customFace, builder);
        } else if (element.face != null) {
            builder.add((SingleMessage)new Face(element.face.index));
        } else if (element.text != null) {
            this.decodeText(element.text, builder);
        } else if (element.marketFace != null) {
            builder.add((SingleMessage)new MarketFaceInternal(element.marketFace));
        } else if (element.lightApp != null) {
            this.decodeLightApp(element.lightApp, builder);
        } else if (element.customElem != null) {
            this.decodeCustomElem(element.customElem, builder);
        } else if (element.commonElem != null) {
            this.decodeCommonElem(element.commonElem, builder);
        } else if (element.transElemInfo != null) {
            this.decodeTransElem(element.transElemInfo, builder);
        } else if (element.elemFlags2 == null && element.extraInfo == null && element.generalFlags == null) {
            UnsupportedMessageImpl unsupportedMessageImpl;
            UnsupportedMessageImpl unsupportedMessageImpl2 = new UnsupportedMessageImpl(element);
            boolean bl = false;
            boolean bl2 = false;
            UnsupportedMessageImpl it = unsupportedMessageImpl2;
            boolean bl3 = false;
            byte[] byArray = it.getStruct();
            boolean bl4 = false;
            byte[] byArray2 = byArray;
            boolean bl5 = false;
            UnsupportedMessageImpl unsupportedMessageImpl3 = unsupportedMessageImpl = !(byArray2.length == 0) ? unsupportedMessageImpl2 : null;
            if (unsupportedMessageImpl != null) {
                unsupportedMessageImpl2 = unsupportedMessageImpl;
                bl = false;
                bl2 = false;
                SingleMessage p0 = (SingleMessage)unsupportedMessageImpl2;
                boolean bl6 = false;
                builder.add(p0);
            }
        }
    }

    public final void compressContinuousPlainText(@NotNull MessageChainBuilder $this$compressContinuousPlainText) {
        Intrinsics.checkNotNullParameter((Object)$this$compressContinuousPlainText, (String)"<this>");
        int index = 0;
        StringBuilder builder = new StringBuilder();
        while (index + 1 < $this$compressContinuousPlainText.size()) {
            SingleMessage elm0 = $this$compressContinuousPlainText.get(index);
            SingleMessage elm1 = $this$compressContinuousPlainText.get(index + 1);
            if (elm0 instanceof PlainText && elm1 instanceof PlainText) {
                builder.setLength(0);
                int end = -1;
                int n = index;
                int n2 = $this$compressContinuousPlainText.size();
                if (n < n2) {
                    int i2;
                    SingleMessage elm;
                    while ((elm = $this$compressContinuousPlainText.get(i2 = n++)) instanceof PlainText) {
                        end = i2;
                        builder.append(((PlainText)elm).getContent());
                        if (n < n2) continue;
                    }
                }
                String string = builder.toString();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"builder.toString()");
                $this$compressContinuousPlainText.set(index, (SingleMessage)new PlainText(string));
                int index1 = index + 1;
                n2 = end - index;
                boolean bl = false;
                int n3 = 0;
                n3 = 0;
                int n4 = n2;
                while (n3 < n4) {
                    int it = n3++;
                    boolean bl2 = false;
                    $this$compressContinuousPlainText.remove(index1);
                }
            }
            int n = index;
            index = n + 1;
        }
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final MessageChain cleanupRubbishMessageElements(@NotNull MessageChain $this$cleanupRubbishMessageElements) {
        void initialSize$iv;
        Intrinsics.checkNotNullParameter((Object)$this$cleanupRubbishMessageElements, (String)"<this>");
        SingleMessage previousLast = null;
        SingleMessage last = null;
        Collection collection = (Collection)$this$cleanupRubbishMessageElements;
        boolean bl = false;
        int n = collection.size();
        boolean $i$f$buildMessageChain = false;
        boolean bl2 = false;
        MessageChainBuilder messageChainBuilder = new MessageChainBuilder((int)initialSize$iv);
        boolean bl3 = false;
        boolean bl4 = false;
        MessageChainBuilder $this$cleanupRubbishMessageElements_u24lambda_u2d5 = messageChainBuilder;
        boolean bl5 = false;
        Iterable $this$forEach$iv = (Iterable)$this$cleanupRubbishMessageElements;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            SingleMessage singleMessage;
            boolean bl6;
            int n2;
            Object object;
            SingleMessage element = (SingleMessage)element$iv;
            boolean bl7 = false;
            if (last instanceof LongMessageInternal && element instanceof PlainText && Intrinsics.areEqual((Object)element, (Object)MessageToElemsKt.getUNSUPPORTED_MERGED_MESSAGE_PLAIN())) {
                previousLast = last;
                last = element;
                continue;
            }
            if (last instanceof PokeMessage && element instanceof PlainText && Intrinsics.areEqual((Object)element, (Object)MessageToElemsKt.getUNSUPPORTED_POKE_MESSAGE_PLAIN())) {
                previousLast = last;
                last = element;
                continue;
            }
            if (last instanceof VipFace && element instanceof PlainText) {
                object = last;
                VipFace l = (VipFace)object;
                if (((PlainText)element).getContent().length() == 4 + l.getCount() / 10 + l.getKind().getName().length()) {
                    previousLast = last;
                    last = element;
                    continue;
                }
            }
            if (element instanceof PlainText && Intrinsics.areEqual((Object)element, (Object)MessageToElemsKt.getUNSUPPORTED_VOICE_MESSAGE_PLAIN())) {
                previousLast = last;
                last = element;
                continue;
            }
            if (element instanceof PlainText && last instanceof At && previousLast instanceof QuoteReply && StringsKt.startsWith$default((CharSequence)((PlainText)element).getContent(), (char)' ', (boolean)false, (int)2, null)) {
                CollectionsKt.removeLastOrNull((List)((List)$this$cleanupRubbishMessageElements_u24lambda_u2d5));
                object = ((PlainText)element).getContent();
                n2 = 1;
                bl6 = false;
                Object object2 = object;
                if (object2 == null) {
                    throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
                }
                String string = ((String)object2).substring(n2);
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"(this as java.lang.String).substring(startIndex)");
                PlainText plainText = new PlainText(string);
                $this$cleanupRubbishMessageElements_u24lambda_u2d5.add((SingleMessage)plainText);
                previousLast = null;
                last = plainText;
                continue;
            }
            if (element instanceof QuoteReply && (singleMessage = (SingleMessage)CollectionsKt.removeLastOrNull((List)((List)$this$cleanupRubbishMessageElements_u24lambda_u2d5))) != null) {
                object = singleMessage;
                n2 = 0;
                bl6 = false;
                SingleMessage rm = object;
                boolean bl8 = false;
                PlainText plainText = rm instanceof PlainText ? (PlainText)rm : null;
                if (!Intrinsics.areEqual((Object)(plainText == null ? null : plainText.getContent()), (Object)" ")) {
                    $this$cleanupRubbishMessageElements_u24lambda_u2d5.add(rm);
                } else {
                    plainText = (SingleMessage)CollectionsKt.removeLastOrNull((List)((List)$this$cleanupRubbishMessageElements_u24lambda_u2d5));
                    if (plainText != null) {
                        PlainText plainText2 = plainText;
                        boolean bl9 = false;
                        boolean bl10 = false;
                        PlainText rm2 = plainText2;
                        boolean bl11 = false;
                        if (!(rm2 instanceof At)) {
                            $this$cleanupRubbishMessageElements_u24lambda_u2d5.add((SingleMessage)rm2);
                        }
                    }
                }
            }
            $this$cleanupRubbishMessageElements_u24lambda_u2d5.append(element);
            previousLast = last;
            last = element;
        }
        INSTANCE.compressContinuousPlainText($this$cleanupRubbishMessageElements_u24lambda_u2d5);
        return messageChainBuilder.asMessageChain();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    private final void decodeText(ImMsgBody.Text text, MessageChainBuilder list) {
        byte[] byArray = text.attr6Buf;
        boolean bl = false;
        if (byArray.length == 0) {
            list.add((SingleMessage)new PlainText(text.str));
        } else {
            void $this$withUse$iv$iv;
            long id2 = 0L;
            byte[] $this$read$iv = text.attr6Buf;
            boolean $i$f$read = false;
            boolean bl2 = false;
            Object $this$toReadPacket_u24default$iv$iv = $this$read$iv;
            int offset$iv$iv = 0;
            int length$iv$iv = ((byte[])$this$toReadPacket_u24default$iv$iv).length - offset$iv$iv;
            byte[] $this$toReadPacket$iv$iv$iv = $this$toReadPacket_u24default$iv$iv;
            boolean $i$f$toReadPacket = false;
            boolean $i$f$ByteReadPacket = false;
            boolean $i$f$ByteReadPacket2 = false;
            ByteBuffer byteBuffer = ByteBuffer.wrap($this$toReadPacket$iv$iv$iv, offset$iv$iv, length$iv$iv);
            Intrinsics.checkExpressionValueIsNotNull((Object)byteBuffer, (String)"ByteBuffer.wrap(array, offset, length)");
            $this$toReadPacket_u24default$iv$iv = (Closeable)ByteReadPacketExtensionsKt.ByteReadPacket((ByteBuffer)byteBuffer, (Function1)((Function1)new Function1<ByteBuffer, Unit>($this$toReadPacket$iv$iv$iv){
                final /* synthetic */ byte[] $array;
                {
                    this.$array = byArray;
                    super(1);
                }

                public final void invoke(@NotNull ByteBuffer it) {
                    Intrinsics.checkParameterIsNotNull((Object)it, (String)"it");
                    byte[] it2 = this.$array;
                    boolean bl = false;
                }
            }));
            boolean $i$f$withUse = false;
            boolean bl3 = false;
            void var8_12 = $this$withUse$iv$iv;
            boolean bl4 = false;
            boolean bl5 = false;
            Throwable throwable = null;
            try {
                ByteReadPacket $this$decodeText_u24lambda_u2d6 = (ByteReadPacket)var8_12;
                boolean bl6 = false;
                InputKt.discardExact((Input)((Input)$this$decodeText_u24lambda_u2d6), (int)7);
                Input $this$readUInt$iv = (Input)$this$decodeText_u24lambda_u2d6;
                boolean $i$f$readUInt = false;
                int n = $this$readUInt$iv.readInt();
                boolean bl7 = false;
                int n2 = UInt.constructor-impl((int)n);
                boolean bl8 = false;
                id2 = (long)n2 & 0xFFFFFFFFL;
                Unit unit = Unit.INSTANCE;
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                CloseableKt.closeFinally((Closeable)var8_12, (Throwable)throwable);
            }
            if (id2 == 0L) {
                list.add((SingleMessage)AtAll.INSTANCE);
            } else {
                list.add((SingleMessage)new At(id2));
            }
        }
    }

    private final void decodeSrcMsg(ImMsgBody.SourceMsg srcMsg, MessageChainBuilder list, Bot bot, MessageSourceKind messageSourceKind, long groupIdOrZero) {
        list.add((SingleMessage)new QuoteReply((MessageSource)OfflineSourceImplKt.OfflineMessageSourceImplData(srcMsg, bot, messageSourceKind, groupIdOrZero)));
    }

    private final void decodeCustomFace(ImMsgBody.CustomFace customFace, MessageChainBuilder builder) {
        builder.add((SingleMessage)new OnlineGroupImageImpl(customFace));
        byte[] byArray = customFace.pbReserve;
        boolean bl = false;
        boolean bl2 = false;
        byte[] it = byArray;
        boolean bl3 = false;
        byte[] byArray2 = it;
        boolean bl4 = false;
        byte[] byArray3 = byArray2;
        boolean bl5 = false;
        if (!(byArray3.length == 0) && ((CustomFace.ResvAttr)SerializationUtils.loadAs((byte[])it, (DeserializationStrategy)CustomFace.ResvAttr.Companion.serializer())).msgImageShow != null) {
            builder.add((SingleMessage)ShowImageFlag.INSTANCE);
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void decodeLightApp(ImMsgBody.LightAppElem lightApp, MessageChainBuilder list) {
        Object object;
        String string = "\u89e3\u6790 lightApp";
        boolean bl = false;
        boolean bl2 = false;
        bl2 = false;
        try {
            String string2;
            object = Result.Companion;
            boolean bl3 = false;
            byte by = lightApp.data[0];
            switch (by) {
                case 0: {
                    void $this$encodeToString$iv$iv;
                    void $this$encodeToString_u24default$iv;
                    byte[] byArray = lightApp.data;
                    int offset$iv = 1;
                    Charset charset$iv = Charsets.UTF_8;
                    void var13_26 = $this$encodeToString_u24default$iv;
                    Charset charset$iv$iv = charset$iv;
                    boolean $i$f$encodeToString = false;
                    int n = ((void)$this$encodeToString$iv$iv).length - offset$iv;
                    boolean $i$f$String = false;
                    string2 = new String((byte[])$this$encodeToString$iv$iv, offset$iv, n, charset$iv$iv);
                    break;
                }
                case 1: {
                    byte[] $this$encodeToString_u24default$iv = MiraiUtils.unzip$default((byte[])lightApp.data, (int)1, (int)0, (int)2, null);
                    int offset$iv = 0;
                    Charset charset$iv = Charsets.UTF_8;
                    byte[] $this$encodeToString$iv$iv = $this$encodeToString_u24default$iv;
                    Charset charset$iv$iv = charset$iv;
                    boolean $i$f$encodeToString = false;
                    int n = $this$encodeToString$iv$iv.length - offset$iv;
                    boolean $i$f$String = false;
                    string2 = new String($this$encodeToString$iv$iv, offset$iv, n, charset$iv$iv);
                    break;
                }
                default: {
                    String string3 = Intrinsics.stringPlus((String)"unknown compression flag=", (Object)lightApp.data[0]);
                    boolean offset$iv = false;
                    throw (Throwable)new IllegalStateException(string3.toString());
                }
            }
            String string4 = string2;
            by = 0;
            object = Result.constructor-impl((Object)string4);
        }
        catch (Throwable throwable) {
            Result.Companion companion = Result.Companion;
            boolean bl4 = false;
            object = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)throwable));
        }
        Object object2 = object;
        boolean bl5 = false;
        boolean bl6 = false;
        Throwable throwable = Result.exceptionOrNull-impl((Object)object2);
        if (throwable != null) {
            Throwable throwable2 = throwable;
            boolean bl7 = false;
            String string5 = string;
            boolean bl8 = false;
            String string6 = "resId=" + lightApp.msgResid + "data=" + MiraiUtils.toUHexString$default((byte[])lightApp.data, null, (int)0, (int)0, (int)7, null);
            throw ContextualBugReportExceptionKt.contextualBugReportException$default(string5, string6, throwable2, null, 8, null);
        }
        String content = (String)object2;
        list.add((SingleMessage)new LightAppInternal(content));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    private final void decodeCustomElem(ImMsgBody.CustomElem customElem, MessageChainBuilder list) {
        void $this$withUse$iv$iv;
        byte[] $this$read$iv = customElem.data;
        boolean $i$f$read = false;
        boolean bl = false;
        Object $this$toReadPacket_u24default$iv$iv = $this$read$iv;
        int offset$iv$iv = 0;
        int length$iv$iv = ((byte[])$this$toReadPacket_u24default$iv$iv).length - offset$iv$iv;
        byte[] $this$toReadPacket$iv$iv$iv = $this$toReadPacket_u24default$iv$iv;
        boolean $i$f$toReadPacket = false;
        boolean $i$f$ByteReadPacket = false;
        boolean $i$f$ByteReadPacket2 = false;
        ByteBuffer byteBuffer = ByteBuffer.wrap($this$toReadPacket$iv$iv$iv, offset$iv$iv, length$iv$iv);
        Intrinsics.checkExpressionValueIsNotNull((Object)byteBuffer, (String)"ByteBuffer.wrap(array, offset, length)");
        $this$toReadPacket_u24default$iv$iv = (Closeable)ByteReadPacketExtensionsKt.ByteReadPacket((ByteBuffer)byteBuffer, (Function1)((Function1)new Function1<ByteBuffer, Unit>($this$toReadPacket$iv$iv$iv){
            final /* synthetic */ byte[] $array;
            {
                this.$array = byArray;
                super(1);
            }

            public final void invoke(@NotNull ByteBuffer it) {
                Intrinsics.checkParameterIsNotNull((Object)it, (String)"it");
                byte[] it2 = this.$array;
                boolean bl = false;
            }
        }));
        boolean $i$f$withUse = false;
        boolean bl2 = false;
        void var7_9 = $this$withUse$iv$iv;
        boolean bl3 = false;
        boolean bl4 = false;
        Throwable throwable = null;
        try {
            Object object;
            ByteReadPacket $this$decodeCustomElem_u24lambda_u2d13 = (ByteReadPacket)var7_9;
            boolean bl5 = false;
            boolean bl6 = false;
            try {
                object = Result.Companion;
                boolean bl7 = false;
                CustomMessage customMessage = CustomMessage.Companion.load($this$decodeCustomElem_u24lambda_u2d13);
                boolean bl8 = false;
                object = Result.constructor-impl((Object)customMessage);
            }
            catch (Throwable throwable2) {
                Result.Companion companion = Result.Companion;
                boolean bl9 = false;
                object = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)throwable2));
            }
            Object object2 = object;
            boolean bl10 = false;
            boolean bl11 = false;
            Throwable throwable3 = Result.exceptionOrNull-impl((Object)object2);
            if (throwable3 == null) {
                CustomMessage it = (CustomMessage)object2;
                boolean bl12 = false;
                if (it != null) {
                    list.add((SingleMessage)it);
                }
            } else {
                Throwable it = throwable3;
                boolean bl13 = false;
                if (it instanceof CustomMessage.Companion.CustomMessageFullDataDeserializeInternalException) {
                    throw new IllegalStateException(Intrinsics.stringPlus((String)"Internal error: exception while deserializing CustomMessage head data, data=", (Object)MiraiUtils.toUHexString$default((byte[])customElem.data, null, (int)0, (int)0, (int)7, null)), it);
                }
                CustomMessage.Companion.CustomMessageFullDataDeserializeUserException cfr_ignored_0 = (CustomMessage.Companion.CustomMessageFullDataDeserializeUserException)it;
                throw new IllegalStateException(Intrinsics.stringPlus((String)"User error: exception while deserializing CustomMessage body, body=", (Object)MiraiUtils.toUHexString$default((byte[])((CustomMessage.Companion.CustomMessageFullDataDeserializeUserException)it).getBody(), null, (int)0, (int)0, (int)7, null)), it);
            }
            Unit unit = Unit.INSTANCE;
        }
        catch (Throwable throwable4) {
            throwable = throwable4;
            throw throwable4;
        }
        finally {
            CloseableKt.closeFinally((Closeable)var7_9, (Throwable)throwable);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    private final void decodeTransElem(ImMsgBody.TransElem transElement, MessageChainBuilder list) {
        int n = transElement.elemType;
        if (n == 24) {
            void $this$withUse$iv$iv;
            byte[] $this$read$iv = transElement.elemValue;
            boolean $i$f$read = false;
            boolean bl = false;
            Object $this$toReadPacket_u24default$iv$iv = $this$read$iv;
            int offset$iv$iv = 0;
            int length$iv$iv = ((byte[])$this$toReadPacket_u24default$iv$iv).length - offset$iv$iv;
            byte[] $this$toReadPacket$iv$iv$iv = $this$toReadPacket_u24default$iv$iv;
            boolean $i$f$toReadPacket = false;
            boolean $i$f$ByteReadPacket = false;
            boolean $i$f$ByteReadPacket2 = false;
            ByteBuffer byteBuffer = ByteBuffer.wrap($this$toReadPacket$iv$iv$iv, offset$iv$iv, length$iv$iv);
            Intrinsics.checkExpressionValueIsNotNull((Object)byteBuffer, (String)"ByteBuffer.wrap(array, offset, length)");
            $this$toReadPacket_u24default$iv$iv = (Closeable)ByteReadPacketExtensionsKt.ByteReadPacket((ByteBuffer)byteBuffer, (Function1)((Function1)new Function1<ByteBuffer, Unit>($this$toReadPacket$iv$iv$iv){
                final /* synthetic */ byte[] $array;
                {
                    this.$array = byArray;
                    super(1);
                }

                public final void invoke(@NotNull ByteBuffer it) {
                    Intrinsics.checkParameterIsNotNull((Object)it, (String)"it");
                    byte[] it2 = this.$array;
                    boolean bl = false;
                }
            }));
            boolean $i$f$withUse = false;
            boolean bl2 = false;
            void var8_10 = $this$withUse$iv$iv;
            boolean bl3 = false;
            boolean bl4 = false;
            Throwable throwable = null;
            try {
                ByteReadPacket $this$decodeTransElem_u24lambda_u2d14 = (ByteReadPacket)var8_10;
                boolean bl5 = false;
                byte var7 = $this$decodeTransElem_u24lambda_u2d14.readByte();
                if (var7 == 1) {
                    while ($this$decodeTransElem_u24lambda_u2d14.getRemaining() > 2L) {
                        ObjMsg.MsgContentInfo.MsgFile msgFile;
                        Input $this$readUShort$iv22 = (Input)$this$decodeTransElem_u24lambda_u2d14;
                        boolean $i$f$readUShort = false;
                        short s = $this$readUShort$iv22.readShort();
                        boolean bl6 = false;
                        short $this$readUShort$iv22 = UShort.constructor-impl((short)s);
                        boolean bl7 = false;
                        ObjMsg.ObjMsg proto = (ObjMsg.ObjMsg)SerializationUtils.readProtoBuf($this$decodeTransElem_u24lambda_u2d14, (DeserializationStrategy)ObjMsg.ObjMsg.Companion.serializer(), $this$readUShort$iv22 & 0xFFFF);
                        ObjMsg.MsgContentInfo msgContentInfo = (ObjMsg.MsgContentInfo)CollectionsKt.firstOrNull(proto.msgContentInfo);
                        ObjMsg.MsgContentInfo.MsgFile msgFile2 = msgFile = msgContentInfo == null ? null : msgContentInfo.msgFile;
                        if (msgFile == null) continue;
                        ObjMsg.MsgContentInfo.MsgFile file = msgFile;
                        list.add((SingleMessage)new FileMessageImpl(file.filePath, file.busId, file.fileName, file.fileSize));
                    }
                }
                Unit unit = Unit.INSTANCE;
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                CloseableKt.closeFinally((Closeable)var8_10, (Throwable)throwable);
            }
        }
    }

    /*
     * Unable to fully structure code
     */
    private final void decodeCommonElem(ImMsgBody.CommonElem commonElem, MessageChainBuilder list) {
        var3_3 = commonElem.serviceType;
        switch (var3_3) {
            case 23: {
                proto = (HummerCommelem.MsgElemInfoServtype23)SerializationUtils.loadAs(commonElem.pbElem, (DeserializationStrategy)HummerCommelem.MsgElemInfoServtype23.Companion.serializer());
                list.add((SingleMessage)new VipFace(new VipFace.Kind(proto.faceType, proto.faceSummary), proto.faceBubbleCount));
                break;
            }
            case 2: {
                proto = (HummerCommelem.MsgElemInfoServtype2)SerializationUtils.loadAs(commonElem.pbElem, (DeserializationStrategy)HummerCommelem.MsgElemInfoServtype2.Companion.serializer());
                var6_8 = proto.vaspokeName;
                var7_9 = false;
                var8_12 = false;
                var9_13 = var6_8;
                var15_14 = list;
                $i$a$-takeIf-ReceiveMessageTransformer$decodeCommonElem$1 = false;
                var11_16 = (CharSequence)it;
                var12_18 = false;
                var18_20 = var11_16.length() > 0;
                v0 = var15_14;
                v1 = var5_22 = var18_20 != false ? var6_8 : null;
                if (var5_22 != null) ** GOTO lbl43
                var7_10 = PokeMessage.values;
                var15_14 = v0;
                $i$f$firstOrNull = false;
                var9_13 = $this$firstOrNull$iv;
                var10_15 = ((String)var9_13).length;
                for (var11_17 = 0; var11_17 < var10_15; ++var11_17) {
                    it = element$iv = var9_13[var11_17];
                    $i$a$-firstOrNull-ReceiveMessageTransformer$decodeCommonElem$2 = false;
                    if (!(it.getId() == proto.vaspokeId && it.getPokeType() == proto.pokeType)) continue;
                    v2 = element$iv;
                    ** GOTO lbl34
                }
                v2 = null;
lbl34:
                // 2 sources

                var18_21 = v2;
                v0 = var15_14;
                var6_8 = var18_21;
                var6_8 = var6_8 == null ? null : var6_8.getName();
                var7_11 = false;
                v3 = var6_8;
                if (v3 == null) {
                    v3 = "";
                }
                ** GOTO lbl44
lbl43:
                // 1 sources

                v3 = var5_22;
lbl44:
                // 2 sources

                var19_25 = proto.vaspokeId;
                var20_26 = proto.pokeType;
                var21_27 = v3;
                v0.add((SingleMessage)new PokeMessage(var21_27, var20_26, var19_25));
                break;
            }
            case 3: {
                proto = (HummerCommelem.MsgElemInfoServtype3)SerializationUtils.loadAs(commonElem.pbElem, (DeserializationStrategy)HummerCommelem.MsgElemInfoServtype3.Companion.serializer());
                if (proto.flashTroopPic != null) {
                    list.add((SingleMessage)new FlashImage((Image)new OnlineGroupImageImpl(proto.flashTroopPic)));
                }
                if (proto.flashC2cPic == null) break;
                list.add((SingleMessage)new FlashImage((Image)new OnlineFriendImageImpl(proto.flashC2cPic)));
                break;
            }
            case 33: {
                proto = (HummerCommelem.MsgElemInfoServtype33)SerializationUtils.loadAs(commonElem.pbElem, (DeserializationStrategy)HummerCommelem.MsgElemInfoServtype33.Companion.serializer());
                list.add((SingleMessage)new Face(proto.index));
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void decodeRichMessage(ImMsgBody.RichMsg richMsg, MessageChainBuilder builder) {
        Object object;
        String string = "\u89e3\u6790 richMsg";
        boolean bl = false;
        boolean bl2 = false;
        bl2 = false;
        try {
            String string2;
            object = Result.Companion;
            boolean bl3 = false;
            byte by = richMsg.template1[0];
            switch (by) {
                case 0: {
                    void $this$encodeToString$iv$iv;
                    void $this$encodeToString_u24default$iv;
                    byte[] byArray = richMsg.template1;
                    int offset$iv = 1;
                    Charset charset$iv = Charsets.UTF_8;
                    void var13_32 = $this$encodeToString_u24default$iv;
                    Charset charset$iv$iv = charset$iv;
                    boolean $i$f$encodeToString = false;
                    int n = ((void)$this$encodeToString$iv$iv).length - offset$iv;
                    boolean $i$f$String = false;
                    string2 = new String((byte[])$this$encodeToString$iv$iv, offset$iv, n, charset$iv$iv);
                    break;
                }
                case 1: {
                    byte[] $this$encodeToString_u24default$iv = MiraiUtils.unzip$default((byte[])richMsg.template1, (int)1, (int)0, (int)2, null);
                    int offset$iv = 0;
                    Charset charset$iv = Charsets.UTF_8;
                    byte[] $this$encodeToString$iv$iv = $this$encodeToString_u24default$iv;
                    Charset charset$iv$iv = charset$iv;
                    boolean $i$f$encodeToString = false;
                    int n = $this$encodeToString$iv$iv.length - offset$iv;
                    boolean $i$f$String = false;
                    string2 = new String($this$encodeToString$iv$iv, offset$iv, n, charset$iv$iv);
                    break;
                }
                default: {
                    String string3 = Intrinsics.stringPlus((String)"unknown compression flag=", (Object)richMsg.template1[0]);
                    boolean offset$iv = false;
                    throw (Throwable)new IllegalStateException(string3.toString());
                }
            }
            String string4 = string2;
            by = 0;
            object = Result.constructor-impl((Object)string4);
        }
        catch (Throwable throwable) {
            Result.Companion companion = Result.Companion;
            boolean bl4 = false;
            object = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)throwable));
        }
        Object object2 = object;
        boolean bl5 = false;
        boolean bl6 = false;
        Throwable throwable = Result.exceptionOrNull-impl((Object)object2);
        if (throwable != null) {
            Throwable throwable2 = throwable;
            boolean bl7 = false;
            String string5 = string;
            boolean bl8 = false;
            String string6 = MiraiUtils.toUHexString$default((byte[])richMsg.template1, null, (int)0, (int)0, (int)7, null);
            throw ContextualBugReportExceptionKt.contextualBugReportException$default(string5, string6, throwable2, null, 8, null);
        }
        String content = (String)object2;
        int n = richMsg.serviceId;
        switch (n) {
            case 1: {
                builder.add((SingleMessage)new SimpleServiceMessage(1, content));
                break;
            }
            case 35: {
                ServiceMessage serviceMessage;
                String resId = ReceiveMessageTransformer.decodeRichMessage$findStringProperty(content, "m_resid");
                Object object3 = resId;
                int n2 = 0;
                if (object3.length() == 0) {
                    String fileName = ReceiveMessageTransformer.decodeRichMessage$findStringProperty(content, "m_fileName");
                    CharSequence charSequence = fileName;
                    boolean bl9 = false;
                    serviceMessage = charSequence.length() > 0 && Intrinsics.areEqual((Object)ReceiveMessageTransformer.decodeRichMessage$findStringProperty(content, "action"), (Object)"viewMultiMsg") ? (ServiceMessage)new ForwardMessageInternal(content, null, fileName) : (ServiceMessage)new SimpleServiceMessage(35, content);
                } else {
                    Object object4 = object3 = StringsKt.toIntOrNull((String)ReceiveMessageTransformer.decodeRichMessage$findStringProperty(content, "multiMsgFlag"));
                    n2 = 1;
                    if (object4 != null && (Integer)object4 == n2) {
                        serviceMessage = (ServiceMessage)new LongMessageInternal(content, resId);
                    } else {
                        Object object5 = object3;
                        n2 = 0;
                        serviceMessage = object5 != null && (Integer)object5 == 0 ? (ServiceMessage)new ForwardMessageInternal(content, resId, null) : (Intrinsics.areEqual((Object)ReceiveMessageTransformer.decodeRichMessage$findStringProperty(content, "action"), (Object)"viewMultiMsg") ? (ServiceMessage)new ForwardMessageInternal(content, resId, null) : (ServiceMessage)new SimpleServiceMessage(35, content));
                    }
                }
                ServiceMessage msg = serviceMessage;
                builder.add((SingleMessage)msg);
                break;
            }
            default: {
                builder.add((SingleMessage)new SimpleServiceMessage(richMsg.serviceId, content));
            }
        }
    }

    @NotNull
    public final Voice toVoice(@NotNull ImMsgBody.Ptt $this$toVoice) {
        Intrinsics.checkNotNullParameter((Object)$this$toVoice, (String)"<this>");
        byte[] bytes$iv = $this$toVoice.fileName;
        int offset$iv = 0;
        int length$iv = bytes$iv.length;
        Charset charset$iv = Charsets.UTF_8;
        boolean $i$f$String = false;
        String string = new String(bytes$iv, offset$iv, length$iv, charset$iv);
        bytes$iv = $this$toVoice.downPara;
        offset$iv = 0;
        length$iv = bytes$iv.length;
        charset$iv = Charsets.UTF_8;
        $i$f$String = false;
        return new Voice(string, $this$toVoice.fileMd5, (long)$this$toVoice.fileSize, $this$toVoice.format, new String(bytes$iv, offset$iv, length$iv, charset$iv));
    }

    private static final String decodeRichMessage$findStringProperty(String content, String name2) {
        return StringsKt.substringBefore((String)StringsKt.substringAfter((String)content, (String)Intrinsics.stringPlus((String)name2, (Object)"=\""), (String)""), (String)"\"", (String)"");
    }

    @Metadata(mv={1, 5, 1}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[MessageSourceKind.values().length];
            nArray[MessageSourceKind.TEMP.ordinal()] = 1;
            nArray[MessageSourceKind.GROUP.ordinal()] = 2;
            nArray[MessageSourceKind.FRIEND.ordinal()] = 3;
            nArray[MessageSourceKind.STRANGER.ordinal()] = 4;
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

