/*
 * Decompiled with CFR 0.152.
 */
package net.mamoe.mirai.internal.utils.crypto;

import java.nio.ByteBuffer;
import kotlin.KotlinNothingValueException;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.InlineMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.random.Random;
import kotlinx.io.core.ByteReadPacket;
import kotlinx.io.core.ByteReadPacketExtensionsKt;
import net.mamoe.mirai.internal.utils.crypto.DecryptionFailedException;
import net.mamoe.mirai.utils.ByteArrayPool;
import net.mamoe.mirai.utils.MiraiUtils;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\t\n\u0000\n\u0002\u0010\u0012\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u0001\n\u0002\b\u0003\b\u00c0\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\"\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u00062\u0006\u0010\b\u001a\u00020\u00062\b\b\u0002\u0010\t\u001a\u00020\nH\u0007J,\u0010\u0005\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u000b2\u0006\u0010\b\u001a\u00020\u00062\b\b\u0002\u0010\r\u001a\u00020\n2\b\b\u0002\u0010\t\u001a\u00020\nH\u0007JO\u0010\u000e\u001a\u0002H\u000f\"\u0004\b\u0000\u0010\u000f2\u0006\u0010\f\u001a\u00020\u000b2\u0006\u0010\b\u001a\u00020\u00062\b\b\u0002\u0010\r\u001a\u00020\n2\b\b\u0002\u0010\t\u001a\u00020\n2\u0012\u0010\u0010\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u0002H\u000f0\u0011H\u0086\b\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\u0012J(\u0010\u0013\u001a\u00020\u00062\u0006\u0010\u0014\u001a\u00020\u00062\u0006\u0010\b\u001a\u00020\u00062\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u0015\u001a\u00020\u0016H\u0002J\"\u0010\u0015\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u00062\u0006\u0010\b\u001a\u00020\u00062\b\b\u0002\u0010\t\u001a\u00020\nH\u0007JD\u0010\u0015\u001a\u00020\u00172\u0006\u0010\f\u001a\u00020\u000b2\u0006\u0010\b\u001a\u00020\u00062\b\b\u0002\u0010\r\u001a\u00020\n2\b\b\u0002\u0010\t\u001a\u00020\n2\u0012\u0010\u0010\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00170\u0011H\u0086\b\u00f8\u0001\u0000J\b\u0010\u0018\u001a\u00020\u0019H\u0002J\u001c\u0010\u001a\u001a\u00020\u0004*\u00020\u00062\u0006\u0010\r\u001a\u00020\n2\u0006\u0010\u001b\u001a\u00020\nH\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u0082\u0002\u0007\n\u0005\b\u009920\u0001\u00a8\u0006\u001c"}, d2={"Lnet/mamoe/mirai/internal/utils/crypto/TEA;", "", "()V", "UINT32_MASK", "", "decrypt", "", "source", "key", "length", "", "Lkotlinx/io/core/ByteReadPacket;", "receiver", "offset", "decryptAsByteArray", "R", "consumer", "Lkotlin/Function1;", "(Lkotlinx/io/core/ByteReadPacket;[BIILkotlin/jvm/functions/Function1;)Ljava/lang/Object;", "doOption", "data", "encrypt", "", "", "fail", "", "pack", "len", "mirai-core"})
public final class TEA {
    @NotNull
    public static final TEA INSTANCE = new TEA();
    private static final long UINT32_MASK = 0xFFFFFFFFL;

    private TEA() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void encrypt(@NotNull ByteReadPacket receiver, @NotNull byte[] key, int offset, int length2, @NotNull Function1<? super byte[], Unit> consumer) {
        Intrinsics.checkNotNullParameter((Object)receiver, (String)"receiver");
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        Intrinsics.checkNotNullParameter(consumer, (String)"consumer");
        boolean $i$f$encrypt = false;
        ByteArrayPool this_$iv = ByteArrayPool.INSTANCE;
        boolean requestedSize$iv = false;
        boolean $i$f$useInstance = false;
        byte[] instance$iv = (byte[])this_$iv.borrow();
        try {
            byte[] it = instance$iv;
            boolean bl = false;
            receiver.readFully(it, offset, length2);
            consumer.invoke((Object)TEA.encrypt(it, key, length2));
            Unit unit = Unit.INSTANCE;
        }
        finally {
            InlineMarker.finallyStart((int)1);
            this_$iv.recycle((Object)instance$iv);
            InlineMarker.finallyEnd((int)1);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static /* synthetic */ void encrypt$default(TEA this_, ByteReadPacket receiver, byte[] key, int offset, int length2, Function1 consumer, int n, Object object) {
        if ((n & 4) != 0) {
            offset = 0;
        }
        if ((n & 8) != 0) {
            length2 = (int)receiver.getRemaining() - offset;
        }
        Intrinsics.checkNotNullParameter((Object)receiver, (String)"receiver");
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        Intrinsics.checkNotNullParameter((Object)consumer, (String)"consumer");
        boolean $i$f$encrypt = false;
        ByteArrayPool this_$iv = ByteArrayPool.INSTANCE;
        boolean requestedSize$iv = false;
        boolean $i$f$useInstance = false;
        byte[] instance$iv = (byte[])this_$iv.borrow();
        try {
            byte[] it = instance$iv;
            boolean bl = false;
            receiver.readFully(it, offset, length2);
            consumer.invoke((Object)TEA.encrypt(it, key, length2));
            Unit unit = Unit.INSTANCE;
        }
        finally {
            InlineMarker.finallyStart((int)1);
            this_$iv.recycle((Object)instance$iv);
            InlineMarker.finallyEnd((int)1);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @JvmStatic
    @NotNull
    public static final ByteReadPacket decrypt(@NotNull ByteReadPacket receiver, @NotNull byte[] key, int offset, int length2) {
        ByteReadPacket byteReadPacket;
        Intrinsics.checkNotNullParameter((Object)receiver, (String)"receiver");
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        TEA this_$iv = INSTANCE;
        boolean $i$f$decryptAsByteArray = false;
        ByteArrayPool this_$iv$iv = ByteArrayPool.INSTANCE;
        boolean requestedSize$iv$iv = false;
        boolean $i$f$useInstance = false;
        byte[] instance$iv$iv = (byte[])this_$iv$iv.borrow();
        try {
            byte[] it$iv = instance$iv$iv;
            boolean bl = false;
            receiver.readFully(it$iv, offset, length2);
            byte[] data2 = TEA.decrypt(it$iv, key, length2);
            boolean bl2 = false;
            int offset$iv = 0;
            int length$iv = data2.length;
            boolean $i$f$ByteReadPacket = false;
            boolean $i$f$ByteReadPacket2 = false;
            ByteBuffer byteBuffer = ByteBuffer.wrap(data2, offset$iv, length$iv);
            Intrinsics.checkExpressionValueIsNotNull((Object)byteBuffer, (String)"ByteBuffer.wrap(array, offset, length)");
            byteReadPacket = ByteReadPacketExtensionsKt.ByteReadPacket((ByteBuffer)byteBuffer, (Function1)((Function1)new Function1<ByteBuffer, Unit>(data2){
                final /* synthetic */ byte[] $array;
                {
                    this.$array = byArray;
                    super(1);
                }

                public final void invoke(@NotNull ByteBuffer it) {
                    Intrinsics.checkParameterIsNotNull((Object)it, (String)"it");
                    byte[] it2 = this.$array;
                    boolean bl = false;
                }
            }));
        }
        finally {
            this_$iv$iv.recycle((Object)instance$iv$iv);
        }
        ByteReadPacket byteReadPacket2 = byteReadPacket;
        boolean bl = false;
        boolean bl3 = false;
        ByteReadPacket it$iv = byteReadPacket2;
        boolean bl4 = false;
        receiver.close();
        return byteReadPacket2;
    }

    public static /* synthetic */ ByteReadPacket decrypt$default(ByteReadPacket byteReadPacket, byte[] byArray, int n, int n2, int n3, Object object) {
        if ((n3 & 4) != 0) {
            n = 0;
        }
        if ((n3 & 8) != 0) {
            n2 = (int)(byteReadPacket.getRemaining() - (long)n);
        }
        return TEA.decrypt(byteReadPacket, byArray, n, n2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final <R> R decryptAsByteArray(@NotNull ByteReadPacket receiver, @NotNull byte[] key, int offset, int length2, @NotNull Function1<? super byte[], ? extends R> consumer) {
        Object object;
        Intrinsics.checkNotNullParameter((Object)receiver, (String)"receiver");
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        Intrinsics.checkNotNullParameter(consumer, (String)"consumer");
        boolean $i$f$decryptAsByteArray = false;
        ByteArrayPool this_$iv = ByteArrayPool.INSTANCE;
        boolean requestedSize$iv = false;
        boolean $i$f$useInstance = false;
        byte[] instance$iv = (byte[])this_$iv.borrow();
        try {
            byte[] it = instance$iv;
            boolean bl = false;
            receiver.readFully(it, offset, length2);
            object = consumer.invoke((Object)TEA.decrypt(it, key, length2));
        }
        finally {
            InlineMarker.finallyStart((int)1);
            this_$iv.recycle((Object)instance$iv);
            InlineMarker.finallyEnd((int)1);
        }
        Object object2 = object;
        boolean bl = false;
        boolean bl2 = false;
        Object it = object2;
        boolean bl3 = false;
        receiver.close();
        return (R)object2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static /* synthetic */ Object decryptAsByteArray$default(TEA this_, ByteReadPacket receiver, byte[] key, int offset, int length2, Function1 consumer, int n, Object object) {
        Object object2;
        if ((n & 4) != 0) {
            offset = 0;
        }
        if ((n & 8) != 0) {
            length2 = (int)(receiver.getRemaining() - (long)offset);
        }
        Intrinsics.checkNotNullParameter((Object)receiver, (String)"receiver");
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        Intrinsics.checkNotNullParameter((Object)consumer, (String)"consumer");
        boolean $i$f$decryptAsByteArray = false;
        ByteArrayPool this_$iv = ByteArrayPool.INSTANCE;
        boolean requestedSize$iv = false;
        boolean $i$f$useInstance = false;
        byte[] instance$iv = (byte[])this_$iv.borrow();
        try {
            byte[] it = instance$iv;
            boolean bl = false;
            receiver.readFully(it, offset, length2);
            object2 = consumer.invoke((Object)TEA.decrypt(it, key, length2));
        }
        finally {
            InlineMarker.finallyStart((int)1);
            this_$iv.recycle((Object)instance$iv);
            InlineMarker.finallyEnd((int)1);
        }
        object = object2;
        boolean bl = false;
        boolean bl2 = false;
        Object it = object;
        boolean bl3 = false;
        receiver.close();
        return object;
    }

    private final byte[] doOption(byte[] data2, byte[] key, int length2, boolean encrypt) {
        Ref.ObjectRef mOutput = new Ref.ObjectRef();
        Ref.ObjectRef mInBlock = new Ref.ObjectRef();
        Ref.IntRef mIndexPos = new Ref.IntRef();
        Ref.ObjectRef mIV = new Ref.ObjectRef();
        Ref.IntRef mOutPos = new Ref.IntRef();
        Ref.IntRef mPreOutPos = new Ref.IntRef();
        Ref.BooleanRef isFirstBlock = new Ref.BooleanRef();
        isFirstBlock.element = true;
        long[] mKey = new long[4];
        int n = 0;
        do {
            int i2 = n++;
            mKey[i2] = this.pack(key, i2 * 4, 4);
        } while (n <= 3);
        return encrypt ? TEA.doOption$encrypt((Ref.ObjectRef<byte[]>)mInBlock, (Ref.ObjectRef<byte[]>)mIV, mOutPos, mPreOutPos, isFirstBlock, mIndexPos, (Ref.ObjectRef<byte[]>)mOutput, mKey, data2, 0, length2) : TEA.doOption$decrypt((Ref.ObjectRef<byte[]>)mIV, mIndexPos, isFirstBlock, (Ref.ObjectRef<byte[]>)mOutput, mPreOutPos, mOutPos, mKey, data2, 0, length2);
    }

    private final Void fail() {
        throw new DecryptionFailedException();
    }

    @JvmStatic
    @NotNull
    public static final byte[] encrypt(@NotNull byte[] source, @NotNull byte[] key, int length2) {
        Intrinsics.checkNotNullParameter((Object)source, (String)"source");
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        return INSTANCE.doOption(source, key, length2, true);
    }

    public static /* synthetic */ byte[] encrypt$default(byte[] byArray, byte[] byArray2, int n, int n2, Object object) {
        if ((n2 & 4) != 0) {
            n = byArray.length;
        }
        return TEA.encrypt(byArray, byArray2, n);
    }

    @JvmStatic
    @NotNull
    public static final byte[] decrypt(@NotNull byte[] source, @NotNull byte[] key, int length2) {
        Intrinsics.checkNotNullParameter((Object)source, (String)"source");
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        return INSTANCE.doOption(source, key, length2, false);
    }

    public static /* synthetic */ byte[] decrypt$default(byte[] byArray, byte[] byArray2, int n, int n2, Object object) {
        if ((n2 & 4) != 0) {
            n = byArray.length;
        }
        return TEA.decrypt(byArray, byArray2, n);
    }

    private final long pack(byte[] $this$pack, int offset, int len) {
        long result = 0L;
        int n = offset;
        int maxOffset = len > 8 ? offset + 8 : offset + len;
        if (n < maxOffset) {
            do {
                int index = n++;
                result = result << 8 | (long)$this$pack[index] & 0xFFL;
            } while (n < maxOffset);
        }
        return result >> 32 | result & 0xFFFFFFFFL;
    }

    private static final int doOption$rand() {
        return Random.Default.nextInt();
    }

    private static final byte[] doOption$encode(long[] mKey, byte[] bytes) {
        long v0 = INSTANCE.pack(bytes, 0, 4);
        long v1 = INSTANCE.pack(bytes, 4, 4);
        long sum = 0L;
        long delta = 2654435769L;
        int n = 0;
        do {
            int i2 = n++;
            sum = sum + delta & 0xFFFFFFFFL;
            v0 += (v1 << 4) + mKey[0] ^ v1 + sum ^ (v1 >>> 5) + mKey[1];
            v1 += ((v0 &= 0xFFFFFFFFL) << 4) + mKey[2] ^ v0 + sum ^ (v0 >>> 5) + mKey[3];
            v1 &= 0xFFFFFFFFL;
        } while (n <= 15);
        return ArraysKt.plus((byte[])MiraiUtils.toByteArray((int)((int)v0)), (byte[])MiraiUtils.toByteArray((int)((int)v1)));
    }

    private static final byte[] doOption$decode(long[] mKey, byte[] bytes, int offset) {
        long v0 = INSTANCE.pack(bytes, offset, 4);
        long v1 = INSTANCE.pack(bytes, offset + 4, 4);
        long delta = 2654435769L;
        long sum = delta << 4 & 0xFFFFFFFFL;
        int n = 0;
        do {
            int i2 = n++;
            v1 -= (v0 << 4) + mKey[2] ^ v0 + sum ^ (v0 >>> 5) + mKey[3];
            v0 -= ((v1 &= 0xFFFFFFFFL) << 4) + mKey[0] ^ v1 + sum ^ (v1 >>> 5) + mKey[1];
            v0 &= 0xFFFFFFFFL;
            sum = sum - delta & 0xFFFFFFFFL;
        } while (n <= 15);
        return ArraysKt.plus((byte[])MiraiUtils.toByteArray((int)((int)v0)), (byte[])MiraiUtils.toByteArray((int)((int)v1)));
    }

    private static final void doOption$encodeOneBlock(Ref.IntRef mIndexPos, Ref.ObjectRef<byte[]> mInBlock, Ref.BooleanRef isFirstBlock, Ref.ObjectRef<byte[]> mOutput, Ref.IntRef mPreOutPos, Ref.IntRef mOutPos, Ref.ObjectRef<byte[]> mIV, long[] mKey) {
        byte by;
        int n;
        mIndexPos.element = 0;
        while (mIndexPos.element < 8) {
            int n2;
            byte by2;
            if (mInBlock.element == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"mInBlock");
                throw null;
            }
            byte[] byArray = (byte[])mInBlock.element;
            int n3 = mIndexPos.element;
            if (isFirstBlock.element) {
                if (mInBlock.element == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"mInBlock");
                    throw null;
                }
                by2 = ((byte[])mInBlock.element)[mIndexPos.element];
            } else {
                if (mInBlock.element == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"mInBlock");
                    throw null;
                }
                n2 = ((byte[])mInBlock.element)[mIndexPos.element];
                if (mOutput.element == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"mOutput");
                    throw null;
                }
                n = ((byte[])mOutput.element)[mPreOutPos.element + mIndexPos.element];
                by = 0;
                by2 = (byte)(n2 ^ n);
            }
            byArray[n3] = by2;
            n2 = mIndexPos.element;
            mIndexPos.element = n2 + 1;
        }
        if (mInBlock.element == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"mInBlock");
            throw null;
        }
        if (mOutput.element == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"mOutput");
            throw null;
        }
        ArraysKt.copyInto((byte[])TEA.doOption$encode(mKey, (byte[])mInBlock.element), (byte[])((byte[])mOutput.element), (int)mOutPos.element, (int)0, (int)8);
        mIndexPos.element = 0;
        while (mIndexPos.element < 8) {
            int outPos = mOutPos.element + mIndexPos.element;
            if (mOutput.element == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"mOutput");
                throw null;
            }
            if (mOutput.element == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"mOutput");
                throw null;
            }
            n = ((byte[])mOutput.element)[outPos];
            if (mIV.element == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"mIV");
                throw null;
            }
            by = ((byte[])mIV.element)[mIndexPos.element];
            boolean bl = false;
            ((byte[])mOutput.element)[outPos] = (byte)(n ^ by);
            n = mIndexPos.element;
            mIndexPos.element = n + 1;
        }
        if (mInBlock.element == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"mInBlock");
            throw null;
        }
        if (mIV.element == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"mIV");
            throw null;
        }
        ArraysKt.copyInto((byte[])((byte[])mInBlock.element), (byte[])((byte[])mIV.element), (int)0, (int)0, (int)8);
        mPreOutPos.element = mOutPos.element;
        mOutPos.element += 8;
        mIndexPos.element = 0;
        isFirstBlock.element = false;
    }

    private static final boolean doOption$decodeOneBlock(Ref.IntRef mIndexPos, Ref.IntRef mOutPos, Ref.ObjectRef<byte[]> mIV, long[] mKey, byte[] ciphertext, int offset, int len) {
        mIndexPos.element = 0;
        while (mIndexPos.element < 8) {
            if (mOutPos.element + mIndexPos.element < len) {
                if (mIV.element == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"mIV");
                    throw null;
                }
                if (mIV.element == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"mIV");
                    throw null;
                }
                int n = ((byte[])mIV.element)[mIndexPos.element];
                byte by = ciphertext[mOutPos.element + offset + mIndexPos.element];
                boolean bl = false;
                ((byte[])mIV.element)[mIndexPos.element] = (byte)(n ^ by);
                n = mIndexPos.element;
                mIndexPos.element = n + 1;
                continue;
            }
            return true;
        }
        if (mIV.element == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"mIV");
            throw null;
        }
        mIV.element = TEA.doOption$decode(mKey, (byte[])mIV.element, 0);
        mOutPos.element += 8;
        mIndexPos.element = 0;
        return true;
    }

    private static final byte[] doOption$encrypt(Ref.ObjectRef<byte[]> mInBlock, Ref.ObjectRef<byte[]> mIV, Ref.IntRef mOutPos, Ref.IntRef mPreOutPos, Ref.BooleanRef isFirstBlock, Ref.IntRef mIndexPos, Ref.ObjectRef<byte[]> mOutput, long[] mKey, byte[] plaintext, int offset, int len) {
        int n;
        int i2;
        int len2 = len;
        int offset2 = offset;
        mInBlock.element = new byte[8];
        mIV.element = new byte[8];
        mOutPos.element = 0;
        mPreOutPos.element = 0;
        isFirstBlock.element = true;
        mIndexPos.element = (len2 + 10) % 8;
        if (mIndexPos.element != 0) {
            mIndexPos.element = 8 - mIndexPos.element;
        }
        mOutput.element = new byte[mIndexPos.element + len2 + 10];
        if (mInBlock.element == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"mInBlock");
            throw null;
        }
        ((byte[])mInBlock.element)[0] = (byte)(TEA.doOption$rand() & 0xF8 | mIndexPos.element);
        int n2 = 1;
        if (n2 <= mIndexPos.element) {
            do {
                i2 = n2++;
                if (mInBlock.element == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"mInBlock");
                    throw null;
                }
                ((byte[])mInBlock.element)[i2] = (byte)(TEA.doOption$rand() & 0xFF);
            } while (i2 != mIndexPos.element);
        }
        ++mIndexPos.element;
        int cfr_ignored_0 = mIndexPos.element;
        n2 = 0;
        do {
            i2 = n2++;
            if (mIV.element == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"mIV");
                throw null;
            }
            ((byte[])mIV.element)[i2] = 0;
        } while (n2 <= 7);
        int g = 0;
        while (g < 2) {
            if (mIndexPos.element < 8) {
                if (mInBlock.element == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"mInBlock");
                    throw null;
                }
                n = mIndexPos.element;
                mIndexPos.element = n + 1;
                ((byte[])mInBlock.element)[n] = (byte)(TEA.doOption$rand() & 0xFF);
                ++g;
            }
            if (mIndexPos.element != 8) continue;
            TEA.doOption$encodeOneBlock(mIndexPos, mInBlock, isFirstBlock, mOutput, mPreOutPos, mOutPos, mIV, mKey);
        }
        while (len2 > 0) {
            if (mIndexPos.element < 8) {
                if (mInBlock.element == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"mInBlock");
                    throw null;
                }
                n = mIndexPos.element;
                mIndexPos.element = n + 1;
                int n3 = n;
                n = offset2;
                offset2 = n + 1;
                ((byte[])mInBlock.element)[n3] = plaintext[n];
            }
            if (mIndexPos.element == 8) {
                TEA.doOption$encodeOneBlock(mIndexPos, mInBlock, isFirstBlock, mOutput, mPreOutPos, mOutPos, mIV, mKey);
            }
            n = len2;
            len2 = n + -1;
        }
        g = 0;
        while (g < 7) {
            if (mIndexPos.element < 8) {
                if (mInBlock.element == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"mInBlock");
                    throw null;
                }
                n = mIndexPos.element;
                mIndexPos.element = n + 1;
                ((byte[])mInBlock.element)[n] = 0;
            }
            if (mIndexPos.element == 8) {
                TEA.doOption$encodeOneBlock(mIndexPos, mInBlock, isFirstBlock, mOutput, mPreOutPos, mOutPos, mIV, mKey);
            }
            n = g;
            g = n + 1;
        }
        if (mOutput.element == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"mOutput");
            throw null;
        }
        return (byte[])mOutput.element;
    }

    private static final byte[] doOption$decrypt(Ref.ObjectRef<byte[]> mIV, Ref.IntRef mIndexPos, Ref.BooleanRef isFirstBlock, Ref.ObjectRef<byte[]> mOutput, Ref.IntRef mPreOutPos, Ref.IntRef mOutPos, long[] mKey, byte[] cipherText, int offset, int len) {
        boolean bl;
        byte by;
        int n;
        byte by2 = len % 8 == 0 && len >= 16 ? (byte)1 : 0;
        int n2 = 0;
        boolean bl2 = false;
        if (by2 == 0) {
            boolean bl3 = false;
            String string = Intrinsics.stringPlus((String)"data must len % 8 == 0 && len >= 16 but given ", (Object)len);
            throw (Throwable)new IllegalArgumentException(string.toString());
        }
        mIV.element = TEA.doOption$decode(mKey, cipherText, offset);
        if (mIV.element == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"mIV");
            throw null;
        }
        by2 = ((byte[])mIV.element)[0];
        n2 = 7;
        bl2 = false;
        mIndexPos.element = (byte)(by2 & n2);
        int plen = len - mIndexPos.element - 10;
        isFirstBlock.element = true;
        if (plen < 0) {
            INSTANCE.fail();
            throw new KotlinNothingValueException();
        }
        mOutput.element = new byte[plen];
        mPreOutPos.element = 0;
        mOutPos.element = 8;
        ++mIndexPos.element;
        int cfr_ignored_0 = mIndexPos.element;
        int g = 0;
        while (g < 2) {
            if (mIndexPos.element < 8) {
                ++mIndexPos.element;
                int cfr_ignored_1 = mIndexPos.element;
                ++g;
            }
            if (mIndexPos.element != 8) continue;
            isFirstBlock.element = false;
            if (TEA.doOption$decodeOneBlock(mIndexPos, mOutPos, mIV, mKey, cipherText, offset, len)) continue;
            INSTANCE.fail();
            throw new KotlinNothingValueException();
        }
        int outpos = 0;
        while (plen != 0) {
            if (mIndexPos.element < 8) {
                byte by3;
                if (mOutput.element == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"mOutput");
                    throw null;
                }
                byte[] byArray = (byte[])mOutput.element;
                n = outpos;
                outpos = n + 1;
                if (isFirstBlock.element) {
                    if (mIV.element == null) {
                        Intrinsics.throwUninitializedPropertyAccessException((String)"mIV");
                        throw null;
                    }
                    by3 = ((byte[])mIV.element)[mIndexPos.element];
                } else {
                    n = cipherText[mPreOutPos.element + offset + mIndexPos.element];
                    if (mIV.element == null) {
                        Intrinsics.throwUninitializedPropertyAccessException((String)"mIV");
                        throw null;
                    }
                    by = ((byte[])mIV.element)[mIndexPos.element];
                    bl = false;
                    by3 = (byte)(n ^ by);
                }
                byArray[n] = by3;
                ++mIndexPos.element;
                int cfr_ignored_2 = mIndexPos.element;
            }
            if (mIndexPos.element == 8) {
                mPreOutPos.element = mOutPos.element - 8;
                isFirstBlock.element = false;
                if (!TEA.doOption$decodeOneBlock(mIndexPos, mOutPos, mIV, mKey, cipherText, offset, len)) {
                    INSTANCE.fail();
                    throw new KotlinNothingValueException();
                }
            }
            n = plen;
            plen = n + -1;
        }
        g = 0;
        while (g < 7) {
            if (mIndexPos.element < 8) {
                n = cipherText[mPreOutPos.element + offset + mIndexPos.element];
                if (mIV.element == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"mIV");
                    throw null;
                }
                by = ((byte[])mIV.element)[mIndexPos.element];
                bl = false;
                if ((byte)(n ^ by) != 0) {
                    INSTANCE.fail();
                    throw new KotlinNothingValueException();
                }
                ++mIndexPos.element;
                int cfr_ignored_3 = mIndexPos.element;
            }
            if (mIndexPos.element == 8) {
                mPreOutPos.element = mOutPos.element;
                if (!TEA.doOption$decodeOneBlock(mIndexPos, mOutPos, mIV, mKey, cipherText, offset, len)) {
                    INSTANCE.fail();
                    throw new KotlinNothingValueException();
                }
            }
            n = g;
            g = n + 1;
        }
        if (mOutput.element == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"mOutput");
            throw null;
        }
        return (byte[])mOutput.element;
    }
}

