/*
 * Decompiled with CFR 0.152.
 */
package net.markenwerk.utils.json.common.handler.xml;

import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import net.markenwerk.utils.json.common.JsonException;
import net.markenwerk.utils.json.common.JsonIndexException;
import net.markenwerk.utils.json.common.JsonValueException;
import net.markenwerk.utils.json.handler.IdleJsonHandler;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public final class XmlDocumentJsonHandler
extends IdleJsonHandler<Document> {
    private final Document document;
    private Node node;

    public XmlDocumentJsonHandler() {
        this(XmlDocumentJsonHandler.createDocumentBuilder());
    }

    private static DocumentBuilder createDocumentBuilder() {
        try {
            return DocumentBuilderFactory.newInstance().newDocumentBuilder();
        }
        catch (ParserConfigurationException e) {
            throw new RuntimeException("The default DocumentBuilder faild to create a XML Document", e);
        }
    }

    public XmlDocumentJsonHandler(DocumentBuilder documentBuilder) throws IllegalArgumentException {
        if (null == documentBuilder) {
            throw new IllegalArgumentException("documentBuilder is null");
        }
        this.document = documentBuilder.newDocument();
        this.node = this.document;
    }

    public void onDocumentBegin() throws JsonException {
    }

    public void onDocumentEnd() throws JsonException {
    }

    public void onArrayBegin() throws JsonException {
        Element element = this.document.createElement("array");
        this.node.appendChild(element);
        this.node = element;
    }

    public void onArrayEnd() throws JsonException {
        this.node = this.node.getParentNode();
        if (this.node.getNodeName().equals("entry")) {
            this.node = this.node.getParentNode();
        }
    }

    public void onObjectBegin() throws JsonException {
        Element element = this.document.createElement("object");
        this.node.appendChild(element);
        this.node = element;
    }

    public void onObjectEnd() throws JsonException {
        this.node = this.node.getParentNode();
        if (this.node.getNodeName().equals("entry")) {
            this.node = this.node.getParentNode();
        }
    }

    public void onName(String name) throws JsonIndexException, JsonException {
        XmlDocumentJsonHandler.checkName((String)name);
        Element element = this.document.createElement("entry");
        element.setAttribute("name", name);
        this.node.appendChild(element);
        this.node = element;
    }

    public void onNext() throws JsonException {
    }

    public void onNull() throws JsonException {
        Element element = this.document.createElement("null");
        this.appendChild(element);
    }

    public void onBoolean(boolean value) throws JsonException {
        Element element = this.document.createElement("boolean");
        element.setAttribute("value", value ? "true" : "false");
        this.appendChild(element);
    }

    public void onLong(long value) throws JsonException {
        Element element = this.document.createElement("number");
        element.setAttribute("value", Long.toString(value));
        this.appendChild(element);
    }

    public void onDouble(double value) throws JsonValueException, JsonException {
        XmlDocumentJsonHandler.checkDouble((double)value);
        Element element = this.document.createElement("number");
        element.setAttribute("value", Double.toString(value));
        this.appendChild(element);
    }

    public void onString(String value) throws JsonValueException, JsonException {
        XmlDocumentJsonHandler.checkString((String)value);
        Element element = this.document.createElement("string");
        element.setAttribute("value", value);
        this.appendChild(element);
    }

    private void appendChild(Element element) {
        this.node.appendChild(element);
        if (this.node.getNodeName().equals("entry")) {
            this.node = this.node.getParentNode();
        }
    }

    public Document getResult() throws JsonException {
        return this.document;
    }
}

