/*
 * Decompiled with CFR 0.152.
 */
package net.markenwerk.utils.json.handler;

import net.markenwerk.utils.json.common.JsonException;
import net.markenwerk.utils.json.common.JsonIndexException;
import net.markenwerk.utils.json.common.JsonValueException;
import net.markenwerk.utils.json.handler.JsonHandler;

public abstract class IdleJsonHandler<Result>
implements JsonHandler<Result> {
    @Override
    public void onDocumentBegin() throws JsonException {
    }

    @Override
    public void onDocumentEnd() throws JsonException {
    }

    @Override
    public void onArrayBegin() throws JsonException {
    }

    @Override
    public void onArrayEnd() throws JsonException {
    }

    @Override
    public void onObjectBegin() throws JsonException {
    }

    @Override
    public void onObjectEnd() throws JsonException {
    }

    @Override
    public void onName(String name) throws JsonException {
        IdleJsonHandler.checkName(name);
    }

    public static final boolean checkName(String name) throws JsonIndexException {
        if (null == name) {
            throw new JsonIndexException("The given name is null");
        }
        return true;
    }

    @Override
    public void onNext() throws JsonException {
    }

    @Override
    public void onNull() throws JsonException {
    }

    @Override
    public void onBoolean(boolean value) throws JsonException {
    }

    @Override
    public void onLong(long value) throws JsonException {
    }

    @Override
    public void onDouble(double value) throws JsonValueException, JsonException {
        IdleJsonHandler.checkDouble(value);
    }

    public static final boolean checkDouble(double value) throws JsonValueException {
        if (Double.isNaN(value)) {
            throw new JsonValueException("The given value is not a number");
        }
        if (Double.isInfinite(value)) {
            throw new JsonValueException("The given value is infinite");
        }
        return true;
    }

    @Override
    public void onString(String value) throws JsonValueException, JsonException {
        IdleJsonHandler.checkString(value);
    }

    public static final boolean checkString(String value) throws JsonValueException {
        if (null == value) {
            throw new JsonValueException("The given value is null");
        }
        return true;
    }

    @Override
    public Result getResult() throws JsonException {
        return null;
    }
}

