package net.mintern.functions.binary;

/**
 * An operation of type {@code (boolean, boolean) -> short}.
 *
 */
@FunctionalInterface
public interface BoolBoolToShort extends
        net.mintern.functions.binary.checked.BoolBoolToShortE<RuntimeException> {

    /**
     * Returns a wrapped version of {@code f} that uses {@code toRuntime} to convert any checked
     * {@code Exception} to a {@code RuntimeException}.
     *
     * @param <E> the {@code Exception} type that the operation may throw
     * @param toRuntime if a checked exception is thrown from
     *      {@link net.mintern.functions.binary.checked.BoolBoolToShortE#call}, then this function
     *      is called in in order to convert it to a {@code RuntimeException}
     * @param f the operation to wrap
     * @return a wrapped version of {@code f} that does not throw checked exceptions
     */
    @SuppressWarnings("unchecked")
    static <E extends Exception> BoolBoolToShort unchecked(
            java.util.function.Function<? super E, RuntimeException> toRuntime,
            net.mintern.functions.binary.checked.BoolBoolToShortE<E> f) {
        return (bool1, bool2) -> {
            try {
                return f.call(bool1, bool2);
            } catch (RuntimeException e) {
                throw e;
            } catch (Exception e) {
                throw toRuntime.apply((E) e);
            }
        };
    }

    /**
     * Returns a wrapped version of {@code f} that wraps any checked {@code Exception} with a
     * {@code RuntimeException}.
     *
     * @param <E> the {@code Exception} type that the operation may throw
     * @param f the operation to wrap
     * @return a wrapped version of {@code f} that does not throw checked exceptions
     */
    static <E extends Exception> BoolBoolToShort unchecked(
            net.mintern.functions.binary.checked.BoolBoolToShortE<E> f) {
        return unchecked(RuntimeException::new, f);
    }

    /**
     * Returns a wrapped version of {@code f} that wraps any {@code IOException} with an
     * {@link java.io.UncheckedIOException}.
     *
     * @param <E> the {@code Exception} type that the operation may throw
     * @param f the operation to wrap
     * @return a wrapped version of {@code f} that throws {@code UncheckedIOException} instead of
     *      {@code IOException}
     */
    static <E extends java.io.IOException> BoolBoolToShort uncheckedIO(
            net.mintern.functions.binary.checked.BoolBoolToShortE<E> f) {
        return unchecked(java.io.UncheckedIOException::new, f);
    }

    /**
     * Binds {@code (bool1)} to the beginning of {@code f}, returning a new function
     * of type {@code (boolean) -> short}.
     *
     * @param f the unbound function
     * @param bool1 argument 1
     * @return a new function {@code (boolean bool2) -> short} that calls
     *      {@code f.call(bool1, bool2)} and returns the result.
     */
    static  net.mintern.functions.unary.BoolToShort
    bind(BoolBoolToShort f, boolean bool1) {
        return (bool2) -> f.call(bool1, bool2);
    }

    /**
     * Binds {@code (bool1)} to the beginning of {@code this}, returning a new function
     * of type {@code (boolean) -> short}.
     *
     * @param bool1 argument 1
     * @return a new function {@code (boolean bool2) -> short} that calls
     *      {@code this.call(bool1, bool2)} and returns the result.
     */
    @Override
    default net.mintern.functions.unary.BoolToShort bind(boolean bool1) {
        return BoolBoolToShort.bind(this, bool1);
    }

    /**
     * Binds {@code (bool2)} to the end of {@code f}, returning a new function
     * of type {@code (boolean) -> short}.
     *
     * @param f the unbound function
     * @param bool2 argument 2
     * @return a new function {@code (boolean bool1) -> short} that calls
     *      {@code f.call(bool1, bool2)} and returns the result.
     */
    static  net.mintern.functions.unary.BoolToShort
    rbind(BoolBoolToShort f, boolean bool2) {
        return (bool1) -> f.call(bool1, bool2);
    }

    /**
     * Binds {@code (bool2)} to the end of {@code this}, returning a new function
     * of type {@code (boolean) -> short}.
     *
     * @param bool2 argument 2
     * @return a new function {@code (boolean bool1) -> short} that calls
     *      {@code this.call(bool1, bool2)} and returns the result.
     */
    @Override
    default net.mintern.functions.unary.BoolToShort rbind(boolean bool2) {
        return BoolBoolToShort.rbind(this, bool2);
    }

    /**
     * Binds {@code (bool1, bool2)} to {@code f}, returning a new function
     * of type {@code () -> short}.
     *
     * @param f the unbound function
     * @param bool1 argument 1
     * @param bool2 argument 2
     * @return a new function {@code () -> short} that calls
     *      {@code f.call(bool1, bool2)} and returns the result.
     */
    static  net.mintern.functions.nullary.NilToShort
    bind(BoolBoolToShort f, boolean bool1, boolean bool2) {
        return () -> f.call(bool1, bool2);
    }

    /**
     * Binds {@code (bool1, bool2)} to {@code this}, returning a new function
     * of type {@code () -> short}.
     *
     * @param bool1 argument 1
     * @param bool2 argument 2
     * @return a new function {@code () -> short} that calls
     *      {@code this.call(bool1, bool2)} and returns the result.
     */
    @Override
    default net.mintern.functions.nullary.NilToShort bind(boolean bool1, boolean bool2) {
        return BoolBoolToShort.bind(this, bool1, bool2);
    }
}
