package net.mintern.functions.binary;

/**
 * An operation of type {@code (boolean, double) -> short}.
 *
 */
@FunctionalInterface
public interface BoolDblToShort extends
        net.mintern.functions.binary.checked.BoolDblToShortE<RuntimeException> {

    /**
     * Returns a wrapped version of {@code f} that uses {@code toRuntime} to convert any checked
     * {@code Exception} to a {@code RuntimeException}.
     *
     * @param <E> the {@code Exception} type that the operation may throw
     * @param toRuntime if a checked exception is thrown from
     *      {@link net.mintern.functions.binary.checked.BoolDblToShortE#call}, then this function
     *      is called in in order to convert it to a {@code RuntimeException}
     * @param f the operation to wrap
     * @return a wrapped version of {@code f} that does not throw checked exceptions
     */
    @SuppressWarnings("unchecked")
    static <E extends Exception> BoolDblToShort unchecked(
            java.util.function.Function<? super E, RuntimeException> toRuntime,
            net.mintern.functions.binary.checked.BoolDblToShortE<E> f) {
        return (bool, d) -> {
            try {
                return f.call(bool, d);
            } catch (RuntimeException e) {
                throw e;
            } catch (Exception e) {
                throw toRuntime.apply((E) e);
            }
        };
    }

    /**
     * Returns a wrapped version of {@code f} that wraps any checked {@code Exception} with a
     * {@code RuntimeException}.
     *
     * @param <E> the {@code Exception} type that the operation may throw
     * @param f the operation to wrap
     * @return a wrapped version of {@code f} that does not throw checked exceptions
     */
    static <E extends Exception> BoolDblToShort unchecked(
            net.mintern.functions.binary.checked.BoolDblToShortE<E> f) {
        return unchecked(RuntimeException::new, f);
    }

    /**
     * Returns a wrapped version of {@code f} that wraps any {@code IOException} with an
     * {@link java.io.UncheckedIOException}.
     *
     * @param <E> the {@code Exception} type that the operation may throw
     * @param f the operation to wrap
     * @return a wrapped version of {@code f} that throws {@code UncheckedIOException} instead of
     *      {@code IOException}
     */
    static <E extends java.io.IOException> BoolDblToShort uncheckedIO(
            net.mintern.functions.binary.checked.BoolDblToShortE<E> f) {
        return unchecked(java.io.UncheckedIOException::new, f);
    }

    /**
     * Binds {@code (bool)} to the beginning of {@code f}, returning a new function
     * of type {@code (double) -> short}.
     *
     * @param f the unbound function
     * @param bool argument 1
     * @return a new function {@code (double d) -> short} that calls
     *      {@code f.call(bool, d)} and returns the result.
     */
    static  net.mintern.functions.unary.DblToShort
    bind(BoolDblToShort f, boolean bool) {
        return (d) -> f.call(bool, d);
    }

    /**
     * Binds {@code (bool)} to the beginning of {@code this}, returning a new function
     * of type {@code (double) -> short}.
     *
     * @param bool argument 1
     * @return a new function {@code (double d) -> short} that calls
     *      {@code this.call(bool, d)} and returns the result.
     */
    @Override
    default net.mintern.functions.unary.DblToShort bind(boolean bool) {
        return BoolDblToShort.bind(this, bool);
    }

    /**
     * Binds {@code (d)} to the end of {@code f}, returning a new function
     * of type {@code (boolean) -> short}.
     *
     * @param f the unbound function
     * @param d argument 2
     * @return a new function {@code (boolean bool) -> short} that calls
     *      {@code f.call(bool, d)} and returns the result.
     */
    static  net.mintern.functions.unary.BoolToShort
    rbind(BoolDblToShort f, double d) {
        return (bool) -> f.call(bool, d);
    }

    /**
     * Binds {@code (d)} to the end of {@code this}, returning a new function
     * of type {@code (boolean) -> short}.
     *
     * @param d argument 2
     * @return a new function {@code (boolean bool) -> short} that calls
     *      {@code this.call(bool, d)} and returns the result.
     */
    @Override
    default net.mintern.functions.unary.BoolToShort rbind(double d) {
        return BoolDblToShort.rbind(this, d);
    }

    /**
     * Binds {@code (bool, d)} to {@code f}, returning a new function
     * of type {@code () -> short}.
     *
     * @param f the unbound function
     * @param bool argument 1
     * @param d argument 2
     * @return a new function {@code () -> short} that calls
     *      {@code f.call(bool, d)} and returns the result.
     */
    static  net.mintern.functions.nullary.NilToShort
    bind(BoolDblToShort f, boolean bool, double d) {
        return () -> f.call(bool, d);
    }

    /**
     * Binds {@code (bool, d)} to {@code this}, returning a new function
     * of type {@code () -> short}.
     *
     * @param bool argument 1
     * @param d argument 2
     * @return a new function {@code () -> short} that calls
     *      {@code this.call(bool, d)} and returns the result.
     */
    @Override
    default net.mintern.functions.nullary.NilToShort bind(boolean bool, double d) {
        return BoolDblToShort.bind(this, bool, d);
    }
}
