package net.mintern.functions.binary;

/**
 * An operation of type {@code (boolean, U) -> short}.
 *
 * @param <U> the type of the argument
 */
@FunctionalInterface
public interface BoolObjToShort<U> extends
        net.mintern.functions.binary.checked.BoolObjToShortE<U, RuntimeException> {

    /**
     * Returns a wrapped version of {@code f} that uses {@code toRuntime} to convert any checked
     * {@code Exception} to a {@code RuntimeException}.
     *
     * @param <U> the type of argument 2
     * @param <E> the {@code Exception} type that the operation may throw
     * @param toRuntime if a checked exception is thrown from
     *      {@link net.mintern.functions.binary.checked.BoolObjToShortE#call}, then this function
     *      is called in in order to convert it to a {@code RuntimeException}
     * @param f the operation to wrap
     * @return a wrapped version of {@code f} that does not throw checked exceptions
     */
    @SuppressWarnings("unchecked")
    static <U, E extends Exception> BoolObjToShort<U> unchecked(
            java.util.function.Function<? super E, RuntimeException> toRuntime,
            net.mintern.functions.binary.checked.BoolObjToShortE<U, E> f) {
        return (bool, u) -> {
            try {
                return f.call(bool, u);
            } catch (RuntimeException e) {
                throw e;
            } catch (Exception e) {
                throw toRuntime.apply((E) e);
            }
        };
    }

    /**
     * Returns a wrapped version of {@code f} that wraps any checked {@code Exception} with a
     * {@code RuntimeException}.
     *
     * @param <U> the type of argument 2
     * @param <E> the {@code Exception} type that the operation may throw
     * @param f the operation to wrap
     * @return a wrapped version of {@code f} that does not throw checked exceptions
     */
    static <U, E extends Exception> BoolObjToShort<U> unchecked(
            net.mintern.functions.binary.checked.BoolObjToShortE<U, E> f) {
        return unchecked(RuntimeException::new, f);
    }

    /**
     * Returns a wrapped version of {@code f} that wraps any {@code IOException} with an
     * {@link java.io.UncheckedIOException}.
     *
     * @param <U> the type of argument 2
     * @param <E> the {@code Exception} type that the operation may throw
     * @param f the operation to wrap
     * @return a wrapped version of {@code f} that throws {@code UncheckedIOException} instead of
     *      {@code IOException}
     */
    static <U, E extends java.io.IOException> BoolObjToShort<U> uncheckedIO(
            net.mintern.functions.binary.checked.BoolObjToShortE<U, E> f) {
        return unchecked(java.io.UncheckedIOException::new, f);
    }

    /**
     * Binds {@code (bool)} to the beginning of {@code f}, returning a new function
     * of type {@code (U) -> short}.
     *
     * @param <U> the type of the argument
     * @param f the unbound function
     * @param bool argument 1
     * @return a new function {@code (U u) -> short} that calls
     *      {@code f.call(bool, u)} and returns the result.
     */
    static <U> net.mintern.functions.unary.ObjToShort<U>
    bind(BoolObjToShort<U> f, boolean bool) {
        return (u) -> f.call(bool, u);
    }

    /**
     * Binds {@code (bool)} to the beginning of {@code this}, returning a new function
     * of type {@code (U) -> short}.
     *
     * @param bool argument 1
     * @return a new function {@code (U u) -> short} that calls
     *      {@code this.call(bool, u)} and returns the result.
     */
    @Override
    default net.mintern.functions.unary.ObjToShort<U> bind(boolean bool) {
        return BoolObjToShort.bind(this, bool);
    }

    /**
     * Binds {@code (u)} to the end of {@code f}, returning a new function
     * of type {@code (boolean) -> short}.
     *
     * @param <U> the type of the argument
     * @param f the unbound function
     * @param u argument 2
     * @return a new function {@code (boolean bool) -> short} that calls
     *      {@code f.call(bool, u)} and returns the result.
     */
    static <U> net.mintern.functions.unary.BoolToShort
    rbind(BoolObjToShort<U> f, U u) {
        return (bool) -> f.call(bool, u);
    }

    /**
     * Binds {@code (u)} to the end of {@code this}, returning a new function
     * of type {@code (boolean) -> short}.
     *
     * @param u argument 2
     * @return a new function {@code (boolean bool) -> short} that calls
     *      {@code this.call(bool, u)} and returns the result.
     */
    @Override
    default net.mintern.functions.unary.BoolToShort rbind(U u) {
        return BoolObjToShort.rbind(this, u);
    }

    /**
     * Binds {@code (bool, u)} to {@code f}, returning a new function
     * of type {@code () -> short}.
     *
     * @param <U> the type of the argument
     * @param f the unbound function
     * @param bool argument 1
     * @param u argument 2
     * @return a new function {@code () -> short} that calls
     *      {@code f.call(bool, u)} and returns the result.
     */
    static <U> net.mintern.functions.nullary.NilToShort
    bind(BoolObjToShort<U> f, boolean bool, U u) {
        return () -> f.call(bool, u);
    }

    /**
     * Binds {@code (bool, u)} to {@code this}, returning a new function
     * of type {@code () -> short}.
     *
     * @param bool argument 1
     * @param u argument 2
     * @return a new function {@code () -> short} that calls
     *      {@code this.call(bool, u)} and returns the result.
     */
    @Override
    default net.mintern.functions.nullary.NilToShort bind(boolean bool, U u) {
        return BoolObjToShort.bind(this, bool, u);
    }
}
