package net.mintern.functions.binary;

/**
 * An operation of type {@code (boolean, short) -> float}.
 *
 */
@FunctionalInterface
public interface BoolShortToFloat extends
        net.mintern.functions.binary.checked.BoolShortToFloatE<RuntimeException> {

    /**
     * Returns a wrapped version of {@code f} that uses {@code toRuntime} to convert any checked
     * {@code Exception} to a {@code RuntimeException}.
     *
     * @param <E> the {@code Exception} type that the operation may throw
     * @param toRuntime if a checked exception is thrown from
     *      {@link net.mintern.functions.binary.checked.BoolShortToFloatE#call}, then this function
     *      is called in in order to convert it to a {@code RuntimeException}
     * @param f the operation to wrap
     * @return a wrapped version of {@code f} that does not throw checked exceptions
     */
    @SuppressWarnings("unchecked")
    static <E extends Exception> BoolShortToFloat unchecked(
            java.util.function.Function<? super E, RuntimeException> toRuntime,
            net.mintern.functions.binary.checked.BoolShortToFloatE<E> f) {
        return (bool, sh) -> {
            try {
                return f.call(bool, sh);
            } catch (RuntimeException e) {
                throw e;
            } catch (Exception e) {
                throw toRuntime.apply((E) e);
            }
        };
    }

    /**
     * Returns a wrapped version of {@code f} that wraps any checked {@code Exception} with a
     * {@code RuntimeException}.
     *
     * @param <E> the {@code Exception} type that the operation may throw
     * @param f the operation to wrap
     * @return a wrapped version of {@code f} that does not throw checked exceptions
     */
    static <E extends Exception> BoolShortToFloat unchecked(
            net.mintern.functions.binary.checked.BoolShortToFloatE<E> f) {
        return unchecked(RuntimeException::new, f);
    }

    /**
     * Returns a wrapped version of {@code f} that wraps any {@code IOException} with an
     * {@link java.io.UncheckedIOException}.
     *
     * @param <E> the {@code Exception} type that the operation may throw
     * @param f the operation to wrap
     * @return a wrapped version of {@code f} that throws {@code UncheckedIOException} instead of
     *      {@code IOException}
     */
    static <E extends java.io.IOException> BoolShortToFloat uncheckedIO(
            net.mintern.functions.binary.checked.BoolShortToFloatE<E> f) {
        return unchecked(java.io.UncheckedIOException::new, f);
    }

    /**
     * Binds {@code (bool)} to the beginning of {@code f}, returning a new function
     * of type {@code (short) -> float}.
     *
     * @param f the unbound function
     * @param bool argument 1
     * @return a new function {@code (short sh) -> float} that calls
     *      {@code f.call(bool, sh)} and returns the result.
     */
    static  net.mintern.functions.unary.ShortToFloat
    bind(BoolShortToFloat f, boolean bool) {
        return (sh) -> f.call(bool, sh);
    }

    /**
     * Binds {@code (bool)} to the beginning of {@code this}, returning a new function
     * of type {@code (short) -> float}.
     *
     * @param bool argument 1
     * @return a new function {@code (short sh) -> float} that calls
     *      {@code this.call(bool, sh)} and returns the result.
     */
    @Override
    default net.mintern.functions.unary.ShortToFloat bind(boolean bool) {
        return BoolShortToFloat.bind(this, bool);
    }

    /**
     * Binds {@code (sh)} to the end of {@code f}, returning a new function
     * of type {@code (boolean) -> float}.
     *
     * @param f the unbound function
     * @param sh argument 2
     * @return a new function {@code (boolean bool) -> float} that calls
     *      {@code f.call(bool, sh)} and returns the result.
     */
    static  net.mintern.functions.unary.BoolToFloat
    rbind(BoolShortToFloat f, short sh) {
        return (bool) -> f.call(bool, sh);
    }

    /**
     * Binds {@code (sh)} to the end of {@code this}, returning a new function
     * of type {@code (boolean) -> float}.
     *
     * @param sh argument 2
     * @return a new function {@code (boolean bool) -> float} that calls
     *      {@code this.call(bool, sh)} and returns the result.
     */
    @Override
    default net.mintern.functions.unary.BoolToFloat rbind(short sh) {
        return BoolShortToFloat.rbind(this, sh);
    }

    /**
     * Binds {@code (bool, sh)} to {@code f}, returning a new function
     * of type {@code () -> float}.
     *
     * @param f the unbound function
     * @param bool argument 1
     * @param sh argument 2
     * @return a new function {@code () -> float} that calls
     *      {@code f.call(bool, sh)} and returns the result.
     */
    static  net.mintern.functions.nullary.NilToFloat
    bind(BoolShortToFloat f, boolean bool, short sh) {
        return () -> f.call(bool, sh);
    }

    /**
     * Binds {@code (bool, sh)} to {@code this}, returning a new function
     * of type {@code () -> float}.
     *
     * @param bool argument 1
     * @param sh argument 2
     * @return a new function {@code () -> float} that calls
     *      {@code this.call(bool, sh)} and returns the result.
     */
    @Override
    default net.mintern.functions.nullary.NilToFloat bind(boolean bool, short sh) {
        return BoolShortToFloat.bind(this, bool, sh);
    }
}
