package net.mintern.functions.binary;

/**
 * An operation of type {@code (boolean, short) -> int}.
 *
 */
@FunctionalInterface
public interface BoolShortToInt extends
        net.mintern.functions.binary.checked.BoolShortToIntE<RuntimeException> {

    /**
     * Returns a wrapped version of {@code f} that uses {@code toRuntime} to convert any checked
     * {@code Exception} to a {@code RuntimeException}.
     *
     * @param <E> the {@code Exception} type that the operation may throw
     * @param toRuntime if a checked exception is thrown from
     *      {@link net.mintern.functions.binary.checked.BoolShortToIntE#call}, then this function
     *      is called in in order to convert it to a {@code RuntimeException}
     * @param f the operation to wrap
     * @return a wrapped version of {@code f} that does not throw checked exceptions
     */
    @SuppressWarnings("unchecked")
    static <E extends Exception> BoolShortToInt unchecked(
            java.util.function.Function<? super E, RuntimeException> toRuntime,
            net.mintern.functions.binary.checked.BoolShortToIntE<E> f) {
        return (bool, sh) -> {
            try {
                return f.call(bool, sh);
            } catch (RuntimeException e) {
                throw e;
            } catch (Exception e) {
                throw toRuntime.apply((E) e);
            }
        };
    }

    /**
     * Returns a wrapped version of {@code f} that wraps any checked {@code Exception} with a
     * {@code RuntimeException}.
     *
     * @param <E> the {@code Exception} type that the operation may throw
     * @param f the operation to wrap
     * @return a wrapped version of {@code f} that does not throw checked exceptions
     */
    static <E extends Exception> BoolShortToInt unchecked(
            net.mintern.functions.binary.checked.BoolShortToIntE<E> f) {
        return unchecked(RuntimeException::new, f);
    }

    /**
     * Returns a wrapped version of {@code f} that wraps any {@code IOException} with an
     * {@link java.io.UncheckedIOException}.
     *
     * @param <E> the {@code Exception} type that the operation may throw
     * @param f the operation to wrap
     * @return a wrapped version of {@code f} that throws {@code UncheckedIOException} instead of
     *      {@code IOException}
     */
    static <E extends java.io.IOException> BoolShortToInt uncheckedIO(
            net.mintern.functions.binary.checked.BoolShortToIntE<E> f) {
        return unchecked(java.io.UncheckedIOException::new, f);
    }

    /**
     * Binds {@code (bool)} to the beginning of {@code f}, returning a new function
     * of type {@code (short) -> int}.
     *
     * @param f the unbound function
     * @param bool argument 1
     * @return a new function {@code (short sh) -> int} that calls
     *      {@code f.call(bool, sh)} and returns the result.
     */
    static  net.mintern.functions.unary.ShortToInt
    bind(BoolShortToInt f, boolean bool) {
        return (sh) -> f.call(bool, sh);
    }

    /**
     * Binds {@code (bool)} to the beginning of {@code this}, returning a new function
     * of type {@code (short) -> int}.
     *
     * @param bool argument 1
     * @return a new function {@code (short sh) -> int} that calls
     *      {@code this.call(bool, sh)} and returns the result.
     */
    @Override
    default net.mintern.functions.unary.ShortToInt bind(boolean bool) {
        return BoolShortToInt.bind(this, bool);
    }

    /**
     * Binds {@code (sh)} to the end of {@code f}, returning a new function
     * of type {@code (boolean) -> int}.
     *
     * @param f the unbound function
     * @param sh argument 2
     * @return a new function {@code (boolean bool) -> int} that calls
     *      {@code f.call(bool, sh)} and returns the result.
     */
    static  net.mintern.functions.unary.BoolToInt
    rbind(BoolShortToInt f, short sh) {
        return (bool) -> f.call(bool, sh);
    }

    /**
     * Binds {@code (sh)} to the end of {@code this}, returning a new function
     * of type {@code (boolean) -> int}.
     *
     * @param sh argument 2
     * @return a new function {@code (boolean bool) -> int} that calls
     *      {@code this.call(bool, sh)} and returns the result.
     */
    @Override
    default net.mintern.functions.unary.BoolToInt rbind(short sh) {
        return BoolShortToInt.rbind(this, sh);
    }

    /**
     * Binds {@code (bool, sh)} to {@code f}, returning a new function
     * of type {@code () -> int}.
     *
     * @param f the unbound function
     * @param bool argument 1
     * @param sh argument 2
     * @return a new function {@code () -> int} that calls
     *      {@code f.call(bool, sh)} and returns the result.
     */
    static  net.mintern.functions.nullary.NilToInt
    bind(BoolShortToInt f, boolean bool, short sh) {
        return () -> f.call(bool, sh);
    }

    /**
     * Binds {@code (bool, sh)} to {@code this}, returning a new function
     * of type {@code () -> int}.
     *
     * @param bool argument 1
     * @param sh argument 2
     * @return a new function {@code () -> int} that calls
     *      {@code this.call(bool, sh)} and returns the result.
     */
    @Override
    default net.mintern.functions.nullary.NilToInt bind(boolean bool, short sh) {
        return BoolShortToInt.bind(this, bool, sh);
    }
}
