package net.mintern.functions.binary;

/**
 * An operation of type {@code (byte, boolean) -> short}.
 *
 */
@FunctionalInterface
public interface ByteBoolToShort extends
        net.mintern.functions.binary.checked.ByteBoolToShortE<RuntimeException> {

    /**
     * Returns a wrapped version of {@code f} that uses {@code toRuntime} to convert any checked
     * {@code Exception} to a {@code RuntimeException}.
     *
     * @param <E> the {@code Exception} type that the operation may throw
     * @param toRuntime if a checked exception is thrown from
     *      {@link net.mintern.functions.binary.checked.ByteBoolToShortE#call}, then this function
     *      is called in in order to convert it to a {@code RuntimeException}
     * @param f the operation to wrap
     * @return a wrapped version of {@code f} that does not throw checked exceptions
     */
    @SuppressWarnings("unchecked")
    static <E extends Exception> ByteBoolToShort unchecked(
            java.util.function.Function<? super E, RuntimeException> toRuntime,
            net.mintern.functions.binary.checked.ByteBoolToShortE<E> f) {
        return (b, bool) -> {
            try {
                return f.call(b, bool);
            } catch (RuntimeException e) {
                throw e;
            } catch (Exception e) {
                throw toRuntime.apply((E) e);
            }
        };
    }

    /**
     * Returns a wrapped version of {@code f} that wraps any checked {@code Exception} with a
     * {@code RuntimeException}.
     *
     * @param <E> the {@code Exception} type that the operation may throw
     * @param f the operation to wrap
     * @return a wrapped version of {@code f} that does not throw checked exceptions
     */
    static <E extends Exception> ByteBoolToShort unchecked(
            net.mintern.functions.binary.checked.ByteBoolToShortE<E> f) {
        return unchecked(RuntimeException::new, f);
    }

    /**
     * Returns a wrapped version of {@code f} that wraps any {@code IOException} with an
     * {@link java.io.UncheckedIOException}.
     *
     * @param <E> the {@code Exception} type that the operation may throw
     * @param f the operation to wrap
     * @return a wrapped version of {@code f} that throws {@code UncheckedIOException} instead of
     *      {@code IOException}
     */
    static <E extends java.io.IOException> ByteBoolToShort uncheckedIO(
            net.mintern.functions.binary.checked.ByteBoolToShortE<E> f) {
        return unchecked(java.io.UncheckedIOException::new, f);
    }

    /**
     * Binds {@code (b)} to the beginning of {@code f}, returning a new function
     * of type {@code (boolean) -> short}.
     *
     * @param f the unbound function
     * @param b argument 1
     * @return a new function {@code (boolean bool) -> short} that calls
     *      {@code f.call(b, bool)} and returns the result.
     */
    static  net.mintern.functions.unary.BoolToShort
    bind(ByteBoolToShort f, byte b) {
        return (bool) -> f.call(b, bool);
    }

    /**
     * Binds {@code (b)} to the beginning of {@code this}, returning a new function
     * of type {@code (boolean) -> short}.
     *
     * @param b argument 1
     * @return a new function {@code (boolean bool) -> short} that calls
     *      {@code this.call(b, bool)} and returns the result.
     */
    @Override
    default net.mintern.functions.unary.BoolToShort bind(byte b) {
        return ByteBoolToShort.bind(this, b);
    }

    /**
     * Binds {@code (bool)} to the end of {@code f}, returning a new function
     * of type {@code (byte) -> short}.
     *
     * @param f the unbound function
     * @param bool argument 2
     * @return a new function {@code (byte b) -> short} that calls
     *      {@code f.call(b, bool)} and returns the result.
     */
    static  net.mintern.functions.unary.ByteToShort
    rbind(ByteBoolToShort f, boolean bool) {
        return (b) -> f.call(b, bool);
    }

    /**
     * Binds {@code (bool)} to the end of {@code this}, returning a new function
     * of type {@code (byte) -> short}.
     *
     * @param bool argument 2
     * @return a new function {@code (byte b) -> short} that calls
     *      {@code this.call(b, bool)} and returns the result.
     */
    @Override
    default net.mintern.functions.unary.ByteToShort rbind(boolean bool) {
        return ByteBoolToShort.rbind(this, bool);
    }

    /**
     * Binds {@code (b, bool)} to {@code f}, returning a new function
     * of type {@code () -> short}.
     *
     * @param f the unbound function
     * @param b argument 1
     * @param bool argument 2
     * @return a new function {@code () -> short} that calls
     *      {@code f.call(b, bool)} and returns the result.
     */
    static  net.mintern.functions.nullary.NilToShort
    bind(ByteBoolToShort f, byte b, boolean bool) {
        return () -> f.call(b, bool);
    }

    /**
     * Binds {@code (b, bool)} to {@code this}, returning a new function
     * of type {@code () -> short}.
     *
     * @param b argument 1
     * @param bool argument 2
     * @return a new function {@code () -> short} that calls
     *      {@code this.call(b, bool)} and returns the result.
     */
    @Override
    default net.mintern.functions.nullary.NilToShort bind(byte b, boolean bool) {
        return ByteBoolToShort.bind(this, b, bool);
    }
}
