package net.mintern.functions.binary;

/**
 * An operation of type {@code (byte, char) -> short}.
 *
 */
@FunctionalInterface
public interface ByteCharToShort extends
        net.mintern.functions.binary.checked.ByteCharToShortE<RuntimeException> {

    /**
     * Returns a wrapped version of {@code f} that uses {@code toRuntime} to convert any checked
     * {@code Exception} to a {@code RuntimeException}.
     *
     * @param <E> the {@code Exception} type that the operation may throw
     * @param toRuntime if a checked exception is thrown from
     *      {@link net.mintern.functions.binary.checked.ByteCharToShortE#call}, then this function
     *      is called in in order to convert it to a {@code RuntimeException}
     * @param f the operation to wrap
     * @return a wrapped version of {@code f} that does not throw checked exceptions
     */
    @SuppressWarnings("unchecked")
    static <E extends Exception> ByteCharToShort unchecked(
            java.util.function.Function<? super E, RuntimeException> toRuntime,
            net.mintern.functions.binary.checked.ByteCharToShortE<E> f) {
        return (b, ch) -> {
            try {
                return f.call(b, ch);
            } catch (RuntimeException e) {
                throw e;
            } catch (Exception e) {
                throw toRuntime.apply((E) e);
            }
        };
    }

    /**
     * Returns a wrapped version of {@code f} that wraps any checked {@code Exception} with a
     * {@code RuntimeException}.
     *
     * @param <E> the {@code Exception} type that the operation may throw
     * @param f the operation to wrap
     * @return a wrapped version of {@code f} that does not throw checked exceptions
     */
    static <E extends Exception> ByteCharToShort unchecked(
            net.mintern.functions.binary.checked.ByteCharToShortE<E> f) {
        return unchecked(RuntimeException::new, f);
    }

    /**
     * Returns a wrapped version of {@code f} that wraps any {@code IOException} with an
     * {@link java.io.UncheckedIOException}.
     *
     * @param <E> the {@code Exception} type that the operation may throw
     * @param f the operation to wrap
     * @return a wrapped version of {@code f} that throws {@code UncheckedIOException} instead of
     *      {@code IOException}
     */
    static <E extends java.io.IOException> ByteCharToShort uncheckedIO(
            net.mintern.functions.binary.checked.ByteCharToShortE<E> f) {
        return unchecked(java.io.UncheckedIOException::new, f);
    }

    /**
     * Binds {@code (b)} to the beginning of {@code f}, returning a new function
     * of type {@code (char) -> short}.
     *
     * @param f the unbound function
     * @param b argument 1
     * @return a new function {@code (char ch) -> short} that calls
     *      {@code f.call(b, ch)} and returns the result.
     */
    static  net.mintern.functions.unary.CharToShort
    bind(ByteCharToShort f, byte b) {
        return (ch) -> f.call(b, ch);
    }

    /**
     * Binds {@code (b)} to the beginning of {@code this}, returning a new function
     * of type {@code (char) -> short}.
     *
     * @param b argument 1
     * @return a new function {@code (char ch) -> short} that calls
     *      {@code this.call(b, ch)} and returns the result.
     */
    @Override
    default net.mintern.functions.unary.CharToShort bind(byte b) {
        return ByteCharToShort.bind(this, b);
    }

    /**
     * Binds {@code (ch)} to the end of {@code f}, returning a new function
     * of type {@code (byte) -> short}.
     *
     * @param f the unbound function
     * @param ch argument 2
     * @return a new function {@code (byte b) -> short} that calls
     *      {@code f.call(b, ch)} and returns the result.
     */
    static  net.mintern.functions.unary.ByteToShort
    rbind(ByteCharToShort f, char ch) {
        return (b) -> f.call(b, ch);
    }

    /**
     * Binds {@code (ch)} to the end of {@code this}, returning a new function
     * of type {@code (byte) -> short}.
     *
     * @param ch argument 2
     * @return a new function {@code (byte b) -> short} that calls
     *      {@code this.call(b, ch)} and returns the result.
     */
    @Override
    default net.mintern.functions.unary.ByteToShort rbind(char ch) {
        return ByteCharToShort.rbind(this, ch);
    }

    /**
     * Binds {@code (b, ch)} to {@code f}, returning a new function
     * of type {@code () -> short}.
     *
     * @param f the unbound function
     * @param b argument 1
     * @param ch argument 2
     * @return a new function {@code () -> short} that calls
     *      {@code f.call(b, ch)} and returns the result.
     */
    static  net.mintern.functions.nullary.NilToShort
    bind(ByteCharToShort f, byte b, char ch) {
        return () -> f.call(b, ch);
    }

    /**
     * Binds {@code (b, ch)} to {@code this}, returning a new function
     * of type {@code () -> short}.
     *
     * @param b argument 1
     * @param ch argument 2
     * @return a new function {@code () -> short} that calls
     *      {@code this.call(b, ch)} and returns the result.
     */
    @Override
    default net.mintern.functions.nullary.NilToShort bind(byte b, char ch) {
        return ByteCharToShort.bind(this, b, ch);
    }
}
