package net.mintern.functions.binary;

/**
 * An operation of type {@code (byte, float) -> short}.
 *
 */
@FunctionalInterface
public interface ByteFloatToShort extends
        net.mintern.functions.binary.checked.ByteFloatToShortE<RuntimeException> {

    /**
     * Returns a wrapped version of {@code f} that uses {@code toRuntime} to convert any checked
     * {@code Exception} to a {@code RuntimeException}.
     *
     * @param <E> the {@code Exception} type that the operation may throw
     * @param toRuntime if a checked exception is thrown from
     *      {@link net.mintern.functions.binary.checked.ByteFloatToShortE#call}, then this function
     *      is called in in order to convert it to a {@code RuntimeException}
     * @param f the operation to wrap
     * @return a wrapped version of {@code f} that does not throw checked exceptions
     */
    @SuppressWarnings("unchecked")
    static <E extends Exception> ByteFloatToShort unchecked(
            java.util.function.Function<? super E, RuntimeException> toRuntime,
            net.mintern.functions.binary.checked.ByteFloatToShortE<E> f) {
        return (b, fl) -> {
            try {
                return f.call(b, fl);
            } catch (RuntimeException e) {
                throw e;
            } catch (Exception e) {
                throw toRuntime.apply((E) e);
            }
        };
    }

    /**
     * Returns a wrapped version of {@code f} that wraps any checked {@code Exception} with a
     * {@code RuntimeException}.
     *
     * @param <E> the {@code Exception} type that the operation may throw
     * @param f the operation to wrap
     * @return a wrapped version of {@code f} that does not throw checked exceptions
     */
    static <E extends Exception> ByteFloatToShort unchecked(
            net.mintern.functions.binary.checked.ByteFloatToShortE<E> f) {
        return unchecked(RuntimeException::new, f);
    }

    /**
     * Returns a wrapped version of {@code f} that wraps any {@code IOException} with an
     * {@link java.io.UncheckedIOException}.
     *
     * @param <E> the {@code Exception} type that the operation may throw
     * @param f the operation to wrap
     * @return a wrapped version of {@code f} that throws {@code UncheckedIOException} instead of
     *      {@code IOException}
     */
    static <E extends java.io.IOException> ByteFloatToShort uncheckedIO(
            net.mintern.functions.binary.checked.ByteFloatToShortE<E> f) {
        return unchecked(java.io.UncheckedIOException::new, f);
    }

    /**
     * Binds {@code (b)} to the beginning of {@code f}, returning a new function
     * of type {@code (float) -> short}.
     *
     * @param f the unbound function
     * @param b argument 1
     * @return a new function {@code (float fl) -> short} that calls
     *      {@code f.call(b, fl)} and returns the result.
     */
    static  net.mintern.functions.unary.FloatToShort
    bind(ByteFloatToShort f, byte b) {
        return (fl) -> f.call(b, fl);
    }

    /**
     * Binds {@code (b)} to the beginning of {@code this}, returning a new function
     * of type {@code (float) -> short}.
     *
     * @param b argument 1
     * @return a new function {@code (float fl) -> short} that calls
     *      {@code this.call(b, fl)} and returns the result.
     */
    @Override
    default net.mintern.functions.unary.FloatToShort bind(byte b) {
        return ByteFloatToShort.bind(this, b);
    }

    /**
     * Binds {@code (fl)} to the end of {@code f}, returning a new function
     * of type {@code (byte) -> short}.
     *
     * @param f the unbound function
     * @param fl argument 2
     * @return a new function {@code (byte b) -> short} that calls
     *      {@code f.call(b, fl)} and returns the result.
     */
    static  net.mintern.functions.unary.ByteToShort
    rbind(ByteFloatToShort f, float fl) {
        return (b) -> f.call(b, fl);
    }

    /**
     * Binds {@code (fl)} to the end of {@code this}, returning a new function
     * of type {@code (byte) -> short}.
     *
     * @param fl argument 2
     * @return a new function {@code (byte b) -> short} that calls
     *      {@code this.call(b, fl)} and returns the result.
     */
    @Override
    default net.mintern.functions.unary.ByteToShort rbind(float fl) {
        return ByteFloatToShort.rbind(this, fl);
    }

    /**
     * Binds {@code (b, fl)} to {@code f}, returning a new function
     * of type {@code () -> short}.
     *
     * @param f the unbound function
     * @param b argument 1
     * @param fl argument 2
     * @return a new function {@code () -> short} that calls
     *      {@code f.call(b, fl)} and returns the result.
     */
    static  net.mintern.functions.nullary.NilToShort
    bind(ByteFloatToShort f, byte b, float fl) {
        return () -> f.call(b, fl);
    }

    /**
     * Binds {@code (b, fl)} to {@code this}, returning a new function
     * of type {@code () -> short}.
     *
     * @param b argument 1
     * @param fl argument 2
     * @return a new function {@code () -> short} that calls
     *      {@code this.call(b, fl)} and returns the result.
     */
    @Override
    default net.mintern.functions.nullary.NilToShort bind(byte b, float fl) {
        return ByteFloatToShort.bind(this, b, fl);
    }
}
