package net.mintern.functions.binary;

/**
 * An operation of type {@code (byte, int) -> short}.
 *
 */
@FunctionalInterface
public interface ByteIntToShort extends
        net.mintern.functions.binary.checked.ByteIntToShortE<RuntimeException> {

    /**
     * Returns a wrapped version of {@code f} that uses {@code toRuntime} to convert any checked
     * {@code Exception} to a {@code RuntimeException}.
     *
     * @param <E> the {@code Exception} type that the operation may throw
     * @param toRuntime if a checked exception is thrown from
     *      {@link net.mintern.functions.binary.checked.ByteIntToShortE#call}, then this function
     *      is called in in order to convert it to a {@code RuntimeException}
     * @param f the operation to wrap
     * @return a wrapped version of {@code f} that does not throw checked exceptions
     */
    @SuppressWarnings("unchecked")
    static <E extends Exception> ByteIntToShort unchecked(
            java.util.function.Function<? super E, RuntimeException> toRuntime,
            net.mintern.functions.binary.checked.ByteIntToShortE<E> f) {
        return (b, i) -> {
            try {
                return f.call(b, i);
            } catch (RuntimeException e) {
                throw e;
            } catch (Exception e) {
                throw toRuntime.apply((E) e);
            }
        };
    }

    /**
     * Returns a wrapped version of {@code f} that wraps any checked {@code Exception} with a
     * {@code RuntimeException}.
     *
     * @param <E> the {@code Exception} type that the operation may throw
     * @param f the operation to wrap
     * @return a wrapped version of {@code f} that does not throw checked exceptions
     */
    static <E extends Exception> ByteIntToShort unchecked(
            net.mintern.functions.binary.checked.ByteIntToShortE<E> f) {
        return unchecked(RuntimeException::new, f);
    }

    /**
     * Returns a wrapped version of {@code f} that wraps any {@code IOException} with an
     * {@link java.io.UncheckedIOException}.
     *
     * @param <E> the {@code Exception} type that the operation may throw
     * @param f the operation to wrap
     * @return a wrapped version of {@code f} that throws {@code UncheckedIOException} instead of
     *      {@code IOException}
     */
    static <E extends java.io.IOException> ByteIntToShort uncheckedIO(
            net.mintern.functions.binary.checked.ByteIntToShortE<E> f) {
        return unchecked(java.io.UncheckedIOException::new, f);
    }

    /**
     * Binds {@code (b)} to the beginning of {@code f}, returning a new function
     * of type {@code (int) -> short}.
     *
     * @param f the unbound function
     * @param b argument 1
     * @return a new function {@code (int i) -> short} that calls
     *      {@code f.call(b, i)} and returns the result.
     */
    static  net.mintern.functions.unary.IntToShort
    bind(ByteIntToShort f, byte b) {
        return (i) -> f.call(b, i);
    }

    /**
     * Binds {@code (b)} to the beginning of {@code this}, returning a new function
     * of type {@code (int) -> short}.
     *
     * @param b argument 1
     * @return a new function {@code (int i) -> short} that calls
     *      {@code this.call(b, i)} and returns the result.
     */
    @Override
    default net.mintern.functions.unary.IntToShort bind(byte b) {
        return ByteIntToShort.bind(this, b);
    }

    /**
     * Binds {@code (i)} to the end of {@code f}, returning a new function
     * of type {@code (byte) -> short}.
     *
     * @param f the unbound function
     * @param i argument 2
     * @return a new function {@code (byte b) -> short} that calls
     *      {@code f.call(b, i)} and returns the result.
     */
    static  net.mintern.functions.unary.ByteToShort
    rbind(ByteIntToShort f, int i) {
        return (b) -> f.call(b, i);
    }

    /**
     * Binds {@code (i)} to the end of {@code this}, returning a new function
     * of type {@code (byte) -> short}.
     *
     * @param i argument 2
     * @return a new function {@code (byte b) -> short} that calls
     *      {@code this.call(b, i)} and returns the result.
     */
    @Override
    default net.mintern.functions.unary.ByteToShort rbind(int i) {
        return ByteIntToShort.rbind(this, i);
    }

    /**
     * Binds {@code (b, i)} to {@code f}, returning a new function
     * of type {@code () -> short}.
     *
     * @param f the unbound function
     * @param b argument 1
     * @param i argument 2
     * @return a new function {@code () -> short} that calls
     *      {@code f.call(b, i)} and returns the result.
     */
    static  net.mintern.functions.nullary.NilToShort
    bind(ByteIntToShort f, byte b, int i) {
        return () -> f.call(b, i);
    }

    /**
     * Binds {@code (b, i)} to {@code this}, returning a new function
     * of type {@code () -> short}.
     *
     * @param b argument 1
     * @param i argument 2
     * @return a new function {@code () -> short} that calls
     *      {@code this.call(b, i)} and returns the result.
     */
    @Override
    default net.mintern.functions.nullary.NilToShort bind(byte b, int i) {
        return ByteIntToShort.bind(this, b, i);
    }
}
