package net.mintern.functions.binary;

/**
 * An operation of type {@code (byte, short) -> float}.
 *
 */
@FunctionalInterface
public interface ByteShortToFloat extends
        net.mintern.functions.binary.checked.ByteShortToFloatE<RuntimeException> {

    /**
     * Returns a wrapped version of {@code f} that uses {@code toRuntime} to convert any checked
     * {@code Exception} to a {@code RuntimeException}.
     *
     * @param <E> the {@code Exception} type that the operation may throw
     * @param toRuntime if a checked exception is thrown from
     *      {@link net.mintern.functions.binary.checked.ByteShortToFloatE#call}, then this function
     *      is called in in order to convert it to a {@code RuntimeException}
     * @param f the operation to wrap
     * @return a wrapped version of {@code f} that does not throw checked exceptions
     */
    @SuppressWarnings("unchecked")
    static <E extends Exception> ByteShortToFloat unchecked(
            java.util.function.Function<? super E, RuntimeException> toRuntime,
            net.mintern.functions.binary.checked.ByteShortToFloatE<E> f) {
        return (b, sh) -> {
            try {
                return f.call(b, sh);
            } catch (RuntimeException e) {
                throw e;
            } catch (Exception e) {
                throw toRuntime.apply((E) e);
            }
        };
    }

    /**
     * Returns a wrapped version of {@code f} that wraps any checked {@code Exception} with a
     * {@code RuntimeException}.
     *
     * @param <E> the {@code Exception} type that the operation may throw
     * @param f the operation to wrap
     * @return a wrapped version of {@code f} that does not throw checked exceptions
     */
    static <E extends Exception> ByteShortToFloat unchecked(
            net.mintern.functions.binary.checked.ByteShortToFloatE<E> f) {
        return unchecked(RuntimeException::new, f);
    }

    /**
     * Returns a wrapped version of {@code f} that wraps any {@code IOException} with an
     * {@link java.io.UncheckedIOException}.
     *
     * @param <E> the {@code Exception} type that the operation may throw
     * @param f the operation to wrap
     * @return a wrapped version of {@code f} that throws {@code UncheckedIOException} instead of
     *      {@code IOException}
     */
    static <E extends java.io.IOException> ByteShortToFloat uncheckedIO(
            net.mintern.functions.binary.checked.ByteShortToFloatE<E> f) {
        return unchecked(java.io.UncheckedIOException::new, f);
    }

    /**
     * Binds {@code (b)} to the beginning of {@code f}, returning a new function
     * of type {@code (short) -> float}.
     *
     * @param f the unbound function
     * @param b argument 1
     * @return a new function {@code (short sh) -> float} that calls
     *      {@code f.call(b, sh)} and returns the result.
     */
    static  net.mintern.functions.unary.ShortToFloat
    bind(ByteShortToFloat f, byte b) {
        return (sh) -> f.call(b, sh);
    }

    /**
     * Binds {@code (b)} to the beginning of {@code this}, returning a new function
     * of type {@code (short) -> float}.
     *
     * @param b argument 1
     * @return a new function {@code (short sh) -> float} that calls
     *      {@code this.call(b, sh)} and returns the result.
     */
    @Override
    default net.mintern.functions.unary.ShortToFloat bind(byte b) {
        return ByteShortToFloat.bind(this, b);
    }

    /**
     * Binds {@code (sh)} to the end of {@code f}, returning a new function
     * of type {@code (byte) -> float}.
     *
     * @param f the unbound function
     * @param sh argument 2
     * @return a new function {@code (byte b) -> float} that calls
     *      {@code f.call(b, sh)} and returns the result.
     */
    static  net.mintern.functions.unary.ByteToFloat
    rbind(ByteShortToFloat f, short sh) {
        return (b) -> f.call(b, sh);
    }

    /**
     * Binds {@code (sh)} to the end of {@code this}, returning a new function
     * of type {@code (byte) -> float}.
     *
     * @param sh argument 2
     * @return a new function {@code (byte b) -> float} that calls
     *      {@code this.call(b, sh)} and returns the result.
     */
    @Override
    default net.mintern.functions.unary.ByteToFloat rbind(short sh) {
        return ByteShortToFloat.rbind(this, sh);
    }

    /**
     * Binds {@code (b, sh)} to {@code f}, returning a new function
     * of type {@code () -> float}.
     *
     * @param f the unbound function
     * @param b argument 1
     * @param sh argument 2
     * @return a new function {@code () -> float} that calls
     *      {@code f.call(b, sh)} and returns the result.
     */
    static  net.mintern.functions.nullary.NilToFloat
    bind(ByteShortToFloat f, byte b, short sh) {
        return () -> f.call(b, sh);
    }

    /**
     * Binds {@code (b, sh)} to {@code this}, returning a new function
     * of type {@code () -> float}.
     *
     * @param b argument 1
     * @param sh argument 2
     * @return a new function {@code () -> float} that calls
     *      {@code this.call(b, sh)} and returns the result.
     */
    @Override
    default net.mintern.functions.nullary.NilToFloat bind(byte b, short sh) {
        return ByteShortToFloat.bind(this, b, sh);
    }
}
