package net.mintern.functions.binary;

/**
 * An operation of type {@code (char, byte) -> short}.
 *
 */
@FunctionalInterface
public interface CharByteToShort extends
        net.mintern.functions.binary.checked.CharByteToShortE<RuntimeException> {

    /**
     * Returns a wrapped version of {@code f} that uses {@code toRuntime} to convert any checked
     * {@code Exception} to a {@code RuntimeException}.
     *
     * @param <E> the {@code Exception} type that the operation may throw
     * @param toRuntime if a checked exception is thrown from
     *      {@link net.mintern.functions.binary.checked.CharByteToShortE#call}, then this function
     *      is called in in order to convert it to a {@code RuntimeException}
     * @param f the operation to wrap
     * @return a wrapped version of {@code f} that does not throw checked exceptions
     */
    @SuppressWarnings("unchecked")
    static <E extends Exception> CharByteToShort unchecked(
            java.util.function.Function<? super E, RuntimeException> toRuntime,
            net.mintern.functions.binary.checked.CharByteToShortE<E> f) {
        return (ch, b) -> {
            try {
                return f.call(ch, b);
            } catch (RuntimeException e) {
                throw e;
            } catch (Exception e) {
                throw toRuntime.apply((E) e);
            }
        };
    }

    /**
     * Returns a wrapped version of {@code f} that wraps any checked {@code Exception} with a
     * {@code RuntimeException}.
     *
     * @param <E> the {@code Exception} type that the operation may throw
     * @param f the operation to wrap
     * @return a wrapped version of {@code f} that does not throw checked exceptions
     */
    static <E extends Exception> CharByteToShort unchecked(
            net.mintern.functions.binary.checked.CharByteToShortE<E> f) {
        return unchecked(RuntimeException::new, f);
    }

    /**
     * Returns a wrapped version of {@code f} that wraps any {@code IOException} with an
     * {@link java.io.UncheckedIOException}.
     *
     * @param <E> the {@code Exception} type that the operation may throw
     * @param f the operation to wrap
     * @return a wrapped version of {@code f} that throws {@code UncheckedIOException} instead of
     *      {@code IOException}
     */
    static <E extends java.io.IOException> CharByteToShort uncheckedIO(
            net.mintern.functions.binary.checked.CharByteToShortE<E> f) {
        return unchecked(java.io.UncheckedIOException::new, f);
    }

    /**
     * Binds {@code (ch)} to the beginning of {@code f}, returning a new function
     * of type {@code (byte) -> short}.
     *
     * @param f the unbound function
     * @param ch argument 1
     * @return a new function {@code (byte b) -> short} that calls
     *      {@code f.call(ch, b)} and returns the result.
     */
    static  net.mintern.functions.unary.ByteToShort
    bind(CharByteToShort f, char ch) {
        return (b) -> f.call(ch, b);
    }

    /**
     * Binds {@code (ch)} to the beginning of {@code this}, returning a new function
     * of type {@code (byte) -> short}.
     *
     * @param ch argument 1
     * @return a new function {@code (byte b) -> short} that calls
     *      {@code this.call(ch, b)} and returns the result.
     */
    @Override
    default net.mintern.functions.unary.ByteToShort bind(char ch) {
        return CharByteToShort.bind(this, ch);
    }

    /**
     * Binds {@code (b)} to the end of {@code f}, returning a new function
     * of type {@code (char) -> short}.
     *
     * @param f the unbound function
     * @param b argument 2
     * @return a new function {@code (char ch) -> short} that calls
     *      {@code f.call(ch, b)} and returns the result.
     */
    static  net.mintern.functions.unary.CharToShort
    rbind(CharByteToShort f, byte b) {
        return (ch) -> f.call(ch, b);
    }

    /**
     * Binds {@code (b)} to the end of {@code this}, returning a new function
     * of type {@code (char) -> short}.
     *
     * @param b argument 2
     * @return a new function {@code (char ch) -> short} that calls
     *      {@code this.call(ch, b)} and returns the result.
     */
    @Override
    default net.mintern.functions.unary.CharToShort rbind(byte b) {
        return CharByteToShort.rbind(this, b);
    }

    /**
     * Binds {@code (ch, b)} to {@code f}, returning a new function
     * of type {@code () -> short}.
     *
     * @param f the unbound function
     * @param ch argument 1
     * @param b argument 2
     * @return a new function {@code () -> short} that calls
     *      {@code f.call(ch, b)} and returns the result.
     */
    static  net.mintern.functions.nullary.NilToShort
    bind(CharByteToShort f, char ch, byte b) {
        return () -> f.call(ch, b);
    }

    /**
     * Binds {@code (ch, b)} to {@code this}, returning a new function
     * of type {@code () -> short}.
     *
     * @param ch argument 1
     * @param b argument 2
     * @return a new function {@code () -> short} that calls
     *      {@code this.call(ch, b)} and returns the result.
     */
    @Override
    default net.mintern.functions.nullary.NilToShort bind(char ch, byte b) {
        return CharByteToShort.bind(this, ch, b);
    }
}
