package net.mintern.functions.binary;

/**
 * An operation of type {@code (char, char) -> short}.
 *
 */
@FunctionalInterface
public interface CharCharToShort extends
        net.mintern.functions.binary.checked.CharCharToShortE<RuntimeException> {

    /**
     * Returns a wrapped version of {@code f} that uses {@code toRuntime} to convert any checked
     * {@code Exception} to a {@code RuntimeException}.
     *
     * @param <E> the {@code Exception} type that the operation may throw
     * @param toRuntime if a checked exception is thrown from
     *      {@link net.mintern.functions.binary.checked.CharCharToShortE#call}, then this function
     *      is called in in order to convert it to a {@code RuntimeException}
     * @param f the operation to wrap
     * @return a wrapped version of {@code f} that does not throw checked exceptions
     */
    @SuppressWarnings("unchecked")
    static <E extends Exception> CharCharToShort unchecked(
            java.util.function.Function<? super E, RuntimeException> toRuntime,
            net.mintern.functions.binary.checked.CharCharToShortE<E> f) {
        return (ch1, ch2) -> {
            try {
                return f.call(ch1, ch2);
            } catch (RuntimeException e) {
                throw e;
            } catch (Exception e) {
                throw toRuntime.apply((E) e);
            }
        };
    }

    /**
     * Returns a wrapped version of {@code f} that wraps any checked {@code Exception} with a
     * {@code RuntimeException}.
     *
     * @param <E> the {@code Exception} type that the operation may throw
     * @param f the operation to wrap
     * @return a wrapped version of {@code f} that does not throw checked exceptions
     */
    static <E extends Exception> CharCharToShort unchecked(
            net.mintern.functions.binary.checked.CharCharToShortE<E> f) {
        return unchecked(RuntimeException::new, f);
    }

    /**
     * Returns a wrapped version of {@code f} that wraps any {@code IOException} with an
     * {@link java.io.UncheckedIOException}.
     *
     * @param <E> the {@code Exception} type that the operation may throw
     * @param f the operation to wrap
     * @return a wrapped version of {@code f} that throws {@code UncheckedIOException} instead of
     *      {@code IOException}
     */
    static <E extends java.io.IOException> CharCharToShort uncheckedIO(
            net.mintern.functions.binary.checked.CharCharToShortE<E> f) {
        return unchecked(java.io.UncheckedIOException::new, f);
    }

    /**
     * Binds {@code (ch1)} to the beginning of {@code f}, returning a new function
     * of type {@code (char) -> short}.
     *
     * @param f the unbound function
     * @param ch1 argument 1
     * @return a new function {@code (char ch2) -> short} that calls
     *      {@code f.call(ch1, ch2)} and returns the result.
     */
    static  net.mintern.functions.unary.CharToShort
    bind(CharCharToShort f, char ch1) {
        return (ch2) -> f.call(ch1, ch2);
    }

    /**
     * Binds {@code (ch1)} to the beginning of {@code this}, returning a new function
     * of type {@code (char) -> short}.
     *
     * @param ch1 argument 1
     * @return a new function {@code (char ch2) -> short} that calls
     *      {@code this.call(ch1, ch2)} and returns the result.
     */
    @Override
    default net.mintern.functions.unary.CharToShort bind(char ch1) {
        return CharCharToShort.bind(this, ch1);
    }

    /**
     * Binds {@code (ch2)} to the end of {@code f}, returning a new function
     * of type {@code (char) -> short}.
     *
     * @param f the unbound function
     * @param ch2 argument 2
     * @return a new function {@code (char ch1) -> short} that calls
     *      {@code f.call(ch1, ch2)} and returns the result.
     */
    static  net.mintern.functions.unary.CharToShort
    rbind(CharCharToShort f, char ch2) {
        return (ch1) -> f.call(ch1, ch2);
    }

    /**
     * Binds {@code (ch2)} to the end of {@code this}, returning a new function
     * of type {@code (char) -> short}.
     *
     * @param ch2 argument 2
     * @return a new function {@code (char ch1) -> short} that calls
     *      {@code this.call(ch1, ch2)} and returns the result.
     */
    @Override
    default net.mintern.functions.unary.CharToShort rbind(char ch2) {
        return CharCharToShort.rbind(this, ch2);
    }

    /**
     * Binds {@code (ch1, ch2)} to {@code f}, returning a new function
     * of type {@code () -> short}.
     *
     * @param f the unbound function
     * @param ch1 argument 1
     * @param ch2 argument 2
     * @return a new function {@code () -> short} that calls
     *      {@code f.call(ch1, ch2)} and returns the result.
     */
    static  net.mintern.functions.nullary.NilToShort
    bind(CharCharToShort f, char ch1, char ch2) {
        return () -> f.call(ch1, ch2);
    }

    /**
     * Binds {@code (ch1, ch2)} to {@code this}, returning a new function
     * of type {@code () -> short}.
     *
     * @param ch1 argument 1
     * @param ch2 argument 2
     * @return a new function {@code () -> short} that calls
     *      {@code this.call(ch1, ch2)} and returns the result.
     */
    @Override
    default net.mintern.functions.nullary.NilToShort bind(char ch1, char ch2) {
        return CharCharToShort.bind(this, ch1, ch2);
    }
}
