package net.mintern.functions.binary;

/**
 * An operation of type {@code (char, double) -> short}.
 *
 */
@FunctionalInterface
public interface CharDblToShort extends
        net.mintern.functions.binary.checked.CharDblToShortE<RuntimeException> {

    /**
     * Returns a wrapped version of {@code f} that uses {@code toRuntime} to convert any checked
     * {@code Exception} to a {@code RuntimeException}.
     *
     * @param <E> the {@code Exception} type that the operation may throw
     * @param toRuntime if a checked exception is thrown from
     *      {@link net.mintern.functions.binary.checked.CharDblToShortE#call}, then this function
     *      is called in in order to convert it to a {@code RuntimeException}
     * @param f the operation to wrap
     * @return a wrapped version of {@code f} that does not throw checked exceptions
     */
    @SuppressWarnings("unchecked")
    static <E extends Exception> CharDblToShort unchecked(
            java.util.function.Function<? super E, RuntimeException> toRuntime,
            net.mintern.functions.binary.checked.CharDblToShortE<E> f) {
        return (ch, d) -> {
            try {
                return f.call(ch, d);
            } catch (RuntimeException e) {
                throw e;
            } catch (Exception e) {
                throw toRuntime.apply((E) e);
            }
        };
    }

    /**
     * Returns a wrapped version of {@code f} that wraps any checked {@code Exception} with a
     * {@code RuntimeException}.
     *
     * @param <E> the {@code Exception} type that the operation may throw
     * @param f the operation to wrap
     * @return a wrapped version of {@code f} that does not throw checked exceptions
     */
    static <E extends Exception> CharDblToShort unchecked(
            net.mintern.functions.binary.checked.CharDblToShortE<E> f) {
        return unchecked(RuntimeException::new, f);
    }

    /**
     * Returns a wrapped version of {@code f} that wraps any {@code IOException} with an
     * {@link java.io.UncheckedIOException}.
     *
     * @param <E> the {@code Exception} type that the operation may throw
     * @param f the operation to wrap
     * @return a wrapped version of {@code f} that throws {@code UncheckedIOException} instead of
     *      {@code IOException}
     */
    static <E extends java.io.IOException> CharDblToShort uncheckedIO(
            net.mintern.functions.binary.checked.CharDblToShortE<E> f) {
        return unchecked(java.io.UncheckedIOException::new, f);
    }

    /**
     * Binds {@code (ch)} to the beginning of {@code f}, returning a new function
     * of type {@code (double) -> short}.
     *
     * @param f the unbound function
     * @param ch argument 1
     * @return a new function {@code (double d) -> short} that calls
     *      {@code f.call(ch, d)} and returns the result.
     */
    static  net.mintern.functions.unary.DblToShort
    bind(CharDblToShort f, char ch) {
        return (d) -> f.call(ch, d);
    }

    /**
     * Binds {@code (ch)} to the beginning of {@code this}, returning a new function
     * of type {@code (double) -> short}.
     *
     * @param ch argument 1
     * @return a new function {@code (double d) -> short} that calls
     *      {@code this.call(ch, d)} and returns the result.
     */
    @Override
    default net.mintern.functions.unary.DblToShort bind(char ch) {
        return CharDblToShort.bind(this, ch);
    }

    /**
     * Binds {@code (d)} to the end of {@code f}, returning a new function
     * of type {@code (char) -> short}.
     *
     * @param f the unbound function
     * @param d argument 2
     * @return a new function {@code (char ch) -> short} that calls
     *      {@code f.call(ch, d)} and returns the result.
     */
    static  net.mintern.functions.unary.CharToShort
    rbind(CharDblToShort f, double d) {
        return (ch) -> f.call(ch, d);
    }

    /**
     * Binds {@code (d)} to the end of {@code this}, returning a new function
     * of type {@code (char) -> short}.
     *
     * @param d argument 2
     * @return a new function {@code (char ch) -> short} that calls
     *      {@code this.call(ch, d)} and returns the result.
     */
    @Override
    default net.mintern.functions.unary.CharToShort rbind(double d) {
        return CharDblToShort.rbind(this, d);
    }

    /**
     * Binds {@code (ch, d)} to {@code f}, returning a new function
     * of type {@code () -> short}.
     *
     * @param f the unbound function
     * @param ch argument 1
     * @param d argument 2
     * @return a new function {@code () -> short} that calls
     *      {@code f.call(ch, d)} and returns the result.
     */
    static  net.mintern.functions.nullary.NilToShort
    bind(CharDblToShort f, char ch, double d) {
        return () -> f.call(ch, d);
    }

    /**
     * Binds {@code (ch, d)} to {@code this}, returning a new function
     * of type {@code () -> short}.
     *
     * @param ch argument 1
     * @param d argument 2
     * @return a new function {@code () -> short} that calls
     *      {@code this.call(ch, d)} and returns the result.
     */
    @Override
    default net.mintern.functions.nullary.NilToShort bind(char ch, double d) {
        return CharDblToShort.bind(this, ch, d);
    }
}
