package net.mintern.functions.binary;

/**
 * An operation of type {@code (char, float) -> short}.
 *
 */
@FunctionalInterface
public interface CharFloatToShort extends
        net.mintern.functions.binary.checked.CharFloatToShortE<RuntimeException> {

    /**
     * Returns a wrapped version of {@code f} that uses {@code toRuntime} to convert any checked
     * {@code Exception} to a {@code RuntimeException}.
     *
     * @param <E> the {@code Exception} type that the operation may throw
     * @param toRuntime if a checked exception is thrown from
     *      {@link net.mintern.functions.binary.checked.CharFloatToShortE#call}, then this function
     *      is called in in order to convert it to a {@code RuntimeException}
     * @param f the operation to wrap
     * @return a wrapped version of {@code f} that does not throw checked exceptions
     */
    @SuppressWarnings("unchecked")
    static <E extends Exception> CharFloatToShort unchecked(
            java.util.function.Function<? super E, RuntimeException> toRuntime,
            net.mintern.functions.binary.checked.CharFloatToShortE<E> f) {
        return (ch, fl) -> {
            try {
                return f.call(ch, fl);
            } catch (RuntimeException e) {
                throw e;
            } catch (Exception e) {
                throw toRuntime.apply((E) e);
            }
        };
    }

    /**
     * Returns a wrapped version of {@code f} that wraps any checked {@code Exception} with a
     * {@code RuntimeException}.
     *
     * @param <E> the {@code Exception} type that the operation may throw
     * @param f the operation to wrap
     * @return a wrapped version of {@code f} that does not throw checked exceptions
     */
    static <E extends Exception> CharFloatToShort unchecked(
            net.mintern.functions.binary.checked.CharFloatToShortE<E> f) {
        return unchecked(RuntimeException::new, f);
    }

    /**
     * Returns a wrapped version of {@code f} that wraps any {@code IOException} with an
     * {@link java.io.UncheckedIOException}.
     *
     * @param <E> the {@code Exception} type that the operation may throw
     * @param f the operation to wrap
     * @return a wrapped version of {@code f} that throws {@code UncheckedIOException} instead of
     *      {@code IOException}
     */
    static <E extends java.io.IOException> CharFloatToShort uncheckedIO(
            net.mintern.functions.binary.checked.CharFloatToShortE<E> f) {
        return unchecked(java.io.UncheckedIOException::new, f);
    }

    /**
     * Binds {@code (ch)} to the beginning of {@code f}, returning a new function
     * of type {@code (float) -> short}.
     *
     * @param f the unbound function
     * @param ch argument 1
     * @return a new function {@code (float fl) -> short} that calls
     *      {@code f.call(ch, fl)} and returns the result.
     */
    static  net.mintern.functions.unary.FloatToShort
    bind(CharFloatToShort f, char ch) {
        return (fl) -> f.call(ch, fl);
    }

    /**
     * Binds {@code (ch)} to the beginning of {@code this}, returning a new function
     * of type {@code (float) -> short}.
     *
     * @param ch argument 1
     * @return a new function {@code (float fl) -> short} that calls
     *      {@code this.call(ch, fl)} and returns the result.
     */
    @Override
    default net.mintern.functions.unary.FloatToShort bind(char ch) {
        return CharFloatToShort.bind(this, ch);
    }

    /**
     * Binds {@code (fl)} to the end of {@code f}, returning a new function
     * of type {@code (char) -> short}.
     *
     * @param f the unbound function
     * @param fl argument 2
     * @return a new function {@code (char ch) -> short} that calls
     *      {@code f.call(ch, fl)} and returns the result.
     */
    static  net.mintern.functions.unary.CharToShort
    rbind(CharFloatToShort f, float fl) {
        return (ch) -> f.call(ch, fl);
    }

    /**
     * Binds {@code (fl)} to the end of {@code this}, returning a new function
     * of type {@code (char) -> short}.
     *
     * @param fl argument 2
     * @return a new function {@code (char ch) -> short} that calls
     *      {@code this.call(ch, fl)} and returns the result.
     */
    @Override
    default net.mintern.functions.unary.CharToShort rbind(float fl) {
        return CharFloatToShort.rbind(this, fl);
    }

    /**
     * Binds {@code (ch, fl)} to {@code f}, returning a new function
     * of type {@code () -> short}.
     *
     * @param f the unbound function
     * @param ch argument 1
     * @param fl argument 2
     * @return a new function {@code () -> short} that calls
     *      {@code f.call(ch, fl)} and returns the result.
     */
    static  net.mintern.functions.nullary.NilToShort
    bind(CharFloatToShort f, char ch, float fl) {
        return () -> f.call(ch, fl);
    }

    /**
     * Binds {@code (ch, fl)} to {@code this}, returning a new function
     * of type {@code () -> short}.
     *
     * @param ch argument 1
     * @param fl argument 2
     * @return a new function {@code () -> short} that calls
     *      {@code this.call(ch, fl)} and returns the result.
     */
    @Override
    default net.mintern.functions.nullary.NilToShort bind(char ch, float fl) {
        return CharFloatToShort.bind(this, ch, fl);
    }
}
