package net.mintern.functions.binary;

/**
 * An operation of type {@code (char, short) -> char}.
 *
 */
@FunctionalInterface
public interface CharShortToChar extends
        net.mintern.functions.binary.checked.CharShortToCharE<RuntimeException> {

    /**
     * Returns a wrapped version of {@code f} that uses {@code toRuntime} to convert any checked
     * {@code Exception} to a {@code RuntimeException}.
     *
     * @param <E> the {@code Exception} type that the operation may throw
     * @param toRuntime if a checked exception is thrown from
     *      {@link net.mintern.functions.binary.checked.CharShortToCharE#call}, then this function
     *      is called in in order to convert it to a {@code RuntimeException}
     * @param f the operation to wrap
     * @return a wrapped version of {@code f} that does not throw checked exceptions
     */
    @SuppressWarnings("unchecked")
    static <E extends Exception> CharShortToChar unchecked(
            java.util.function.Function<? super E, RuntimeException> toRuntime,
            net.mintern.functions.binary.checked.CharShortToCharE<E> f) {
        return (ch, sh) -> {
            try {
                return f.call(ch, sh);
            } catch (RuntimeException e) {
                throw e;
            } catch (Exception e) {
                throw toRuntime.apply((E) e);
            }
        };
    }

    /**
     * Returns a wrapped version of {@code f} that wraps any checked {@code Exception} with a
     * {@code RuntimeException}.
     *
     * @param <E> the {@code Exception} type that the operation may throw
     * @param f the operation to wrap
     * @return a wrapped version of {@code f} that does not throw checked exceptions
     */
    static <E extends Exception> CharShortToChar unchecked(
            net.mintern.functions.binary.checked.CharShortToCharE<E> f) {
        return unchecked(RuntimeException::new, f);
    }

    /**
     * Returns a wrapped version of {@code f} that wraps any {@code IOException} with an
     * {@link java.io.UncheckedIOException}.
     *
     * @param <E> the {@code Exception} type that the operation may throw
     * @param f the operation to wrap
     * @return a wrapped version of {@code f} that throws {@code UncheckedIOException} instead of
     *      {@code IOException}
     */
    static <E extends java.io.IOException> CharShortToChar uncheckedIO(
            net.mintern.functions.binary.checked.CharShortToCharE<E> f) {
        return unchecked(java.io.UncheckedIOException::new, f);
    }

    /**
     * Binds {@code (ch)} to the beginning of {@code f}, returning a new function
     * of type {@code (short) -> char}.
     *
     * @param f the unbound function
     * @param ch argument 1
     * @return a new function {@code (short sh) -> char} that calls
     *      {@code f.call(ch, sh)} and returns the result.
     */
    static  net.mintern.functions.unary.ShortToChar
    bind(CharShortToChar f, char ch) {
        return (sh) -> f.call(ch, sh);
    }

    /**
     * Binds {@code (ch)} to the beginning of {@code this}, returning a new function
     * of type {@code (short) -> char}.
     *
     * @param ch argument 1
     * @return a new function {@code (short sh) -> char} that calls
     *      {@code this.call(ch, sh)} and returns the result.
     */
    @Override
    default net.mintern.functions.unary.ShortToChar bind(char ch) {
        return CharShortToChar.bind(this, ch);
    }

    /**
     * Binds {@code (sh)} to the end of {@code f}, returning a new function
     * of type {@code (char) -> char}.
     *
     * @param f the unbound function
     * @param sh argument 2
     * @return a new function {@code (char ch) -> char} that calls
     *      {@code f.call(ch, sh)} and returns the result.
     */
    static  net.mintern.functions.unary.CharToChar
    rbind(CharShortToChar f, short sh) {
        return (ch) -> f.call(ch, sh);
    }

    /**
     * Binds {@code (sh)} to the end of {@code this}, returning a new function
     * of type {@code (char) -> char}.
     *
     * @param sh argument 2
     * @return a new function {@code (char ch) -> char} that calls
     *      {@code this.call(ch, sh)} and returns the result.
     */
    @Override
    default net.mintern.functions.unary.CharToChar rbind(short sh) {
        return CharShortToChar.rbind(this, sh);
    }

    /**
     * Binds {@code (ch, sh)} to {@code f}, returning a new function
     * of type {@code () -> char}.
     *
     * @param f the unbound function
     * @param ch argument 1
     * @param sh argument 2
     * @return a new function {@code () -> char} that calls
     *      {@code f.call(ch, sh)} and returns the result.
     */
    static  net.mintern.functions.nullary.NilToChar
    bind(CharShortToChar f, char ch, short sh) {
        return () -> f.call(ch, sh);
    }

    /**
     * Binds {@code (ch, sh)} to {@code this}, returning a new function
     * of type {@code () -> char}.
     *
     * @param ch argument 1
     * @param sh argument 2
     * @return a new function {@code () -> char} that calls
     *      {@code this.call(ch, sh)} and returns the result.
     */
    @Override
    default net.mintern.functions.nullary.NilToChar bind(char ch, short sh) {
        return CharShortToChar.bind(this, ch, sh);
    }
}
