package net.mintern.functions.binary;

/**
 * An operation of type {@code (char, short) -> double}.
 *
 */
@FunctionalInterface
public interface CharShortToDbl extends
        net.mintern.functions.binary.checked.CharShortToDblE<RuntimeException> {

    /**
     * Returns a wrapped version of {@code f} that uses {@code toRuntime} to convert any checked
     * {@code Exception} to a {@code RuntimeException}.
     *
     * @param <E> the {@code Exception} type that the operation may throw
     * @param toRuntime if a checked exception is thrown from
     *      {@link net.mintern.functions.binary.checked.CharShortToDblE#call}, then this function
     *      is called in in order to convert it to a {@code RuntimeException}
     * @param f the operation to wrap
     * @return a wrapped version of {@code f} that does not throw checked exceptions
     */
    @SuppressWarnings("unchecked")
    static <E extends Exception> CharShortToDbl unchecked(
            java.util.function.Function<? super E, RuntimeException> toRuntime,
            net.mintern.functions.binary.checked.CharShortToDblE<E> f) {
        return (ch, sh) -> {
            try {
                return f.call(ch, sh);
            } catch (RuntimeException e) {
                throw e;
            } catch (Exception e) {
                throw toRuntime.apply((E) e);
            }
        };
    }

    /**
     * Returns a wrapped version of {@code f} that wraps any checked {@code Exception} with a
     * {@code RuntimeException}.
     *
     * @param <E> the {@code Exception} type that the operation may throw
     * @param f the operation to wrap
     * @return a wrapped version of {@code f} that does not throw checked exceptions
     */
    static <E extends Exception> CharShortToDbl unchecked(
            net.mintern.functions.binary.checked.CharShortToDblE<E> f) {
        return unchecked(RuntimeException::new, f);
    }

    /**
     * Returns a wrapped version of {@code f} that wraps any {@code IOException} with an
     * {@link java.io.UncheckedIOException}.
     *
     * @param <E> the {@code Exception} type that the operation may throw
     * @param f the operation to wrap
     * @return a wrapped version of {@code f} that throws {@code UncheckedIOException} instead of
     *      {@code IOException}
     */
    static <E extends java.io.IOException> CharShortToDbl uncheckedIO(
            net.mintern.functions.binary.checked.CharShortToDblE<E> f) {
        return unchecked(java.io.UncheckedIOException::new, f);
    }

    /**
     * Binds {@code (ch)} to the beginning of {@code f}, returning a new function
     * of type {@code (short) -> double}.
     *
     * @param f the unbound function
     * @param ch argument 1
     * @return a new function {@code (short sh) -> double} that calls
     *      {@code f.call(ch, sh)} and returns the result.
     */
    static  net.mintern.functions.unary.ShortToDbl
    bind(CharShortToDbl f, char ch) {
        return (sh) -> f.call(ch, sh);
    }

    /**
     * Binds {@code (ch)} to the beginning of {@code this}, returning a new function
     * of type {@code (short) -> double}.
     *
     * @param ch argument 1
     * @return a new function {@code (short sh) -> double} that calls
     *      {@code this.call(ch, sh)} and returns the result.
     */
    @Override
    default net.mintern.functions.unary.ShortToDbl bind(char ch) {
        return CharShortToDbl.bind(this, ch);
    }

    /**
     * Binds {@code (sh)} to the end of {@code f}, returning a new function
     * of type {@code (char) -> double}.
     *
     * @param f the unbound function
     * @param sh argument 2
     * @return a new function {@code (char ch) -> double} that calls
     *      {@code f.call(ch, sh)} and returns the result.
     */
    static  net.mintern.functions.unary.CharToDbl
    rbind(CharShortToDbl f, short sh) {
        return (ch) -> f.call(ch, sh);
    }

    /**
     * Binds {@code (sh)} to the end of {@code this}, returning a new function
     * of type {@code (char) -> double}.
     *
     * @param sh argument 2
     * @return a new function {@code (char ch) -> double} that calls
     *      {@code this.call(ch, sh)} and returns the result.
     */
    @Override
    default net.mintern.functions.unary.CharToDbl rbind(short sh) {
        return CharShortToDbl.rbind(this, sh);
    }

    /**
     * Binds {@code (ch, sh)} to {@code f}, returning a new function
     * of type {@code () -> double}.
     *
     * @param f the unbound function
     * @param ch argument 1
     * @param sh argument 2
     * @return a new function {@code () -> double} that calls
     *      {@code f.call(ch, sh)} and returns the result.
     */
    static  net.mintern.functions.nullary.NilToDbl
    bind(CharShortToDbl f, char ch, short sh) {
        return () -> f.call(ch, sh);
    }

    /**
     * Binds {@code (ch, sh)} to {@code this}, returning a new function
     * of type {@code () -> double}.
     *
     * @param ch argument 1
     * @param sh argument 2
     * @return a new function {@code () -> double} that calls
     *      {@code this.call(ch, sh)} and returns the result.
     */
    @Override
    default net.mintern.functions.nullary.NilToDbl bind(char ch, short sh) {
        return CharShortToDbl.bind(this, ch, sh);
    }
}
