package net.mintern.functions.binary;

/**
 * An operation of type {@code (char, short) -> R}.
 *
 * @param <R> the type of the return value
 */
@FunctionalInterface
public interface CharShortToObj<R> extends
        net.mintern.functions.binary.checked.CharShortToObjE<R, RuntimeException> {

    /**
     * Returns a wrapped version of {@code f} that uses {@code toRuntime} to convert any checked
     * {@code Exception} to a {@code RuntimeException}.
     *
     * @param <R> the type of the return value
     * @param <E> the {@code Exception} type that the operation may throw
     * @param toRuntime if a checked exception is thrown from
     *      {@link net.mintern.functions.binary.checked.CharShortToObjE#call}, then this function
     *      is called in in order to convert it to a {@code RuntimeException}
     * @param f the operation to wrap
     * @return a wrapped version of {@code f} that does not throw checked exceptions
     */
    @SuppressWarnings("unchecked")
    static <R, E extends Exception> CharShortToObj<R> unchecked(
            java.util.function.Function<? super E, RuntimeException> toRuntime,
            net.mintern.functions.binary.checked.CharShortToObjE<R, E> f) {
        return (ch, sh) -> {
            try {
                return f.call(ch, sh);
            } catch (RuntimeException e) {
                throw e;
            } catch (Exception e) {
                throw toRuntime.apply((E) e);
            }
        };
    }

    /**
     * Returns a wrapped version of {@code f} that wraps any checked {@code Exception} with a
     * {@code RuntimeException}.
     *
     * @param <R> the type of the return value
     * @param <E> the {@code Exception} type that the operation may throw
     * @param f the operation to wrap
     * @return a wrapped version of {@code f} that does not throw checked exceptions
     */
    static <R, E extends Exception> CharShortToObj<R> unchecked(
            net.mintern.functions.binary.checked.CharShortToObjE<R, E> f) {
        return unchecked(RuntimeException::new, f);
    }

    /**
     * Returns a wrapped version of {@code f} that wraps any {@code IOException} with an
     * {@link java.io.UncheckedIOException}.
     *
     * @param <R> the type of the return value
     * @param <E> the {@code Exception} type that the operation may throw
     * @param f the operation to wrap
     * @return a wrapped version of {@code f} that throws {@code UncheckedIOException} instead of
     *      {@code IOException}
     */
    static <R, E extends java.io.IOException> CharShortToObj<R> uncheckedIO(
            net.mintern.functions.binary.checked.CharShortToObjE<R, E> f) {
        return unchecked(java.io.UncheckedIOException::new, f);
    }

    /**
     * Binds {@code (ch)} to the beginning of {@code f}, returning a new function
     * of type {@code (short) -> R}.
     *
     * @param <R> the type of the return value
     * @param f the unbound function
     * @param ch argument 1
     * @return a new function {@code (short sh) -> R} that calls
     *      {@code f.call(ch, sh)} and returns the result.
     */
    static <R> net.mintern.functions.unary.ShortToObj<R>
    bind(CharShortToObj<R> f, char ch) {
        return (sh) -> f.call(ch, sh);
    }

    /**
     * Binds {@code (ch)} to the beginning of {@code this}, returning a new function
     * of type {@code (short) -> R}.
     *
     * @param ch argument 1
     * @return a new function {@code (short sh) -> R} that calls
     *      {@code this.call(ch, sh)} and returns the result.
     */
    @Override
    default net.mintern.functions.unary.ShortToObj<R> bind(char ch) {
        return CharShortToObj.bind(this, ch);
    }

    /**
     * Binds {@code (sh)} to the end of {@code f}, returning a new function
     * of type {@code (char) -> R}.
     *
     * @param <R> the type of the return value
     * @param f the unbound function
     * @param sh argument 2
     * @return a new function {@code (char ch) -> R} that calls
     *      {@code f.call(ch, sh)} and returns the result.
     */
    static <R> net.mintern.functions.unary.CharToObj<R>
    rbind(CharShortToObj<R> f, short sh) {
        return (ch) -> f.call(ch, sh);
    }

    /**
     * Binds {@code (sh)} to the end of {@code this}, returning a new function
     * of type {@code (char) -> R}.
     *
     * @param sh argument 2
     * @return a new function {@code (char ch) -> R} that calls
     *      {@code this.call(ch, sh)} and returns the result.
     */
    @Override
    default net.mintern.functions.unary.CharToObj<R> rbind(short sh) {
        return CharShortToObj.rbind(this, sh);
    }

    /**
     * Binds {@code (ch, sh)} to {@code f}, returning a new function
     * of type {@code () -> R}.
     *
     * @param <R> the type of the return value
     * @param f the unbound function
     * @param ch argument 1
     * @param sh argument 2
     * @return a new function {@code () -> R} that calls
     *      {@code f.call(ch, sh)} and returns the result.
     */
    static <R> net.mintern.functions.nullary.NilToObj<R>
    bind(CharShortToObj<R> f, char ch, short sh) {
        return () -> f.call(ch, sh);
    }

    /**
     * Binds {@code (ch, sh)} to {@code this}, returning a new function
     * of type {@code () -> R}.
     *
     * @param ch argument 1
     * @param sh argument 2
     * @return a new function {@code () -> R} that calls
     *      {@code this.call(ch, sh)} and returns the result.
     */
    @Override
    default net.mintern.functions.nullary.NilToObj<R> bind(char ch, short sh) {
        return CharShortToObj.bind(this, ch, sh);
    }
}
