package net.mintern.functions.binary;

/**
 * An operation of type {@code (double, boolean) -> short}.
 *
 */
@FunctionalInterface
public interface DblBoolToShort extends
        net.mintern.functions.binary.checked.DblBoolToShortE<RuntimeException> {

    /**
     * Returns a wrapped version of {@code f} that uses {@code toRuntime} to convert any checked
     * {@code Exception} to a {@code RuntimeException}.
     *
     * @param <E> the {@code Exception} type that the operation may throw
     * @param toRuntime if a checked exception is thrown from
     *      {@link net.mintern.functions.binary.checked.DblBoolToShortE#call}, then this function
     *      is called in in order to convert it to a {@code RuntimeException}
     * @param f the operation to wrap
     * @return a wrapped version of {@code f} that does not throw checked exceptions
     */
    @SuppressWarnings("unchecked")
    static <E extends Exception> DblBoolToShort unchecked(
            java.util.function.Function<? super E, RuntimeException> toRuntime,
            net.mintern.functions.binary.checked.DblBoolToShortE<E> f) {
        return (d, bool) -> {
            try {
                return f.call(d, bool);
            } catch (RuntimeException e) {
                throw e;
            } catch (Exception e) {
                throw toRuntime.apply((E) e);
            }
        };
    }

    /**
     * Returns a wrapped version of {@code f} that wraps any checked {@code Exception} with a
     * {@code RuntimeException}.
     *
     * @param <E> the {@code Exception} type that the operation may throw
     * @param f the operation to wrap
     * @return a wrapped version of {@code f} that does not throw checked exceptions
     */
    static <E extends Exception> DblBoolToShort unchecked(
            net.mintern.functions.binary.checked.DblBoolToShortE<E> f) {
        return unchecked(RuntimeException::new, f);
    }

    /**
     * Returns a wrapped version of {@code f} that wraps any {@code IOException} with an
     * {@link java.io.UncheckedIOException}.
     *
     * @param <E> the {@code Exception} type that the operation may throw
     * @param f the operation to wrap
     * @return a wrapped version of {@code f} that throws {@code UncheckedIOException} instead of
     *      {@code IOException}
     */
    static <E extends java.io.IOException> DblBoolToShort uncheckedIO(
            net.mintern.functions.binary.checked.DblBoolToShortE<E> f) {
        return unchecked(java.io.UncheckedIOException::new, f);
    }

    /**
     * Binds {@code (d)} to the beginning of {@code f}, returning a new function
     * of type {@code (boolean) -> short}.
     *
     * @param f the unbound function
     * @param d argument 1
     * @return a new function {@code (boolean bool) -> short} that calls
     *      {@code f.call(d, bool)} and returns the result.
     */
    static  net.mintern.functions.unary.BoolToShort
    bind(DblBoolToShort f, double d) {
        return (bool) -> f.call(d, bool);
    }

    /**
     * Binds {@code (d)} to the beginning of {@code this}, returning a new function
     * of type {@code (boolean) -> short}.
     *
     * @param d argument 1
     * @return a new function {@code (boolean bool) -> short} that calls
     *      {@code this.call(d, bool)} and returns the result.
     */
    @Override
    default net.mintern.functions.unary.BoolToShort bind(double d) {
        return DblBoolToShort.bind(this, d);
    }

    /**
     * Binds {@code (bool)} to the end of {@code f}, returning a new function
     * of type {@code (double) -> short}.
     *
     * @param f the unbound function
     * @param bool argument 2
     * @return a new function {@code (double d) -> short} that calls
     *      {@code f.call(d, bool)} and returns the result.
     */
    static  net.mintern.functions.unary.DblToShort
    rbind(DblBoolToShort f, boolean bool) {
        return (d) -> f.call(d, bool);
    }

    /**
     * Binds {@code (bool)} to the end of {@code this}, returning a new function
     * of type {@code (double) -> short}.
     *
     * @param bool argument 2
     * @return a new function {@code (double d) -> short} that calls
     *      {@code this.call(d, bool)} and returns the result.
     */
    @Override
    default net.mintern.functions.unary.DblToShort rbind(boolean bool) {
        return DblBoolToShort.rbind(this, bool);
    }

    /**
     * Binds {@code (d, bool)} to {@code f}, returning a new function
     * of type {@code () -> short}.
     *
     * @param f the unbound function
     * @param d argument 1
     * @param bool argument 2
     * @return a new function {@code () -> short} that calls
     *      {@code f.call(d, bool)} and returns the result.
     */
    static  net.mintern.functions.nullary.NilToShort
    bind(DblBoolToShort f, double d, boolean bool) {
        return () -> f.call(d, bool);
    }

    /**
     * Binds {@code (d, bool)} to {@code this}, returning a new function
     * of type {@code () -> short}.
     *
     * @param d argument 1
     * @param bool argument 2
     * @return a new function {@code () -> short} that calls
     *      {@code this.call(d, bool)} and returns the result.
     */
    @Override
    default net.mintern.functions.nullary.NilToShort bind(double d, boolean bool) {
        return DblBoolToShort.bind(this, d, bool);
    }
}
