package net.mintern.functions.binary;

/**
 * An operation of type {@code (double, char) -> short}.
 *
 */
@FunctionalInterface
public interface DblCharToShort extends
        net.mintern.functions.binary.checked.DblCharToShortE<RuntimeException> {

    /**
     * Returns a wrapped version of {@code f} that uses {@code toRuntime} to convert any checked
     * {@code Exception} to a {@code RuntimeException}.
     *
     * @param <E> the {@code Exception} type that the operation may throw
     * @param toRuntime if a checked exception is thrown from
     *      {@link net.mintern.functions.binary.checked.DblCharToShortE#call}, then this function
     *      is called in in order to convert it to a {@code RuntimeException}
     * @param f the operation to wrap
     * @return a wrapped version of {@code f} that does not throw checked exceptions
     */
    @SuppressWarnings("unchecked")
    static <E extends Exception> DblCharToShort unchecked(
            java.util.function.Function<? super E, RuntimeException> toRuntime,
            net.mintern.functions.binary.checked.DblCharToShortE<E> f) {
        return (d, ch) -> {
            try {
                return f.call(d, ch);
            } catch (RuntimeException e) {
                throw e;
            } catch (Exception e) {
                throw toRuntime.apply((E) e);
            }
        };
    }

    /**
     * Returns a wrapped version of {@code f} that wraps any checked {@code Exception} with a
     * {@code RuntimeException}.
     *
     * @param <E> the {@code Exception} type that the operation may throw
     * @param f the operation to wrap
     * @return a wrapped version of {@code f} that does not throw checked exceptions
     */
    static <E extends Exception> DblCharToShort unchecked(
            net.mintern.functions.binary.checked.DblCharToShortE<E> f) {
        return unchecked(RuntimeException::new, f);
    }

    /**
     * Returns a wrapped version of {@code f} that wraps any {@code IOException} with an
     * {@link java.io.UncheckedIOException}.
     *
     * @param <E> the {@code Exception} type that the operation may throw
     * @param f the operation to wrap
     * @return a wrapped version of {@code f} that throws {@code UncheckedIOException} instead of
     *      {@code IOException}
     */
    static <E extends java.io.IOException> DblCharToShort uncheckedIO(
            net.mintern.functions.binary.checked.DblCharToShortE<E> f) {
        return unchecked(java.io.UncheckedIOException::new, f);
    }

    /**
     * Binds {@code (d)} to the beginning of {@code f}, returning a new function
     * of type {@code (char) -> short}.
     *
     * @param f the unbound function
     * @param d argument 1
     * @return a new function {@code (char ch) -> short} that calls
     *      {@code f.call(d, ch)} and returns the result.
     */
    static  net.mintern.functions.unary.CharToShort
    bind(DblCharToShort f, double d) {
        return (ch) -> f.call(d, ch);
    }

    /**
     * Binds {@code (d)} to the beginning of {@code this}, returning a new function
     * of type {@code (char) -> short}.
     *
     * @param d argument 1
     * @return a new function {@code (char ch) -> short} that calls
     *      {@code this.call(d, ch)} and returns the result.
     */
    @Override
    default net.mintern.functions.unary.CharToShort bind(double d) {
        return DblCharToShort.bind(this, d);
    }

    /**
     * Binds {@code (ch)} to the end of {@code f}, returning a new function
     * of type {@code (double) -> short}.
     *
     * @param f the unbound function
     * @param ch argument 2
     * @return a new function {@code (double d) -> short} that calls
     *      {@code f.call(d, ch)} and returns the result.
     */
    static  net.mintern.functions.unary.DblToShort
    rbind(DblCharToShort f, char ch) {
        return (d) -> f.call(d, ch);
    }

    /**
     * Binds {@code (ch)} to the end of {@code this}, returning a new function
     * of type {@code (double) -> short}.
     *
     * @param ch argument 2
     * @return a new function {@code (double d) -> short} that calls
     *      {@code this.call(d, ch)} and returns the result.
     */
    @Override
    default net.mintern.functions.unary.DblToShort rbind(char ch) {
        return DblCharToShort.rbind(this, ch);
    }

    /**
     * Binds {@code (d, ch)} to {@code f}, returning a new function
     * of type {@code () -> short}.
     *
     * @param f the unbound function
     * @param d argument 1
     * @param ch argument 2
     * @return a new function {@code () -> short} that calls
     *      {@code f.call(d, ch)} and returns the result.
     */
    static  net.mintern.functions.nullary.NilToShort
    bind(DblCharToShort f, double d, char ch) {
        return () -> f.call(d, ch);
    }

    /**
     * Binds {@code (d, ch)} to {@code this}, returning a new function
     * of type {@code () -> short}.
     *
     * @param d argument 1
     * @param ch argument 2
     * @return a new function {@code () -> short} that calls
     *      {@code this.call(d, ch)} and returns the result.
     */
    @Override
    default net.mintern.functions.nullary.NilToShort bind(double d, char ch) {
        return DblCharToShort.bind(this, d, ch);
    }
}
