package net.mintern.functions.binary;

/**
 * An operation of type {@code (double, double) -> short}.
 *
 */
@FunctionalInterface
public interface DblDblToShort extends
        net.mintern.functions.binary.checked.DblDblToShortE<RuntimeException> {

    /**
     * Returns a wrapped version of {@code f} that uses {@code toRuntime} to convert any checked
     * {@code Exception} to a {@code RuntimeException}.
     *
     * @param <E> the {@code Exception} type that the operation may throw
     * @param toRuntime if a checked exception is thrown from
     *      {@link net.mintern.functions.binary.checked.DblDblToShortE#call}, then this function
     *      is called in in order to convert it to a {@code RuntimeException}
     * @param f the operation to wrap
     * @return a wrapped version of {@code f} that does not throw checked exceptions
     */
    @SuppressWarnings("unchecked")
    static <E extends Exception> DblDblToShort unchecked(
            java.util.function.Function<? super E, RuntimeException> toRuntime,
            net.mintern.functions.binary.checked.DblDblToShortE<E> f) {
        return (d1, d2) -> {
            try {
                return f.call(d1, d2);
            } catch (RuntimeException e) {
                throw e;
            } catch (Exception e) {
                throw toRuntime.apply((E) e);
            }
        };
    }

    /**
     * Returns a wrapped version of {@code f} that wraps any checked {@code Exception} with a
     * {@code RuntimeException}.
     *
     * @param <E> the {@code Exception} type that the operation may throw
     * @param f the operation to wrap
     * @return a wrapped version of {@code f} that does not throw checked exceptions
     */
    static <E extends Exception> DblDblToShort unchecked(
            net.mintern.functions.binary.checked.DblDblToShortE<E> f) {
        return unchecked(RuntimeException::new, f);
    }

    /**
     * Returns a wrapped version of {@code f} that wraps any {@code IOException} with an
     * {@link java.io.UncheckedIOException}.
     *
     * @param <E> the {@code Exception} type that the operation may throw
     * @param f the operation to wrap
     * @return a wrapped version of {@code f} that throws {@code UncheckedIOException} instead of
     *      {@code IOException}
     */
    static <E extends java.io.IOException> DblDblToShort uncheckedIO(
            net.mintern.functions.binary.checked.DblDblToShortE<E> f) {
        return unchecked(java.io.UncheckedIOException::new, f);
    }

    /**
     * Binds {@code (d1)} to the beginning of {@code f}, returning a new function
     * of type {@code (double) -> short}.
     *
     * @param f the unbound function
     * @param d1 argument 1
     * @return a new function {@code (double d2) -> short} that calls
     *      {@code f.call(d1, d2)} and returns the result.
     */
    static  net.mintern.functions.unary.DblToShort
    bind(DblDblToShort f, double d1) {
        return (d2) -> f.call(d1, d2);
    }

    /**
     * Binds {@code (d1)} to the beginning of {@code this}, returning a new function
     * of type {@code (double) -> short}.
     *
     * @param d1 argument 1
     * @return a new function {@code (double d2) -> short} that calls
     *      {@code this.call(d1, d2)} and returns the result.
     */
    @Override
    default net.mintern.functions.unary.DblToShort bind(double d1) {
        return DblDblToShort.bind(this, d1);
    }

    /**
     * Binds {@code (d2)} to the end of {@code f}, returning a new function
     * of type {@code (double) -> short}.
     *
     * @param f the unbound function
     * @param d2 argument 2
     * @return a new function {@code (double d1) -> short} that calls
     *      {@code f.call(d1, d2)} and returns the result.
     */
    static  net.mintern.functions.unary.DblToShort
    rbind(DblDblToShort f, double d2) {
        return (d1) -> f.call(d1, d2);
    }

    /**
     * Binds {@code (d2)} to the end of {@code this}, returning a new function
     * of type {@code (double) -> short}.
     *
     * @param d2 argument 2
     * @return a new function {@code (double d1) -> short} that calls
     *      {@code this.call(d1, d2)} and returns the result.
     */
    @Override
    default net.mintern.functions.unary.DblToShort rbind(double d2) {
        return DblDblToShort.rbind(this, d2);
    }

    /**
     * Binds {@code (d1, d2)} to {@code f}, returning a new function
     * of type {@code () -> short}.
     *
     * @param f the unbound function
     * @param d1 argument 1
     * @param d2 argument 2
     * @return a new function {@code () -> short} that calls
     *      {@code f.call(d1, d2)} and returns the result.
     */
    static  net.mintern.functions.nullary.NilToShort
    bind(DblDblToShort f, double d1, double d2) {
        return () -> f.call(d1, d2);
    }

    /**
     * Binds {@code (d1, d2)} to {@code this}, returning a new function
     * of type {@code () -> short}.
     *
     * @param d1 argument 1
     * @param d2 argument 2
     * @return a new function {@code () -> short} that calls
     *      {@code this.call(d1, d2)} and returns the result.
     */
    @Override
    default net.mintern.functions.nullary.NilToShort bind(double d1, double d2) {
        return DblDblToShort.bind(this, d1, d2);
    }
}
