package net.mintern.functions.binary;

/**
 * An operation of type {@code (double, float) -> short}.
 *
 */
@FunctionalInterface
public interface DblFloatToShort extends
        net.mintern.functions.binary.checked.DblFloatToShortE<RuntimeException> {

    /**
     * Returns a wrapped version of {@code f} that uses {@code toRuntime} to convert any checked
     * {@code Exception} to a {@code RuntimeException}.
     *
     * @param <E> the {@code Exception} type that the operation may throw
     * @param toRuntime if a checked exception is thrown from
     *      {@link net.mintern.functions.binary.checked.DblFloatToShortE#call}, then this function
     *      is called in in order to convert it to a {@code RuntimeException}
     * @param f the operation to wrap
     * @return a wrapped version of {@code f} that does not throw checked exceptions
     */
    @SuppressWarnings("unchecked")
    static <E extends Exception> DblFloatToShort unchecked(
            java.util.function.Function<? super E, RuntimeException> toRuntime,
            net.mintern.functions.binary.checked.DblFloatToShortE<E> f) {
        return (d, fl) -> {
            try {
                return f.call(d, fl);
            } catch (RuntimeException e) {
                throw e;
            } catch (Exception e) {
                throw toRuntime.apply((E) e);
            }
        };
    }

    /**
     * Returns a wrapped version of {@code f} that wraps any checked {@code Exception} with a
     * {@code RuntimeException}.
     *
     * @param <E> the {@code Exception} type that the operation may throw
     * @param f the operation to wrap
     * @return a wrapped version of {@code f} that does not throw checked exceptions
     */
    static <E extends Exception> DblFloatToShort unchecked(
            net.mintern.functions.binary.checked.DblFloatToShortE<E> f) {
        return unchecked(RuntimeException::new, f);
    }

    /**
     * Returns a wrapped version of {@code f} that wraps any {@code IOException} with an
     * {@link java.io.UncheckedIOException}.
     *
     * @param <E> the {@code Exception} type that the operation may throw
     * @param f the operation to wrap
     * @return a wrapped version of {@code f} that throws {@code UncheckedIOException} instead of
     *      {@code IOException}
     */
    static <E extends java.io.IOException> DblFloatToShort uncheckedIO(
            net.mintern.functions.binary.checked.DblFloatToShortE<E> f) {
        return unchecked(java.io.UncheckedIOException::new, f);
    }

    /**
     * Binds {@code (d)} to the beginning of {@code f}, returning a new function
     * of type {@code (float) -> short}.
     *
     * @param f the unbound function
     * @param d argument 1
     * @return a new function {@code (float fl) -> short} that calls
     *      {@code f.call(d, fl)} and returns the result.
     */
    static  net.mintern.functions.unary.FloatToShort
    bind(DblFloatToShort f, double d) {
        return (fl) -> f.call(d, fl);
    }

    /**
     * Binds {@code (d)} to the beginning of {@code this}, returning a new function
     * of type {@code (float) -> short}.
     *
     * @param d argument 1
     * @return a new function {@code (float fl) -> short} that calls
     *      {@code this.call(d, fl)} and returns the result.
     */
    @Override
    default net.mintern.functions.unary.FloatToShort bind(double d) {
        return DblFloatToShort.bind(this, d);
    }

    /**
     * Binds {@code (fl)} to the end of {@code f}, returning a new function
     * of type {@code (double) -> short}.
     *
     * @param f the unbound function
     * @param fl argument 2
     * @return a new function {@code (double d) -> short} that calls
     *      {@code f.call(d, fl)} and returns the result.
     */
    static  net.mintern.functions.unary.DblToShort
    rbind(DblFloatToShort f, float fl) {
        return (d) -> f.call(d, fl);
    }

    /**
     * Binds {@code (fl)} to the end of {@code this}, returning a new function
     * of type {@code (double) -> short}.
     *
     * @param fl argument 2
     * @return a new function {@code (double d) -> short} that calls
     *      {@code this.call(d, fl)} and returns the result.
     */
    @Override
    default net.mintern.functions.unary.DblToShort rbind(float fl) {
        return DblFloatToShort.rbind(this, fl);
    }

    /**
     * Binds {@code (d, fl)} to {@code f}, returning a new function
     * of type {@code () -> short}.
     *
     * @param f the unbound function
     * @param d argument 1
     * @param fl argument 2
     * @return a new function {@code () -> short} that calls
     *      {@code f.call(d, fl)} and returns the result.
     */
    static  net.mintern.functions.nullary.NilToShort
    bind(DblFloatToShort f, double d, float fl) {
        return () -> f.call(d, fl);
    }

    /**
     * Binds {@code (d, fl)} to {@code this}, returning a new function
     * of type {@code () -> short}.
     *
     * @param d argument 1
     * @param fl argument 2
     * @return a new function {@code () -> short} that calls
     *      {@code this.call(d, fl)} and returns the result.
     */
    @Override
    default net.mintern.functions.nullary.NilToShort bind(double d, float fl) {
        return DblFloatToShort.bind(this, d, fl);
    }
}
