package net.mintern.functions.binary;

/**
 * An operation of type {@code (double, int) -> short}.
 *
 */
@FunctionalInterface
public interface DblIntToShort extends
        net.mintern.functions.binary.checked.DblIntToShortE<RuntimeException> {

    /**
     * Returns a wrapped version of {@code f} that uses {@code toRuntime} to convert any checked
     * {@code Exception} to a {@code RuntimeException}.
     *
     * @param <E> the {@code Exception} type that the operation may throw
     * @param toRuntime if a checked exception is thrown from
     *      {@link net.mintern.functions.binary.checked.DblIntToShortE#call}, then this function
     *      is called in in order to convert it to a {@code RuntimeException}
     * @param f the operation to wrap
     * @return a wrapped version of {@code f} that does not throw checked exceptions
     */
    @SuppressWarnings("unchecked")
    static <E extends Exception> DblIntToShort unchecked(
            java.util.function.Function<? super E, RuntimeException> toRuntime,
            net.mintern.functions.binary.checked.DblIntToShortE<E> f) {
        return (d, i) -> {
            try {
                return f.call(d, i);
            } catch (RuntimeException e) {
                throw e;
            } catch (Exception e) {
                throw toRuntime.apply((E) e);
            }
        };
    }

    /**
     * Returns a wrapped version of {@code f} that wraps any checked {@code Exception} with a
     * {@code RuntimeException}.
     *
     * @param <E> the {@code Exception} type that the operation may throw
     * @param f the operation to wrap
     * @return a wrapped version of {@code f} that does not throw checked exceptions
     */
    static <E extends Exception> DblIntToShort unchecked(
            net.mintern.functions.binary.checked.DblIntToShortE<E> f) {
        return unchecked(RuntimeException::new, f);
    }

    /**
     * Returns a wrapped version of {@code f} that wraps any {@code IOException} with an
     * {@link java.io.UncheckedIOException}.
     *
     * @param <E> the {@code Exception} type that the operation may throw
     * @param f the operation to wrap
     * @return a wrapped version of {@code f} that throws {@code UncheckedIOException} instead of
     *      {@code IOException}
     */
    static <E extends java.io.IOException> DblIntToShort uncheckedIO(
            net.mintern.functions.binary.checked.DblIntToShortE<E> f) {
        return unchecked(java.io.UncheckedIOException::new, f);
    }

    /**
     * Binds {@code (d)} to the beginning of {@code f}, returning a new function
     * of type {@code (int) -> short}.
     *
     * @param f the unbound function
     * @param d argument 1
     * @return a new function {@code (int i) -> short} that calls
     *      {@code f.call(d, i)} and returns the result.
     */
    static  net.mintern.functions.unary.IntToShort
    bind(DblIntToShort f, double d) {
        return (i) -> f.call(d, i);
    }

    /**
     * Binds {@code (d)} to the beginning of {@code this}, returning a new function
     * of type {@code (int) -> short}.
     *
     * @param d argument 1
     * @return a new function {@code (int i) -> short} that calls
     *      {@code this.call(d, i)} and returns the result.
     */
    @Override
    default net.mintern.functions.unary.IntToShort bind(double d) {
        return DblIntToShort.bind(this, d);
    }

    /**
     * Binds {@code (i)} to the end of {@code f}, returning a new function
     * of type {@code (double) -> short}.
     *
     * @param f the unbound function
     * @param i argument 2
     * @return a new function {@code (double d) -> short} that calls
     *      {@code f.call(d, i)} and returns the result.
     */
    static  net.mintern.functions.unary.DblToShort
    rbind(DblIntToShort f, int i) {
        return (d) -> f.call(d, i);
    }

    /**
     * Binds {@code (i)} to the end of {@code this}, returning a new function
     * of type {@code (double) -> short}.
     *
     * @param i argument 2
     * @return a new function {@code (double d) -> short} that calls
     *      {@code this.call(d, i)} and returns the result.
     */
    @Override
    default net.mintern.functions.unary.DblToShort rbind(int i) {
        return DblIntToShort.rbind(this, i);
    }

    /**
     * Binds {@code (d, i)} to {@code f}, returning a new function
     * of type {@code () -> short}.
     *
     * @param f the unbound function
     * @param d argument 1
     * @param i argument 2
     * @return a new function {@code () -> short} that calls
     *      {@code f.call(d, i)} and returns the result.
     */
    static  net.mintern.functions.nullary.NilToShort
    bind(DblIntToShort f, double d, int i) {
        return () -> f.call(d, i);
    }

    /**
     * Binds {@code (d, i)} to {@code this}, returning a new function
     * of type {@code () -> short}.
     *
     * @param d argument 1
     * @param i argument 2
     * @return a new function {@code () -> short} that calls
     *      {@code this.call(d, i)} and returns the result.
     */
    @Override
    default net.mintern.functions.nullary.NilToShort bind(double d, int i) {
        return DblIntToShort.bind(this, d, i);
    }
}
