package net.mintern.functions.binary;

/**
 * An operation of type {@code (double, long) -> short}.
 *
 */
@FunctionalInterface
public interface DblLongToShort extends
        net.mintern.functions.binary.checked.DblLongToShortE<RuntimeException> {

    /**
     * Returns a wrapped version of {@code f} that uses {@code toRuntime} to convert any checked
     * {@code Exception} to a {@code RuntimeException}.
     *
     * @param <E> the {@code Exception} type that the operation may throw
     * @param toRuntime if a checked exception is thrown from
     *      {@link net.mintern.functions.binary.checked.DblLongToShortE#call}, then this function
     *      is called in in order to convert it to a {@code RuntimeException}
     * @param f the operation to wrap
     * @return a wrapped version of {@code f} that does not throw checked exceptions
     */
    @SuppressWarnings("unchecked")
    static <E extends Exception> DblLongToShort unchecked(
            java.util.function.Function<? super E, RuntimeException> toRuntime,
            net.mintern.functions.binary.checked.DblLongToShortE<E> f) {
        return (d, l) -> {
            try {
                return f.call(d, l);
            } catch (RuntimeException e) {
                throw e;
            } catch (Exception e) {
                throw toRuntime.apply((E) e);
            }
        };
    }

    /**
     * Returns a wrapped version of {@code f} that wraps any checked {@code Exception} with a
     * {@code RuntimeException}.
     *
     * @param <E> the {@code Exception} type that the operation may throw
     * @param f the operation to wrap
     * @return a wrapped version of {@code f} that does not throw checked exceptions
     */
    static <E extends Exception> DblLongToShort unchecked(
            net.mintern.functions.binary.checked.DblLongToShortE<E> f) {
        return unchecked(RuntimeException::new, f);
    }

    /**
     * Returns a wrapped version of {@code f} that wraps any {@code IOException} with an
     * {@link java.io.UncheckedIOException}.
     *
     * @param <E> the {@code Exception} type that the operation may throw
     * @param f the operation to wrap
     * @return a wrapped version of {@code f} that throws {@code UncheckedIOException} instead of
     *      {@code IOException}
     */
    static <E extends java.io.IOException> DblLongToShort uncheckedIO(
            net.mintern.functions.binary.checked.DblLongToShortE<E> f) {
        return unchecked(java.io.UncheckedIOException::new, f);
    }

    /**
     * Binds {@code (d)} to the beginning of {@code f}, returning a new function
     * of type {@code (long) -> short}.
     *
     * @param f the unbound function
     * @param d argument 1
     * @return a new function {@code (long l) -> short} that calls
     *      {@code f.call(d, l)} and returns the result.
     */
    static  net.mintern.functions.unary.LongToShort
    bind(DblLongToShort f, double d) {
        return (l) -> f.call(d, l);
    }

    /**
     * Binds {@code (d)} to the beginning of {@code this}, returning a new function
     * of type {@code (long) -> short}.
     *
     * @param d argument 1
     * @return a new function {@code (long l) -> short} that calls
     *      {@code this.call(d, l)} and returns the result.
     */
    @Override
    default net.mintern.functions.unary.LongToShort bind(double d) {
        return DblLongToShort.bind(this, d);
    }

    /**
     * Binds {@code (l)} to the end of {@code f}, returning a new function
     * of type {@code (double) -> short}.
     *
     * @param f the unbound function
     * @param l argument 2
     * @return a new function {@code (double d) -> short} that calls
     *      {@code f.call(d, l)} and returns the result.
     */
    static  net.mintern.functions.unary.DblToShort
    rbind(DblLongToShort f, long l) {
        return (d) -> f.call(d, l);
    }

    /**
     * Binds {@code (l)} to the end of {@code this}, returning a new function
     * of type {@code (double) -> short}.
     *
     * @param l argument 2
     * @return a new function {@code (double d) -> short} that calls
     *      {@code this.call(d, l)} and returns the result.
     */
    @Override
    default net.mintern.functions.unary.DblToShort rbind(long l) {
        return DblLongToShort.rbind(this, l);
    }

    /**
     * Binds {@code (d, l)} to {@code f}, returning a new function
     * of type {@code () -> short}.
     *
     * @param f the unbound function
     * @param d argument 1
     * @param l argument 2
     * @return a new function {@code () -> short} that calls
     *      {@code f.call(d, l)} and returns the result.
     */
    static  net.mintern.functions.nullary.NilToShort
    bind(DblLongToShort f, double d, long l) {
        return () -> f.call(d, l);
    }

    /**
     * Binds {@code (d, l)} to {@code this}, returning a new function
     * of type {@code () -> short}.
     *
     * @param d argument 1
     * @param l argument 2
     * @return a new function {@code () -> short} that calls
     *      {@code this.call(d, l)} and returns the result.
     */
    @Override
    default net.mintern.functions.nullary.NilToShort bind(double d, long l) {
        return DblLongToShort.bind(this, d, l);
    }
}
